/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import io.trino.sql.planner.BuildSideJoinPlanVisitor;
import io.trino.sql.planner.SubPlan;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.RemoteSourceNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class TopologicalOrderSubPlanVisitor {
    private static final SuccessorsFunction<SubPlan> getChildren = subPlan -> {
        Visitor visitor = new Visitor((SubPlan)subPlan);
        subPlan.getFragment().getRoot().accept(visitor, null);
        Preconditions.checkState((boolean)visitor.getSourceSubPlans().isEmpty(), (String)"Some SubNode sources have not been visited: %s", visitor.getSourceSubPlans());
        return visitor.getChildren();
    };

    private TopologicalOrderSubPlanVisitor() {
    }

    public static List<SubPlan> sortPlanInTopologicalOrder(SubPlan subPlan) {
        return ImmutableList.copyOf((Iterable)Traverser.forTree(getChildren).depthFirstPostOrder((Object)subPlan));
    }

    private static class Visitor
    extends BuildSideJoinPlanVisitor<Void> {
        private final SubPlan subPlan;
        private final Map<PlanFragmentId, SubPlan> sourceSubPlans;
        private final ImmutableList.Builder<SubPlan> children = ImmutableList.builder();

        public Visitor(SubPlan subPlan) {
            this.subPlan = subPlan;
            this.sourceSubPlans = subPlan.getChildren().stream().collect(Collectors.toMap(plan -> plan.getFragment().getId(), plan -> plan));
        }

        public Map<PlanFragmentId, SubPlan> getSourceSubPlans() {
            return this.sourceSubPlans;
        }

        public List<SubPlan> getChildren() {
            return this.children.build();
        }

        @Override
        public Void visitRemoteSource(RemoteSourceNode node, Void context) {
            for (PlanFragmentId fragmentId : node.getSourceFragmentIds()) {
                SubPlan child = this.sourceSubPlans.remove(fragmentId);
                Objects.requireNonNull(child, "PlanFragmentId %s does not appear in sources of %s".formatted(fragmentId, this.subPlan));
                this.children.add((Object)child);
            }
            return null;
        }
    }
}

