/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.InListExpression;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.LogicalExpression;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public final class NormalizeOrExpressionRewriter {
    public static Expression normalizeOrExpression(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(), (Expression)expression);
    }

    private NormalizeOrExpressionRewriter() {
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private Visitor() {
        }

        public Expression rewriteLogicalExpression(LogicalExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            List terms = (List)node.getTerms().stream().map(expression -> treeRewriter.rewrite(expression, (Object)context)).collect(ImmutableList.toImmutableList());
            if (node.getOperator() == LogicalExpression.Operator.AND) {
                return ExpressionUtils.and(terms);
            }
            ImmutableList.Builder inPredicateBuilder = ImmutableList.builder();
            ImmutableSet.Builder expressionToSkipBuilder = ImmutableSet.builder();
            ImmutableList.Builder othersExpressionBuilder = ImmutableList.builder();
            this.groupComparisonAndInPredicate(terms).forEach((expression, values) -> {
                if (values.size() > 1) {
                    inPredicateBuilder.add((Object)new InPredicate(expression, (Expression)this.mergeToInListExpression((Collection<Expression>)values)));
                    expressionToSkipBuilder.add(expression);
                }
            });
            ImmutableSet expressionToSkip = expressionToSkipBuilder.build();
            for (Expression expression2 : terms) {
                InPredicate inPredicate;
                ComparisonExpression comparisonExpression;
                if (expression2 instanceof ComparisonExpression && (comparisonExpression = (ComparisonExpression)expression2).getOperator() == ComparisonExpression.Operator.EQUAL) {
                    if (expressionToSkip.contains(comparisonExpression.getLeft())) continue;
                    othersExpressionBuilder.add((Object)expression2);
                    continue;
                }
                if (expression2 instanceof InPredicate && (inPredicate = (InPredicate)expression2).getValueList() instanceof InListExpression) {
                    if (expressionToSkip.contains(inPredicate.getValue())) continue;
                    othersExpressionBuilder.add((Object)expression2);
                    continue;
                }
                othersExpressionBuilder.add((Object)expression2);
            }
            return ExpressionUtils.or((Collection<Expression>)ImmutableList.builder().addAll((Iterable)othersExpressionBuilder.build()).addAll((Iterable)inPredicateBuilder.build()).build());
        }

        private InListExpression mergeToInListExpression(Collection<Expression> expressions) {
            LinkedHashSet<Expression> expressionValues = new LinkedHashSet<Expression>();
            for (Expression expression : expressions) {
                InPredicate inPredicate;
                Expression expression2;
                ComparisonExpression comparisonExpression;
                if (expression instanceof ComparisonExpression && (comparisonExpression = (ComparisonExpression)expression).getOperator() == ComparisonExpression.Operator.EQUAL) {
                    expressionValues.add(comparisonExpression.getRight());
                    continue;
                }
                if (expression instanceof InPredicate && (expression2 = (inPredicate = (InPredicate)expression).getValueList()) instanceof InListExpression) {
                    InListExpression valueList = (InListExpression)expression2;
                    expressionValues.addAll(valueList.getValues());
                    continue;
                }
                throw new IllegalStateException("Unexpected expression: " + expression);
            }
            return new InListExpression((List)ImmutableList.copyOf(expressionValues));
        }

        private Map<Expression, Collection<Expression>> groupComparisonAndInPredicate(List<Expression> terms) {
            ImmutableMultimap.Builder expressionBuilder = ImmutableMultimap.builder();
            for (Expression expression : terms) {
                InPredicate inPredicate;
                ComparisonExpression comparisonExpression;
                if (expression instanceof ComparisonExpression && (comparisonExpression = (ComparisonExpression)expression).getOperator() == ComparisonExpression.Operator.EQUAL) {
                    expressionBuilder.put((Object)comparisonExpression.getLeft(), (Object)comparisonExpression);
                    continue;
                }
                if (!(expression instanceof InPredicate) || !((inPredicate = (InPredicate)expression).getValueList() instanceof InListExpression)) continue;
                expressionBuilder.put((Object)inPredicate.getValue(), (Object)inPredicate);
            }
            return expressionBuilder.build().asMap();
        }
    }
}

