/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.TableHandle;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.AggregationApplicationResult;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Variable;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.ConnectorExpressionTranslator;
import io.trino.sql.planner.ExpressionInterpreter;
import io.trino.sql.planner.LiteralEncoder;
import io.trino.sql.planner.NoOpSymbolResolver;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.Rules;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.SymbolReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;

public class PushAggregationIntoTableScan
implements Rule<AggregationNode> {
    private static final Capture<TableScanNode> TABLE_SCAN = Capture.newCapture();
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().with(Patterns.Aggregation.step().equalTo((Object)AggregationNode.Step.SINGLE)).matching(PushAggregationIntoTableScan::allArgumentsAreSimpleReferences).matching(node -> node.getGroupingSets().getGroupingSetCount() <= 1).matching(PushAggregationIntoTableScan::hasNoMasks).with(Patterns.source().matching(Patterns.tableScan().capturedAs(TABLE_SCAN)));
    private final PlannerContext plannerContext;
    private final TypeAnalyzer typeAnalyzer;

    public PushAggregationIntoTableScan(PlannerContext plannerContext, TypeAnalyzer typeAnalyzer) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isAllowPushdownIntoConnectors(session);
    }

    private static boolean allArgumentsAreSimpleReferences(AggregationNode node) {
        return node.getAggregations().values().stream().flatMap(aggregation -> aggregation.getArguments().stream()).allMatch(SymbolReference.class::isInstance);
    }

    private static boolean hasNoMasks(AggregationNode node) {
        return node.getAggregations().values().stream().allMatch(aggregation -> aggregation.getMask().isEmpty());
    }

    @Override
    public Rule.Result apply(AggregationNode node, Captures captures, Rule.Context context) {
        return PushAggregationIntoTableScan.pushAggregationIntoTableScan(this.plannerContext, this.typeAnalyzer, context, node, (TableScanNode)captures.get(TABLE_SCAN), node.getAggregations(), node.getGroupingSets().getGroupingKeys()).map(Rule.Result::ofPlanNode).orElseGet(Rule.Result::empty);
    }

    public static Optional<PlanNode> pushAggregationIntoTableScan(PlannerContext plannerContext, TypeAnalyzer typeAnalyzer, Rule.Context context, PlanNode aggregationNode, TableScanNode tableScan, Map<Symbol, AggregationNode.Aggregation> aggregations, List<Symbol> groupingKeys) {
        LiteralEncoder literalEncoder = new LiteralEncoder(plannerContext);
        Session session = context.getSession();
        if (groupingKeys.isEmpty() && aggregations.isEmpty()) {
            return Optional.empty();
        }
        Map assignments = (Map)tableScan.getAssignments().entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((Symbol)entry.getKey()).getName(), Map.Entry::getValue));
        ImmutableList aggregationsList = ImmutableList.copyOf(aggregations.entrySet());
        List aggregateFunctions = (List)aggregationsList.stream().map(Map.Entry::getValue).map(aggregation -> PushAggregationIntoTableScan.toAggregateFunction(context, aggregation)).collect(ImmutableList.toImmutableList());
        List aggregationOutputSymbols = (List)aggregationsList.stream().map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
        List groupByColumns = (List)groupingKeys.stream().map(groupByColumn -> (ColumnHandle)assignments.get(groupByColumn.getName())).collect(ImmutableList.toImmutableList());
        Optional<AggregationApplicationResult<TableHandle>> aggregationPushdownResult = plannerContext.getMetadata().applyAggregation(session, tableScan.getTable(), aggregateFunctions, assignments, (List<List<ColumnHandle>>)ImmutableList.of((Object)groupByColumns));
        if (aggregationPushdownResult.isEmpty()) {
            return Optional.empty();
        }
        AggregationApplicationResult<TableHandle> result = aggregationPushdownResult.get();
        ImmutableList.Builder newScanOutputs = ImmutableList.builder();
        newScanOutputs.addAll(tableScan.getOutputSymbols());
        ImmutableBiMap.Builder newScanAssignments = ImmutableBiMap.builder();
        newScanAssignments.putAll(tableScan.getAssignments());
        HashMap<String, Symbol> variableMappings = new HashMap<String, Symbol>();
        for (Assignment assignment : result.getAssignments()) {
            Symbol symbol = context.getSymbolAllocator().newSymbol(assignment.getVariable(), assignment.getType());
            newScanOutputs.add((Object)symbol);
            newScanAssignments.put((Object)symbol, (Object)assignment.getColumn());
            variableMappings.put(assignment.getVariable(), symbol);
        }
        List newProjections = (List)result.getProjections().stream().map(expression -> {
            Expression translated = ConnectorExpressionTranslator.translate(session, expression, plannerContext, variableMappings, literalEncoder);
            Map<NodeRef<Expression>, Type> translatedExpressionTypes = typeAnalyzer.getTypes(session, context.getSymbolAllocator().getTypes(), translated);
            translated = literalEncoder.toExpression(new ExpressionInterpreter(translated, plannerContext, session, translatedExpressionTypes).optimize(NoOpSymbolResolver.INSTANCE), translatedExpressionTypes.get(NodeRef.of((Node)translated)));
            return translated;
        }).collect(ImmutableList.toImmutableList());
        Verify.verify((aggregationOutputSymbols.size() == newProjections.size() ? 1 : 0) != 0);
        Assignments.Builder assignmentBuilder = Assignments.builder();
        IntStream.range(0, aggregationOutputSymbols.size()).forEach(index -> assignmentBuilder.put((Symbol)aggregationOutputSymbols.get(index), (Expression)newProjections.get(index)));
        ImmutableBiMap scanAssignments = newScanAssignments.build();
        ImmutableBiMap columnHandleToSymbol = scanAssignments.inverse();
        groupingKeys.forEach(groupBySymbol -> {
            ColumnHandle originalColumnHandle = (ColumnHandle)assignments.get(groupBySymbol.getName());
            ColumnHandle groupByColumnHandle = result.getGroupingColumnMapping().getOrDefault(originalColumnHandle, originalColumnHandle);
            assignmentBuilder.put((Symbol)groupBySymbol, (Expression)((Symbol)columnHandleToSymbol.get((Object)groupByColumnHandle)).toSymbolReference());
        });
        return Optional.of(new ProjectNode(context.getIdAllocator().getNextId(), new TableScanNode(context.getIdAllocator().getNextId(), (TableHandle)result.getHandle(), (List<Symbol>)newScanOutputs.build(), (Map<Symbol, ColumnHandle>)scanAssignments, (TupleDomain<ColumnHandle>)TupleDomain.all(), Rules.deriveTableStatisticsForPushdown(context.getStatsProvider(), session, result.isPrecalculateStatistics(), aggregationNode), tableScan.isUpdateTarget(), Optional.empty()), assignmentBuilder.build()));
    }

    private static AggregateFunction toAggregateFunction(Rule.Context context, AggregationNode.Aggregation aggregation) {
        BoundSignature signature = aggregation.getResolvedFunction().getSignature();
        ImmutableList.Builder arguments = ImmutableList.builder();
        for (int i = 0; i < aggregation.getArguments().size(); ++i) {
            SymbolReference argument = (SymbolReference)aggregation.getArguments().get(i);
            arguments.add((Object)new Variable(argument.getName(), (Type)signature.getArgumentTypes().get(i)));
        }
        Optional<OrderingScheme> orderingScheme = aggregation.getOrderingScheme();
        Optional<List> sortBy = orderingScheme.map(OrderingScheme::toSortItems);
        Optional<ConnectorExpression> filter = aggregation.getFilter().map(symbol -> new Variable(symbol.getName(), context.getSymbolAllocator().getTypes().get((Symbol)symbol)));
        return new AggregateFunction(signature.getName().getFunctionName(), signature.getReturnType(), (List)arguments.build(), sortBy.orElse((List)ImmutableList.of()), aggregation.isDistinct(), filter);
    }
}

