/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import io.trino.Session;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.type.DateType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.ExpressionInterpreter;
import io.trino.sql.planner.NoOpSymbolResolver;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.iterative.rule.ExpressionRewriteRuleSet;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.SymbolReference;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class RemoveRedundantDateTrunc
extends ExpressionRewriteRuleSet {
    public RemoveRedundantDateTrunc(PlannerContext plannerContext, TypeAnalyzer typeAnalyzer) {
        super((expression, context) -> RemoveRedundantDateTrunc.rewrite(expression, context.getSession(), plannerContext, typeAnalyzer, context.getSymbolAllocator().getTypes()));
    }

    private static Expression rewrite(Expression expression, Session session, PlannerContext plannerContext, TypeAnalyzer typeAnalyzer, TypeProvider types) {
        Objects.requireNonNull(plannerContext, "plannerContext is null");
        Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        if (expression instanceof SymbolReference) {
            return expression;
        }
        Map<NodeRef<Expression>, Type> expressionTypes = typeAnalyzer.getTypes(session, types, expression);
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(session, plannerContext, expressionTypes), (Expression)expression);
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final Session session;
        private final PlannerContext plannerContext;
        private final Map<NodeRef<Expression>, Type> expressionTypes;

        public Visitor(Session session, PlannerContext plannerContext, Map<NodeRef<Expression>, Type> expressionTypes) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
            this.expressionTypes = Objects.requireNonNull(expressionTypes, "expressionTypes is null");
        }

        public Expression rewriteFunctionCall(FunctionCall node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            CatalogSchemaFunctionName functionName = ResolvedFunction.extractFunctionName(node.getName());
            if (functionName.equals((Object)GlobalFunctionCatalog.builtinFunctionName("date_trunc")) && node.getArguments().size() == 2) {
                Slice unitValue;
                Expression unitExpression = (Expression)node.getArguments().get(0);
                Expression argument = (Expression)node.getArguments().get(1);
                if (this.getType(argument) == DateType.DATE && this.getType(unitExpression) instanceof VarcharType && ExpressionUtils.isEffectivelyLiteral(this.plannerContext, this.session, unitExpression) && (unitValue = (Slice)new ExpressionInterpreter(unitExpression, this.plannerContext, this.session, this.expressionTypes).optimize(NoOpSymbolResolver.INSTANCE)) != null && "day".equals(unitValue.toStringUtf8().toLowerCase(Locale.ENGLISH))) {
                    return treeRewriter.rewrite(argument, (Object)context);
                }
            }
            return treeRewriter.defaultRewrite((Expression)node, (Object)context);
        }

        private Type getType(Expression expression) {
            return (Type)Verify.verifyNotNull((Object)this.expressionTypes.get(NodeRef.of((Node)expression)), (String)"No type for expression: %s", (Object[])new Object[]{expression});
        }
    }
}

