/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.DomainTranslator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushPredicateIntoTableScan;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Expression;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class RemoveRedundantPredicateAboveTableScan
implements Rule<FilterNode> {
    private static final Capture<TableScanNode> TABLE_SCAN = Capture.newCapture();
    private static final Pattern<FilterNode> PATTERN = Patterns.filter().with(Patterns.source().matching(Patterns.tableScan().capturedAs(TABLE_SCAN).matching(node -> !node.getEnforcedConstraint().isAll())));
    private final PlannerContext plannerContext;
    private final TypeAnalyzer typeAnalyzer;

    public RemoveRedundantPredicateAboveTableScan(PlannerContext plannerContext, TypeAnalyzer typeAnalyzer) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
    }

    @Override
    public Pattern<FilterNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(FilterNode filterNode, Captures captures, Rule.Context context) {
        Session session = context.getSession();
        TableScanNode node = (TableScanNode)captures.get(TABLE_SCAN);
        Expression predicate = filterNode.getPredicate();
        Expression deterministicPredicate = ExpressionUtils.filterDeterministicConjuncts(this.plannerContext.getMetadata(), predicate);
        Expression nonDeterministicPredicate = ExpressionUtils.filterNonDeterministicConjuncts(this.plannerContext.getMetadata(), predicate);
        DomainTranslator.ExtractionResult decomposedPredicate = this.getFullyExtractedPredicates(session, deterministicPredicate, context.getSymbolAllocator().getTypes());
        if (decomposedPredicate.getTupleDomain().isAll()) {
            return Rule.Result.empty();
        }
        TupleDomain predicateDomain = decomposedPredicate.getTupleDomain().transformKeys(node.getAssignments()::get);
        if (predicateDomain.isNone()) {
            return Rule.Result.ofPlanNode(new ValuesNode(node.getId(), node.getOutputSymbols(), (List<Expression>)ImmutableList.of()));
        }
        if (node.getEnforcedConstraint().isNone()) {
            return Rule.Result.ofPlanNode(new ValuesNode(node.getId(), node.getOutputSymbols(), (List<Expression>)ImmutableList.of()));
        }
        Map enforcedColumnDomains = (Map)node.getEnforcedConstraint().getDomains().orElseThrow();
        TupleDomain unenforcedDomain = predicateDomain.transformDomains((columnHandle, predicateColumnDomain) -> {
            Type type = predicateColumnDomain.getType();
            Domain enforcedColumnDomain = Optional.ofNullable((Domain)enforcedColumnDomains.get(columnHandle)).orElseGet(() -> Domain.all((Type)type));
            if (predicateColumnDomain.contains(enforcedColumnDomain)) {
                return Domain.all((Type)type);
            }
            return predicateColumnDomain.intersect(enforcedColumnDomain);
        });
        if (unenforcedDomain.equals((Object)predicateDomain)) {
            return Rule.Result.empty();
        }
        ImmutableBiMap assignments = ImmutableBiMap.copyOf(node.getAssignments()).inverse();
        Expression resultingPredicate = PushPredicateIntoTableScan.createResultingPredicate(this.plannerContext, session, context.getSymbolAllocator(), this.typeAnalyzer, (Expression)BooleanLiteral.TRUE_LITERAL, new DomainTranslator(this.plannerContext).toPredicate((TupleDomain<Symbol>)unenforcedDomain.transformKeys(((Map)assignments)::get)), nonDeterministicPredicate, decomposedPredicate.getRemainingExpression());
        if (!BooleanLiteral.TRUE_LITERAL.equals((Object)resultingPredicate)) {
            return Rule.Result.ofPlanNode(new FilterNode(context.getIdAllocator().getNextId(), node, resultingPredicate));
        }
        return Rule.Result.ofPlanNode(node);
    }

    private DomainTranslator.ExtractionResult getFullyExtractedPredicates(Session session, Expression predicate, TypeProvider types) {
        Map extractedPredicates = ExpressionUtils.extractConjuncts(predicate).stream().map(conjunct -> DomainTranslator.getExtractionResult(this.plannerContext, session, conjunct, types)).collect(Collectors.groupingBy(result -> result.getRemainingExpression().equals((Object)BooleanLiteral.TRUE_LITERAL), Collectors.toList()));
        return new DomainTranslator.ExtractionResult((TupleDomain<Symbol>)TupleDomain.intersect((List)((List)((List)extractedPredicates.getOrDefault(Boolean.TRUE, ImmutableList.of())).stream().map(DomainTranslator.ExtractionResult::getTupleDomain).collect(ImmutableList.toImmutableList()))), ExpressionUtils.combineConjuncts(this.plannerContext.getMetadata(), (Collection)((List)extractedPredicates.getOrDefault(Boolean.FALSE, ImmutableList.of())).stream().map(DomainTranslator.ExtractionResult::getRemainingExpression).collect(ImmutableList.toImmutableList())));
    }
}

