/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.relational;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.airlift.slice.Slice;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarcharType;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.RowExpressionVisitor;
import java.util.Objects;

public final class ConstantExpression
extends RowExpression {
    private final Object value;
    private final Type type;

    @JsonCreator
    public static ConstantExpression fromJson(@JsonProperty Block value, @JsonProperty Type type) {
        return new ConstantExpression(TypeUtils.readNativeValue((Type)type, (Block)value, (int)0), type);
    }

    public ConstantExpression(Object value, Type type) {
        Objects.requireNonNull(type, "type is null");
        this.value = value;
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    public Block getBlockValue() {
        BlockBuilder blockBuilder = this.type.createBlockBuilder(null, 1);
        TypeUtils.writeNativeValue((Type)this.type, (BlockBuilder)blockBuilder, (Object)this.value);
        return blockBuilder.build();
    }

    @Override
    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @Override
    public String toString() {
        Object object = this.value;
        if (object instanceof Slice) {
            Slice slice = (Slice)object;
            if (this.type instanceof VarcharType || this.type instanceof CharType) {
                return slice.toStringUtf8();
            }
            return String.format("Slice(length=%s)", slice.length());
        }
        return String.valueOf(this.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.type);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConstantExpression other = (ConstantExpression)obj;
        return Objects.equals(this.value, other.value) && Objects.equals(this.type, other.type);
    }

    @Override
    public <R, C> R accept(RowExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitConstant(this, context);
    }
}

