/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.relational;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.OperatorNameUtil;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.RowExpressionVisitor;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class SpecialForm
extends RowExpression {
    private final Form form;
    private final Type returnType;
    private final List<RowExpression> arguments;
    private final List<ResolvedFunction> functionDependencies;

    public SpecialForm(Form form, Type returnType, RowExpression ... arguments) {
        this(form, returnType, (List<RowExpression>)ImmutableList.copyOf((Object[])arguments));
    }

    @JsonCreator
    public SpecialForm(@JsonProperty Form form, @JsonProperty Type returnType, @JsonProperty List<RowExpression> arguments) {
        this(form, returnType, arguments, (List<ResolvedFunction>)ImmutableList.of());
    }

    public SpecialForm(Form form, Type returnType, List<RowExpression> arguments, List<ResolvedFunction> functionDependencies) {
        this.form = Objects.requireNonNull(form, "form is null");
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
        this.arguments = Objects.requireNonNull(arguments, "arguments is null");
        this.functionDependencies = ImmutableList.copyOf((Collection)Objects.requireNonNull(functionDependencies, "functionDependencies is null"));
    }

    @JsonProperty
    public Form getForm() {
        return this.form;
    }

    public List<ResolvedFunction> getFunctionDependencies() {
        return this.functionDependencies;
    }

    public ResolvedFunction getOperatorDependency(OperatorType operator) {
        String mangleOperatorName = OperatorNameUtil.mangleOperatorName(operator);
        for (ResolvedFunction function : this.functionDependencies) {
            if (!function.getSignature().getName().getFunctionName().equalsIgnoreCase(mangleOperatorName)) continue;
            return function;
        }
        throw new IllegalArgumentException("Expected operator: " + operator);
    }

    public Optional<ResolvedFunction> getCastDependency(Type fromType, Type toType) {
        if (fromType.equals(toType)) {
            return Optional.empty();
        }
        BoundSignature boundSignature = new BoundSignature(GlobalFunctionCatalog.builtinFunctionName(OperatorType.CAST), toType, (List)ImmutableList.of((Object)fromType));
        for (ResolvedFunction function : this.functionDependencies) {
            if (!function.getSignature().equals((Object)boundSignature)) continue;
            return Optional.of(function);
        }
        throw new IllegalArgumentException("Expected cast: " + boundSignature);
    }

    @Override
    @JsonProperty(value="returnType")
    public Type getType() {
        return this.returnType;
    }

    @JsonProperty
    public List<RowExpression> getArguments() {
        return this.arguments;
    }

    @Override
    public String toString() {
        return this.form.name() + "(" + Joiner.on((String)", ").join(this.arguments) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpecialForm that = (SpecialForm)o;
        return this.form == that.form && Objects.equals(this.returnType, that.returnType) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.functionDependencies, that.functionDependencies);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.form, this.returnType, this.arguments, this.functionDependencies});
    }

    @Override
    public <R, C> R accept(RowExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitSpecialForm(this, context);
    }

    public static enum Form {
        IF,
        NULL_IF,
        SWITCH,
        WHEN,
        BETWEEN,
        IS_NULL,
        COALESCE,
        IN,
        AND,
        OR,
        DEREFERENCE,
        ROW_CONSTRUCTOR,
        BIND;

    }
}

