/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.eventlistener.EventListenerManager;
import io.trino.metadata.QualifiedObjectName;
import io.trino.security.AccessControlConfig;
import io.trino.security.AccessControlManager;
import io.trino.security.SecurityContext;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.Identity;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.Type;
import io.trino.transaction.TransactionManager;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class TestingAccessControlManager
extends AccessControlManager {
    private static final BiPredicate<Identity, String> IDENTITY_TABLE_TRUE = (identity, table) -> true;
    private final Set<TestingPrivilege> denyPrivileges = new HashSet<TestingPrivilege>();
    private final Map<RowFilterKey, List<ViewExpression>> rowFilters = new HashMap<RowFilterKey, List<ViewExpression>>();
    private final Map<ColumnMaskKey, ViewExpression> columnMasks = new HashMap<ColumnMaskKey, ViewExpression>();
    private Predicate<String> deniedCatalogs = s -> true;
    private Predicate<String> deniedSchemas = s -> true;
    private Predicate<SchemaTableName> deniedTables = s -> true;
    private BiPredicate<Identity, String> denyIdentityTable = IDENTITY_TABLE_TRUE;

    @Inject
    public TestingAccessControlManager(TransactionManager transactionManager, EventListenerManager eventListenerManager, AccessControlConfig accessControlConfig, OpenTelemetry openTelemetry) {
        super(transactionManager, eventListenerManager, accessControlConfig, openTelemetry, "default");
    }

    public TestingAccessControlManager(TransactionManager transactionManager, EventListenerManager eventListenerManager) {
        this(transactionManager, eventListenerManager, new AccessControlConfig(), OpenTelemetry.noop());
    }

    public static TestingPrivilege privilege(String entityName, TestingPrivilegeType type) {
        return new TestingPrivilege(Optional.empty(), entityName, type);
    }

    public static TestingPrivilege privilege(String actorName, String entityName, TestingPrivilegeType type) {
        return new TestingPrivilege(Optional.of(actorName), entityName, type);
    }

    public void deny(TestingPrivilege ... deniedPrivileges) {
        Collections.addAll(this.denyPrivileges, deniedPrivileges);
    }

    public void rowFilter(QualifiedObjectName table, String identity, ViewExpression filter) {
        this.rowFilters.computeIfAbsent(new RowFilterKey(identity, table), key -> new ArrayList()).add(filter);
    }

    public void columnMask(QualifiedObjectName table, String column, String identity, ViewExpression mask) {
        this.columnMasks.put(new ColumnMaskKey(identity, table, column), mask);
    }

    public void reset() {
        this.denyPrivileges.clear();
        this.deniedCatalogs = s -> true;
        this.deniedSchemas = s -> true;
        this.deniedTables = s -> true;
        this.denyIdentityTable = IDENTITY_TABLE_TRUE;
        this.rowFilters.clear();
        this.columnMasks.clear();
    }

    public void denyCatalogs(Predicate<String> deniedCatalogs) {
        this.deniedCatalogs = this.deniedCatalogs.and(deniedCatalogs);
    }

    public void denySchemas(Predicate<String> deniedSchemas) {
        this.deniedSchemas = this.deniedSchemas.and(deniedSchemas);
    }

    public void denyTables(Predicate<SchemaTableName> deniedTables) {
        this.deniedTables = this.deniedTables.and(deniedTables);
    }

    public void denyIdentityTable(BiPredicate<Identity, String> denyIdentityTable) {
        this.denyIdentityTable = Objects.requireNonNull(denyIdentityTable, "denyIdentityTable is null");
    }

    @Override
    public Set<String> filterCatalogs(SecurityContext securityContext, Set<String> catalogs) {
        return super.filterCatalogs(securityContext, (Set)catalogs.stream().filter(this.deniedCatalogs).collect(ImmutableSet.toImmutableSet()));
    }

    @Override
    public Set<String> filterSchemas(SecurityContext securityContext, String catalogName, Set<String> schemaNames) {
        return super.filterSchemas(securityContext, catalogName, (Set)schemaNames.stream().filter(this.deniedSchemas).collect(ImmutableSet.toImmutableSet()));
    }

    @Override
    public Set<SchemaTableName> filterTables(SecurityContext context, String catalogName, Set<SchemaTableName> tableNames) {
        return super.filterTables(context, catalogName, (Set)tableNames.stream().filter(this.deniedTables).collect(ImmutableSet.toImmutableSet()));
    }

    @Override
    public void checkCanImpersonateUser(Identity identity, String userName) {
        if (this.shouldDenyPrivilege(userName, userName, TestingPrivilegeType.IMPERSONATE_USER)) {
            AccessDeniedException.denyImpersonateUser((String)identity.getUser(), (String)userName);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanImpersonateUser(identity, userName);
        }
    }

    @Override
    @Deprecated
    public void checkCanSetUser(Optional<Principal> principal, String userName) {
        if (this.shouldDenyPrivilege(principal.map(Principal::getName), userName, TestingPrivilegeType.SET_USER)) {
            AccessDeniedException.denySetUser(principal, (String)userName);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSetUser(principal, userName);
        }
    }

    @Override
    public void checkCanExecuteQuery(Identity identity) {
        if (this.shouldDenyPrivilege(identity.getUser(), "query", TestingPrivilegeType.EXECUTE_QUERY)) {
            AccessDeniedException.denyExecuteQuery();
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanExecuteQuery(identity);
        }
    }

    @Override
    public void checkCanViewQueryOwnedBy(Identity identity, Identity queryOwner) {
        if (this.shouldDenyPrivilege(identity.getUser(), "query", TestingPrivilegeType.VIEW_QUERY)) {
            AccessDeniedException.denyViewQuery();
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanViewQueryOwnedBy(identity, queryOwner);
        }
    }

    @Override
    public Collection<Identity> filterQueriesOwnedBy(Identity identity, Collection<Identity> owners) {
        if (this.shouldDenyPrivilege(identity.getUser(), "query", TestingPrivilegeType.VIEW_QUERY)) {
            return ImmutableSet.of();
        }
        if (this.denyPrivileges.isEmpty()) {
            return super.filterQueriesOwnedBy(identity, owners);
        }
        return owners;
    }

    @Override
    public void checkCanKillQueryOwnedBy(Identity identity, Identity queryOwner) {
        if (this.shouldDenyPrivilege(identity.getUser(), "query", TestingPrivilegeType.KILL_QUERY)) {
            AccessDeniedException.denyKillQuery();
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanKillQueryOwnedBy(identity, queryOwner);
        }
    }

    @Override
    public void checkCanCreateSchema(SecurityContext context, CatalogSchemaName schemaName, Map<String, Object> properties) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), schemaName.getSchemaName(), TestingPrivilegeType.CREATE_SCHEMA)) {
            AccessDeniedException.denyCreateSchema((String)schemaName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanCreateSchema(context, schemaName, properties);
        }
    }

    @Override
    public void checkCanDropSchema(SecurityContext context, CatalogSchemaName schemaName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), schemaName.getSchemaName(), TestingPrivilegeType.DROP_SCHEMA)) {
            AccessDeniedException.denyDropSchema((String)schemaName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanDropSchema(context, schemaName);
        }
    }

    @Override
    public void checkCanRenameSchema(SecurityContext context, CatalogSchemaName schemaName, String newSchemaName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), schemaName.getSchemaName(), TestingPrivilegeType.RENAME_SCHEMA)) {
            AccessDeniedException.denyRenameSchema((String)schemaName.toString(), (String)newSchemaName);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanRenameSchema(context, schemaName, newSchemaName);
        }
    }

    @Override
    public void checkCanShowCreateTable(SecurityContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.SHOW_CREATE_TABLE)) {
            AccessDeniedException.denyShowCreateTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanShowCreateTable(context, tableName);
        }
    }

    @Override
    public void checkCanCreateTable(SecurityContext context, QualifiedObjectName tableName, Map<String, Object> properties) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.CREATE_TABLE)) {
            AccessDeniedException.denyCreateTable((String)tableName.toString());
        }
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.SET_TABLE_PROPERTIES)) {
            AccessDeniedException.denySetTableProperties((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanCreateTable(context, tableName, properties);
        }
    }

    @Override
    public void checkCanDropTable(SecurityContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.DROP_TABLE)) {
            AccessDeniedException.denyDropTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanDropTable(context, tableName);
        }
    }

    @Override
    public void checkCanRenameTable(SecurityContext context, QualifiedObjectName tableName, QualifiedObjectName newTableName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.RENAME_TABLE)) {
            AccessDeniedException.denyRenameTable((String)tableName.toString(), (String)newTableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanRenameTable(context, tableName, newTableName);
        }
    }

    @Override
    public void checkCanSetTableProperties(SecurityContext context, QualifiedObjectName tableName, Map<String, Optional<Object>> properties) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.SET_TABLE_PROPERTIES)) {
            AccessDeniedException.denySetTableProperties((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSetTableProperties(context, tableName, properties);
        }
    }

    @Override
    public void checkCanSetTableComment(SecurityContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.COMMENT_TABLE)) {
            AccessDeniedException.denyCommentTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSetTableComment(context, tableName);
        }
    }

    @Override
    public void checkCanSetViewComment(SecurityContext context, QualifiedObjectName viewName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), viewName.getObjectName(), TestingPrivilegeType.COMMENT_VIEW)) {
            AccessDeniedException.denyCommentView((String)viewName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSetViewComment(context, viewName);
        }
    }

    @Override
    public void checkCanSetColumnComment(SecurityContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.COMMENT_COLUMN)) {
            AccessDeniedException.denyCommentColumn((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSetColumnComment(context, tableName);
        }
    }

    @Override
    public void checkCanAddColumns(SecurityContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.ADD_COLUMN)) {
            AccessDeniedException.denyAddColumn((String)tableName.toString());
        }
        super.checkCanAddColumns(context, tableName);
    }

    @Override
    public void checkCanDropColumn(SecurityContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.DROP_COLUMN)) {
            AccessDeniedException.denyDropColumn((String)tableName.toString());
        }
        super.checkCanDropColumn(context, tableName);
    }

    @Override
    public void checkCanRenameColumn(SecurityContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.RENAME_COLUMN)) {
            AccessDeniedException.denyRenameColumn((String)tableName.toString());
        }
        super.checkCanRenameColumn(context, tableName);
    }

    @Override
    public void checkCanAlterColumn(SecurityContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.ALTER_COLUMN)) {
            AccessDeniedException.denyAlterColumn((String)tableName.toString());
        }
        super.checkCanAlterColumn(context, tableName);
    }

    @Override
    public void checkCanInsertIntoTable(SecurityContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.INSERT_TABLE)) {
            AccessDeniedException.denyInsertTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanInsertIntoTable(context, tableName);
        }
    }

    @Override
    public void checkCanDeleteFromTable(SecurityContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.DELETE_TABLE)) {
            AccessDeniedException.denyDeleteTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanDeleteFromTable(context, tableName);
        }
    }

    @Override
    public void checkCanTruncateTable(SecurityContext context, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.TRUNCATE_TABLE)) {
            AccessDeniedException.denyTruncateTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanTruncateTable(context, tableName);
        }
    }

    @Override
    public void checkCanUpdateTableColumns(SecurityContext context, QualifiedObjectName tableName, Set<String> updatedColumnNames) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.UPDATE_TABLE)) {
            AccessDeniedException.denyUpdateTableColumns((String)tableName.toString(), updatedColumnNames);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanUpdateTableColumns(context, tableName, updatedColumnNames);
        }
    }

    @Override
    public void checkCanCreateView(SecurityContext context, QualifiedObjectName viewName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), viewName.getObjectName(), TestingPrivilegeType.CREATE_VIEW)) {
            AccessDeniedException.denyCreateView((String)viewName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanCreateView(context, viewName);
        }
    }

    @Override
    public void checkCanRenameView(SecurityContext context, QualifiedObjectName viewName, QualifiedObjectName newViewName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), viewName.getObjectName(), TestingPrivilegeType.RENAME_VIEW)) {
            AccessDeniedException.denyRenameView((String)viewName.toString(), (String)newViewName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanRenameView(context, viewName, newViewName);
        }
    }

    @Override
    public void checkCanDropView(SecurityContext context, QualifiedObjectName viewName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), viewName.getObjectName(), TestingPrivilegeType.DROP_VIEW)) {
            AccessDeniedException.denyDropView((String)viewName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanDropView(context, viewName);
        }
    }

    @Override
    public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
        if (this.shouldDenyPrivilege(identity.getUser(), propertyName, TestingPrivilegeType.SET_SESSION)) {
            AccessDeniedException.denySetSystemSessionProperty((String)propertyName);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSetSystemSessionProperty(identity, propertyName);
        }
    }

    @Override
    public void checkCanCreateViewWithSelectFromColumns(SecurityContext context, QualifiedObjectName tableName, Set<String> columnNames) {
        if (!this.denyIdentityTable.test(context.getIdentity(), tableName.getObjectName())) {
            AccessDeniedException.denyCreateViewWithSelect((String)tableName.toString(), (Identity)context.getIdentity());
        }
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS)) {
            AccessDeniedException.denyCreateViewWithSelect((String)tableName.toString(), (Identity)context.getIdentity());
        }
        if (this.denyPrivileges.isEmpty() && this.denyIdentityTable.equals(IDENTITY_TABLE_TRUE)) {
            super.checkCanCreateViewWithSelectFromColumns(context, tableName, columnNames);
        }
    }

    @Override
    public void checkCanCreateMaterializedView(SecurityContext context, QualifiedObjectName materializedViewName, Map<String, Object> properties) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), materializedViewName.getObjectName(), TestingPrivilegeType.CREATE_MATERIALIZED_VIEW)) {
            AccessDeniedException.denyCreateMaterializedView((String)materializedViewName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanCreateMaterializedView(context, materializedViewName, properties);
        }
    }

    @Override
    public void checkCanRefreshMaterializedView(SecurityContext context, QualifiedObjectName materializedViewName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), materializedViewName.getObjectName(), TestingPrivilegeType.REFRESH_MATERIALIZED_VIEW)) {
            AccessDeniedException.denyRefreshMaterializedView((String)materializedViewName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanRefreshMaterializedView(context, materializedViewName);
        }
    }

    @Override
    public void checkCanDropMaterializedView(SecurityContext context, QualifiedObjectName materializedViewName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), materializedViewName.getObjectName(), TestingPrivilegeType.DROP_MATERIALIZED_VIEW)) {
            AccessDeniedException.denyDropMaterializedView((String)materializedViewName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanDropMaterializedView(context, materializedViewName);
        }
    }

    @Override
    public void checkCanRenameMaterializedView(SecurityContext context, QualifiedObjectName viewName, QualifiedObjectName newViewName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), viewName.getObjectName(), TestingPrivilegeType.RENAME_MATERIALIZED_VIEW)) {
            AccessDeniedException.denyRenameMaterializedView((String)viewName.toString(), (String)newViewName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanRenameMaterializedView(context, viewName, newViewName);
        }
    }

    @Override
    public void checkCanSetMaterializedViewProperties(SecurityContext context, QualifiedObjectName materializedViewName, Map<String, Optional<Object>> properties) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), materializedViewName.getObjectName(), TestingPrivilegeType.SET_MATERIALIZED_VIEW_PROPERTIES)) {
            AccessDeniedException.denySetMaterializedViewProperties((String)materializedViewName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSetMaterializedViewProperties(context, materializedViewName, properties);
        }
    }

    @Override
    public void checkCanShowColumns(SecurityContext context, CatalogSchemaTableName table) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), table.getSchemaTableName().getTableName(), TestingPrivilegeType.SHOW_COLUMNS)) {
            AccessDeniedException.denyShowColumns((String)table.getSchemaTableName().toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanShowColumns(context, table);
        }
    }

    @Override
    public Set<String> filterColumns(SecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        Set<String> visibleColumns = this.localFilterColumns(context, table.getSchemaTableName(), columns);
        return super.filterColumns(context, table, visibleColumns);
    }

    @Override
    public Map<SchemaTableName, Set<String>> filterColumns(SecurityContext context, String catalogName, Map<SchemaTableName, Set<String>> tableColumns) {
        tableColumns = (Map)tableColumns.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> this.localFilterColumns(context, (SchemaTableName)e.getKey(), (Set)e.getValue())));
        return super.filterColumns(context, catalogName, tableColumns);
    }

    private Set<String> localFilterColumns(SecurityContext context, SchemaTableName table, Set<String> columns) {
        ImmutableSet.Builder visibleColumns = ImmutableSet.builder();
        for (String column : columns) {
            if (this.shouldDenyPrivilege(context.getIdentity().getUser(), table.getTableName() + "." + column, TestingPrivilegeType.SELECT_COLUMN)) continue;
            visibleColumns.add((Object)column);
        }
        return visibleColumns.build();
    }

    @Override
    public void checkCanSetCatalogSessionProperty(SecurityContext context, String catalogName, String propertyName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), catalogName + "." + propertyName, TestingPrivilegeType.SET_SESSION)) {
            AccessDeniedException.denySetCatalogSessionProperty((String)catalogName, (String)propertyName);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSetCatalogSessionProperty(context, catalogName, propertyName);
        }
    }

    @Override
    public void checkCanSelectFromColumns(SecurityContext context, QualifiedObjectName tableName, Set<String> columns) {
        if (!this.denyIdentityTable.test(context.getIdentity(), tableName.getObjectName())) {
            AccessDeniedException.denySelectColumns((String)tableName.toString(), columns);
        }
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName(), TestingPrivilegeType.SELECT_COLUMN)) {
            AccessDeniedException.denySelectColumns((String)tableName.toString(), columns);
        }
        for (String column : columns) {
            if (!this.shouldDenyPrivilege(context.getIdentity().getUser(), tableName.getObjectName() + "." + column, TestingPrivilegeType.SELECT_COLUMN)) continue;
            AccessDeniedException.denySelectColumns((String)tableName.toString(), columns);
        }
        if (this.denyPrivileges.isEmpty() && this.denyIdentityTable.equals(IDENTITY_TABLE_TRUE)) {
            super.checkCanSelectFromColumns(context, tableName, columns);
        }
    }

    @Override
    public boolean canExecuteFunction(SecurityContext context, QualifiedObjectName functionName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), functionName.toString(), TestingPrivilegeType.EXECUTE_FUNCTION)) {
            return false;
        }
        if (this.denyPrivileges.isEmpty()) {
            return super.canExecuteFunction(context, functionName);
        }
        return true;
    }

    @Override
    public boolean canCreateViewWithExecuteFunction(SecurityContext context, QualifiedObjectName functionName) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), functionName.toString(), TestingPrivilegeType.GRANT_EXECUTE_FUNCTION)) {
            return false;
        }
        if (this.denyPrivileges.isEmpty()) {
            return super.canCreateViewWithExecuteFunction(context, functionName);
        }
        return true;
    }

    @Override
    public void checkCanExecuteTableProcedure(SecurityContext context, QualifiedObjectName table, String procedure) {
        if (this.shouldDenyPrivilege(context.getIdentity().getUser(), table + "." + procedure, TestingPrivilegeType.EXECUTE_TABLE_PROCEDURE)) {
            AccessDeniedException.denyExecuteTableProcedure((String)table.toString(), (String)procedure);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanExecuteTableProcedure(context, table, procedure);
        }
    }

    @Override
    public List<ViewExpression> getRowFilters(SecurityContext context, QualifiedObjectName tableName) {
        List<ViewExpression> viewExpressions = this.rowFilters.get(new RowFilterKey(context.getIdentity().getUser(), tableName));
        if (viewExpressions != null) {
            return viewExpressions;
        }
        return super.getRowFilters(context, tableName);
    }

    @Override
    public Optional<ViewExpression> getColumnMask(SecurityContext context, QualifiedObjectName tableName, String column, Type type) {
        ViewExpression mask = this.columnMasks.get(new ColumnMaskKey(context.getIdentity().getUser(), tableName, column));
        if (mask != null) {
            return Optional.of(mask);
        }
        return super.getColumnMask(context, tableName, column, type);
    }

    private boolean shouldDenyPrivilege(String actorName, String entityName, TestingPrivilegeType verb) {
        return this.shouldDenyPrivilege(Optional.of(actorName), entityName, verb);
    }

    private boolean shouldDenyPrivilege(Optional<String> actorName, String entityName, TestingPrivilegeType verb) {
        for (TestingPrivilege denyPrivilege : this.denyPrivileges) {
            if (!denyPrivilege.matches(actorName, entityName, verb)) continue;
            return true;
        }
        return false;
    }

    public static class TestingPrivilege {
        private final Optional<String> actorName;
        private final Predicate<String> entityPredicate;
        private final TestingPrivilegeType type;

        public TestingPrivilege(Optional<String> actorName, String entityName, TestingPrivilegeType type) {
            this(actorName, entityName::equals, type);
        }

        public TestingPrivilege(Optional<String> actorName, Predicate<String> entityPredicate, TestingPrivilegeType type) {
            this.actorName = Objects.requireNonNull(actorName, "actorName is null");
            this.entityPredicate = Objects.requireNonNull(entityPredicate, "entityPredicate is null");
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public boolean matches(Optional<String> actorName, String entityName, TestingPrivilegeType type) {
            return (this.actorName.isEmpty() || this.actorName.equals(actorName)) && this.type == type && this.entityPredicate.test(entityName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestingPrivilege that = (TestingPrivilege)o;
            return Objects.equals(this.actorName, that.actorName) && Objects.equals(this.entityPredicate, that.entityPredicate) && this.type == that.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.actorName, this.entityPredicate, this.type});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("actorName", this.actorName).add("type", (Object)this.type).toString();
        }
    }

    public static enum TestingPrivilegeType {
        SET_USER,
        IMPERSONATE_USER,
        EXECUTE_QUERY,
        VIEW_QUERY,
        KILL_QUERY,
        EXECUTE_FUNCTION,
        EXECUTE_TABLE_PROCEDURE,
        CREATE_SCHEMA,
        DROP_SCHEMA,
        RENAME_SCHEMA,
        SHOW_CREATE_TABLE,
        CREATE_TABLE,
        DROP_TABLE,
        RENAME_TABLE,
        COMMENT_TABLE,
        COMMENT_VIEW,
        COMMENT_COLUMN,
        INSERT_TABLE,
        DELETE_TABLE,
        MERGE_TABLE,
        UPDATE_TABLE,
        TRUNCATE_TABLE,
        SET_TABLE_PROPERTIES,
        SHOW_COLUMNS,
        ADD_COLUMN,
        DROP_COLUMN,
        RENAME_COLUMN,
        ALTER_COLUMN,
        SELECT_COLUMN,
        CREATE_VIEW,
        RENAME_VIEW,
        DROP_VIEW,
        CREATE_VIEW_WITH_SELECT_COLUMNS,
        CREATE_MATERIALIZED_VIEW,
        REFRESH_MATERIALIZED_VIEW,
        DROP_MATERIALIZED_VIEW,
        RENAME_MATERIALIZED_VIEW,
        SET_MATERIALIZED_VIEW_PROPERTIES,
        GRANT_EXECUTE_FUNCTION,
        SET_SESSION;

    }

    private record RowFilterKey(String identity, QualifiedObjectName table) {
        private RowFilterKey {
            Objects.requireNonNull(identity, "identity is null");
            Objects.requireNonNull(table, "table is null");
        }
    }

    private record ColumnMaskKey(String identity, QualifiedObjectName table, String column) {
        private ColumnMaskKey {
            Objects.requireNonNull(identity, "identity is null");
            Objects.requireNonNull(table, "table is null");
            Objects.requireNonNull(column, "column is null");
        }
    }
}

