/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.AbstractVariableWidthType;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;

public class JsonType
extends AbstractVariableWidthType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.builder(Slice.class).addOperators(DEFAULT_READ_OPERATORS).addOperators(DEFAULT_COMPARABLE_OPERATORS).build();
    public static final JsonType JSON = new JsonType();

    private JsonType() {
        super(new TypeSignature("json", new TypeSignatureParameter[0]), Slice.class);
    }

    public boolean isComparable() {
        return true;
    }

    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return this.getSlice(block, position).toStringUtf8();
    }

    public Slice getSlice(Block block, int position) {
        VariableWidthBlock valueBlock = (VariableWidthBlock)block.getUnderlyingValueBlock();
        int valuePosition = block.getUnderlyingValuePosition(position);
        return valueBlock.getSlice(valuePosition);
    }

    public void writeString(BlockBuilder blockBuilder, String value) {
        this.writeSlice(blockBuilder, Slices.utf8Slice((String)value));
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        ((VariableWidthBlockBuilder)blockBuilder).writeEntry(value, offset, length);
    }
}

