/*
 * Decompiled with CFR 0.152.
 */
package io.trino.index;

import com.google.inject.Inject;
import io.trino.Session;
import io.trino.connector.CatalogServiceProvider;
import io.trino.metadata.IndexHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorIndex;
import io.trino.spi.connector.ConnectorIndexProvider;
import io.trino.spi.connector.ConnectorSession;
import java.util.List;
import java.util.Objects;

public class IndexManager {
    private final CatalogServiceProvider<ConnectorIndexProvider> indexProvider;

    @Inject
    public IndexManager(CatalogServiceProvider<ConnectorIndexProvider> indexProvider) {
        this.indexProvider = Objects.requireNonNull(indexProvider, "indexProvider is null");
    }

    public ConnectorIndex getIndex(Session session, IndexHandle indexHandle, List<ColumnHandle> lookupSchema, List<ColumnHandle> outputSchema) {
        ConnectorSession connectorSession = session.toConnectorSession(indexHandle.getCatalogHandle());
        ConnectorIndexProvider provider = this.indexProvider.getService(indexHandle.getCatalogHandle());
        return provider.getIndex(indexHandle.getTransactionHandle(), connectorSession, indexHandle.getConnectorHandle(), lookupSchema, outputSchema);
    }
}

