/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.listagg;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.airlift.slice.SizeOf;
import io.airlift.slice.SliceOutput;
import io.trino.operator.aggregation.listagg.AbstractListaggAggregationState;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.GroupedAccumulatorState;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.Arrays;

public class GroupListaggAggregationState
extends AbstractListaggAggregationState
implements GroupedAccumulatorState {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final VarHandle LONG_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    private final int recordNextIndexOffset;
    private long[] groupHeadPositions = new long[0];
    private long[] groupTailPositions = new long[0];
    private int[] groupSize = new int[0];
    private int groupId = -1;

    public GroupListaggAggregationState() {
        super(8);
        this.recordNextIndexOffset = 12;
    }

    private GroupListaggAggregationState(GroupListaggAggregationState state) {
        super(state);
        this.recordNextIndexOffset = state.recordNextIndexOffset;
        this.groupHeadPositions = Arrays.copyOf(state.groupHeadPositions, state.groupHeadPositions.length);
        this.groupTailPositions = Arrays.copyOf(state.groupTailPositions, state.groupTailPositions.length);
        this.groupSize = Arrays.copyOf(state.groupSize, state.groupSize.length);
        Preconditions.checkArgument((state.groupId == -1 ? 1 : 0) != 0, (Object)"state.groupId is not -1");
        this.groupId = -1;
    }

    @Override
    public long getEstimatedSize() {
        return super.getEstimatedSize() + SizeOf.sizeOf((long[])this.groupHeadPositions) + SizeOf.sizeOf((long[])this.groupTailPositions) + SizeOf.sizeOf((int[])this.groupSize);
    }

    public void setGroupId(long groupId) {
        this.groupId = Math.toIntExact(groupId);
    }

    public void ensureCapacity(long maxGroupId) {
        Preconditions.checkArgument((maxGroupId + 1L < 0x7FFFFFF7L ? 1 : 0) != 0, (Object)"Maximum array size exceeded");
        int requiredSize = Math.toIntExact(maxGroupId + 1L);
        if (requiredSize > this.groupHeadPositions.length) {
            int newSize = Ints.constrainToRange((int)(requiredSize * 2), (int)1024, (int)0x7FFFFFF7);
            int oldSize = this.groupHeadPositions.length;
            this.groupHeadPositions = Arrays.copyOf(this.groupHeadPositions, newSize);
            Arrays.fill(this.groupHeadPositions, oldSize, newSize, -1L);
            this.groupTailPositions = Arrays.copyOf(this.groupTailPositions, newSize);
            Arrays.fill(this.groupTailPositions, oldSize, newSize, -1L);
            this.groupSize = Arrays.copyOf(this.groupSize, newSize);
        }
    }

    @Override
    public void add(ValueBlock block, int position) {
        super.add(block, position);
        long index = this.size() - 1L;
        byte[] records = this.openRecordGroup;
        int recordOffset = this.getRecordOffset(index);
        LONG_HANDLE.set(records, recordOffset + this.recordNextIndexOffset, -1L);
        if (this.groupTailPositions[this.groupId] == -1L) {
            this.groupHeadPositions[this.groupId] = index;
        } else {
            long tailIndex = this.groupTailPositions[this.groupId];
            LONG_HANDLE.set(this.getRecords(tailIndex), this.getRecordOffset(tailIndex) + this.recordNextIndexOffset, index);
        }
        this.groupTailPositions[this.groupId] = index;
        int n = this.groupId;
        this.groupSize[n] = this.groupSize[n] + 1;
    }

    @Override
    public void write(VariableWidthBlockBuilder blockBuilder) {
        if (this.groupSize[this.groupId] == 0) {
            blockBuilder.appendNull();
            return;
        }
        blockBuilder.buildEntry(this::write);
    }

    private void write(SliceOutput out) {
        long index = this.groupHeadPositions[this.groupId];
        int emittedCount = 0;
        int entryCount = this.groupSize[this.groupId];
        while (index != -1L) {
            int recordOffset;
            byte[] records = this.getRecords(index);
            if (!this.writeEntry(records, recordOffset = this.getRecordOffset(index), out, entryCount, emittedCount)) {
                return;
            }
            index = LONG_HANDLE.get(records, recordOffset + this.recordNextIndexOffset);
            ++emittedCount;
        }
    }

    public AccumulatorState copy() {
        return new GroupListaggAggregationState(this);
    }
}

