/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.trino.operator.output.PositionsAppender;
import io.trino.operator.output.PositionsAppenderUtil;
import io.trino.spi.block.Block;
import io.trino.spi.block.Fixed12Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.Optional;

public class Fixed12PositionsAppender
implements PositionsAppender {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(Fixed12PositionsAppender.class);
    private static final Block NULL_VALUE_BLOCK = new Fixed12Block(1, Optional.of(new boolean[]{true}), new int[3]);
    private boolean initialized;
    private int initialEntryCount;
    private int positionCount;
    private boolean hasNullValue;
    private boolean hasNonNullValue;
    private boolean[] valueIsNull = new boolean[0];
    private int[] values = new int[0];
    private long retainedSizeInBytes;
    private long sizeInBytes;

    public Fixed12PositionsAppender(int expectedEntries) {
        this.initialEntryCount = Math.max(expectedEntries, 1);
        this.updateRetainedSize();
    }

    @Override
    public void append(IntArrayList positions, ValueBlock block) {
        Preconditions.checkArgument((boolean)(block instanceof Fixed12Block), (String)"Block must be instance of %s", Fixed12Block.class);
        if (positions.isEmpty()) {
            return;
        }
        int[] positionArray = positions.elements();
        int positionsSize = positions.size();
        this.ensureCapacity(this.positionCount + positionsSize);
        if (block.mayHaveNull()) {
            for (int i = 0; i < positionsSize; ++i) {
                int position = positionArray[i];
                boolean isNull = block.isNull(position);
                if (isNull) {
                    this.valueIsNull[this.positionCount + i] = true;
                    this.hasNullValue = true;
                    continue;
                }
                int valuesIndex = (this.positionCount + i) * 3;
                this.values[valuesIndex] = block.getInt(position, 0);
                this.values[valuesIndex + 1] = block.getInt(position, 4);
                this.values[valuesIndex + 2] = block.getInt(position, 8);
                this.hasNonNullValue = true;
            }
            this.positionCount += positionsSize;
        } else {
            for (int i = 0; i < positionsSize; ++i) {
                int position = positionArray[i];
                int valuesIndex = (this.positionCount + i) * 3;
                this.values[valuesIndex] = block.getInt(position, 0);
                this.values[valuesIndex + 1] = block.getInt(position, 4);
                this.values[valuesIndex + 2] = block.getInt(position, 8);
            }
            this.positionCount += positionsSize;
            this.hasNonNullValue = true;
        }
        this.updateSize(positionsSize);
    }

    @Override
    public void appendRle(ValueBlock block, int rlePositionCount) {
        Preconditions.checkArgument((boolean)(block instanceof Fixed12Block), (String)"Block must be instance of %s", Fixed12Block.class);
        if (rlePositionCount == 0) {
            return;
        }
        int sourcePosition = 0;
        this.ensureCapacity(this.positionCount + rlePositionCount);
        if (block.isNull(sourcePosition)) {
            Arrays.fill(this.valueIsNull, this.positionCount, this.positionCount + rlePositionCount, true);
            this.hasNullValue = true;
        } else {
            int valueHigh = block.getInt(sourcePosition, 0);
            int valueMid = block.getInt(sourcePosition, 4);
            int valueLow = block.getInt(sourcePosition, 8);
            int positionIndex = this.positionCount * 3;
            for (int i = 0; i < rlePositionCount; ++i) {
                this.values[positionIndex] = valueHigh;
                this.values[positionIndex + 1] = valueMid;
                this.values[positionIndex + 2] = valueLow;
                positionIndex += 3;
            }
            this.hasNonNullValue = true;
        }
        this.positionCount += rlePositionCount;
        this.updateSize(rlePositionCount);
    }

    @Override
    public void append(int sourcePosition, ValueBlock source) {
        Preconditions.checkArgument((boolean)(source instanceof Fixed12Block), (String)"Block must be instance of %s", Fixed12Block.class);
        this.ensureCapacity(this.positionCount + 1);
        if (source.isNull(sourcePosition)) {
            this.valueIsNull[this.positionCount] = true;
            this.hasNullValue = true;
        } else {
            int positionIndex = this.positionCount * 3;
            this.values[positionIndex] = source.getInt(sourcePosition, 0);
            this.values[positionIndex + 1] = source.getInt(sourcePosition, 4);
            this.values[positionIndex + 2] = source.getInt(sourcePosition, 8);
            this.hasNonNullValue = true;
        }
        ++this.positionCount;
        this.updateSize(1L);
    }

    @Override
    public Block build() {
        Object result = this.hasNonNullValue ? new Fixed12Block(this.positionCount, this.hasNullValue ? Optional.of(this.valueIsNull) : Optional.empty(), this.values) : RunLengthEncodedBlock.create((Block)NULL_VALUE_BLOCK, (int)this.positionCount);
        this.reset();
        return result;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public void reset() {
        this.initialEntryCount = PositionsAppenderUtil.calculateBlockResetSize(this.positionCount);
        this.initialized = false;
        this.valueIsNull = new boolean[0];
        this.values = new int[0];
        this.positionCount = 0;
        this.sizeInBytes = 0L;
        this.hasNonNullValue = false;
        this.hasNullValue = false;
        this.updateRetainedSize();
    }

    private void ensureCapacity(int capacity) {
        int newSize;
        if (this.valueIsNull.length >= capacity) {
            return;
        }
        if (this.initialized) {
            newSize = PositionsAppenderUtil.calculateNewArraySize(this.valueIsNull.length);
        } else {
            newSize = this.initialEntryCount;
            this.initialized = true;
        }
        newSize = Math.max(newSize, capacity);
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.values = Arrays.copyOf(this.values, newSize * 3);
        this.updateRetainedSize();
    }

    private void updateSize(long positionsSize) {
        this.sizeInBytes += 13L * positionsSize;
    }

    private void updateRetainedSize() {
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.valueIsNull) + SizeOf.sizeOf((int[])this.values);
    }
}

