/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.ui;

import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.NewCookie;
import java.time.Instant;
import java.util.Date;
import java.util.Optional;
import java.util.function.Predicate;

public final class OAuthIdTokenCookie {
    public static final String ID_TOKEN_COOKIE = "__Secure-Trino-ID-Token";

    private OAuthIdTokenCookie() {
    }

    public static NewCookie create(String token, Instant tokenExpiration) {
        return new NewCookie(ID_TOKEN_COOKIE, token, "/ui/", null, 1, null, -1, Date.from(tokenExpiration), true, true);
    }

    public static Optional<String> read(Cookie cookie) {
        return Optional.ofNullable(cookie).map(Cookie::getValue).filter(Predicate.not(String::isBlank));
    }

    public static NewCookie delete() {
        return new NewCookie(ID_TOKEN_COOKIE, "delete", "/ui/", null, 1, null, 0, null, true, true);
    }
}

