/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.FunctionKind;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.DefaultExpressionTraversalVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.Node;
import java.util.Objects;

class WindowFunctionValidator
extends DefaultExpressionTraversalVisitor<Analysis> {
    private final Session session;
    private final Metadata metadata;

    public WindowFunctionValidator(Session session, Metadata metadata) {
        this.session = session;
        this.metadata = metadata;
    }

    protected Void visitFunctionCall(FunctionCall functionCall, Analysis analysis) {
        ResolvedFunction resolvedFunction;
        Objects.requireNonNull(analysis, "analysis is null");
        if (!analysis.isPatternRecognitionFunction(functionCall) && (resolvedFunction = analysis.getResolvedFunction((Expression)functionCall)) != null && functionCall.getWindow().isEmpty() && resolvedFunction.getFunctionKind() == FunctionKind.WINDOW) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_OVER, (Node)functionCall, "Window function %s requires an OVER clause", resolvedFunction.getSignature().getName());
        }
        return super.visitFunctionCall(functionCall, (Object)analysis);
    }
}

