/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.cache.CacheUtils;
import io.trino.cache.SafeCaches;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.InterpretedFunctionInvoker;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.BinaryLiteral;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.CharLiteral;
import io.trino.sql.tree.DecimalLiteral;
import io.trino.sql.tree.DoubleLiteral;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.IntervalLiteral;
import io.trino.sql.tree.Literal;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.TimeLiteral;
import io.trino.sql.tree.TimestampLiteral;
import io.trino.type.DateTimes;
import io.trino.type.JsonType;
import io.trino.util.DateTimeUtils;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class LiteralInterpreter {
    private final PlannerContext plannerContext;
    private final Session session;
    private final ConnectorSession connectorSession;
    private final InterpretedFunctionInvoker functionInvoker;
    private final Cache<Type, Function<GenericLiteral, Object>> genericLiteralEvaluatorCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L));

    public LiteralInterpreter(PlannerContext plannerContext, Session session) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.connectorSession = session.toConnectorSession();
        this.functionInvoker = new InterpretedFunctionInvoker(plannerContext.getFunctionManager());
    }

    public Object evaluate(Expression node, Type type) {
        if (!(node instanceof Literal)) {
            throw new IllegalArgumentException("node must be a Literal");
        }
        return new LiteralVisitor(type).process((Node)node, null);
    }

    private class LiteralVisitor
    extends AstVisitor<Object, Void> {
        private final Type type;

        private LiteralVisitor(Type type) {
            this.type = Objects.requireNonNull(type, "type is null");
        }

        protected Object visitLiteral(Literal node, Void context) {
            throw new UnsupportedOperationException("Unhandled literal type: " + node);
        }

        protected Object visitBooleanLiteral(BooleanLiteral node, Void context) {
            return node.getValue();
        }

        protected Long visitLongLiteral(LongLiteral node, Void context) {
            return node.getParsedValue();
        }

        protected Double visitDoubleLiteral(DoubleLiteral node, Void context) {
            return node.getValue();
        }

        protected Object visitDecimalLiteral(DecimalLiteral node, Void context) {
            return Decimals.parse((String)node.getValue()).getObject();
        }

        protected Slice visitStringLiteral(StringLiteral node, Void context) {
            return Slices.utf8Slice((String)node.getValue());
        }

        protected Object visitCharLiteral(CharLiteral node, Void context) {
            return Slices.utf8Slice((String)node.getValue());
        }

        protected Slice visitBinaryLiteral(BinaryLiteral node, Void context) {
            return Slices.wrappedBuffer((byte[])node.getValue());
        }

        protected Object visitGenericLiteral(GenericLiteral node, Void context) {
            Function evaluator = (Function)CacheUtils.uncheckedCacheGet(LiteralInterpreter.this.genericLiteralEvaluatorCache, (Object)this.type, () -> {
                boolean isJson = JsonType.JSON.equals(this.type);
                ResolvedFunction resolvedFunction = isJson ? LiteralInterpreter.this.plannerContext.getMetadata().resolveBuiltinFunction("json_parse", TypeSignatureProvider.fromTypes(new Type[]{VarcharType.VARCHAR})) : LiteralInterpreter.this.plannerContext.getMetadata().getCoercion((Type)VarcharType.VARCHAR, this.type);
                return evaluatedNode -> {
                    try {
                        return LiteralInterpreter.this.functionInvoker.invoke(resolvedFunction, LiteralInterpreter.this.connectorSession, (List<Object>)ImmutableList.of((Object)Slices.utf8Slice((String)evaluatedNode.getValue())));
                    }
                    catch (IllegalArgumentException e) {
                        if (isJson) {
                            throw e;
                        }
                        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_LITERAL, (Node)evaluatedNode, "No literal form for type %s", this.type);
                    }
                };
            });
            return evaluator.apply(node);
        }

        protected Object visitTimeLiteral(TimeLiteral node, Void session) {
            if (this.type instanceof TimeType) {
                return DateTimes.parseTime(node.getValue());
            }
            if (this.type instanceof TimeWithTimeZoneType) {
                return DateTimes.parseTimeWithTimeZone(((TimeWithTimeZoneType)this.type).getPrecision(), node.getValue());
            }
            throw new IllegalStateException("Unexpected type: " + this.type);
        }

        protected Object visitTimestampLiteral(TimestampLiteral node, Void session) {
            if (this.type instanceof TimestampType) {
                int precision = ((TimestampType)this.type).getPrecision();
                return DateTimes.parseTimestamp(precision, node.getValue());
            }
            if (this.type instanceof TimestampWithTimeZoneType) {
                int precision = ((TimestampWithTimeZoneType)this.type).getPrecision();
                return DateTimes.parseTimestampWithTimeZone(precision, node.getValue());
            }
            throw new IllegalStateException("Unexpected type: " + this.type);
        }

        protected Long visitIntervalLiteral(IntervalLiteral node, Void context) {
            if (node.isYearToMonth()) {
                return (long)node.getSign().multiplier() * DateTimeUtils.parseYearMonthInterval(node.getValue(), node.getStartField(), node.getEndField());
            }
            return (long)node.getSign().multiplier() * DateTimeUtils.parseDayTimeInterval(node.getValue(), node.getStartField(), node.getEndField());
        }

        protected Object visitNullLiteral(NullLiteral node, Void context) {
            return null;
        }
    }
}

