/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.operator.BucketPartitionFunction;
import io.trino.operator.InterpretedHashGenerator;
import io.trino.operator.PartitionFunction;
import io.trino.operator.PrecomputedHashGenerator;
import io.trino.spi.Page;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.planner.HashBucketFunction;
import io.trino.sql.planner.PartitioningHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class SystemPartitioningHandle
implements ConnectorPartitioningHandle {
    public static final PartitioningHandle SINGLE_DISTRIBUTION = SystemPartitioningHandle.createSystemPartitioning(SystemPartitioning.SINGLE, SystemPartitionFunction.SINGLE);
    public static final PartitioningHandle COORDINATOR_DISTRIBUTION = SystemPartitioningHandle.createSystemPartitioning(SystemPartitioning.COORDINATOR_ONLY, SystemPartitionFunction.SINGLE);
    public static final PartitioningHandle FIXED_HASH_DISTRIBUTION = SystemPartitioningHandle.createSystemPartitioning(SystemPartitioning.FIXED, SystemPartitionFunction.HASH);
    public static final PartitioningHandle FIXED_ARBITRARY_DISTRIBUTION = SystemPartitioningHandle.createSystemPartitioning(SystemPartitioning.FIXED, SystemPartitionFunction.ROUND_ROBIN);
    public static final PartitioningHandle FIXED_BROADCAST_DISTRIBUTION = SystemPartitioningHandle.createSystemPartitioning(SystemPartitioning.FIXED, SystemPartitionFunction.BROADCAST);
    public static final PartitioningHandle SCALED_WRITER_ROUND_ROBIN_DISTRIBUTION = SystemPartitioningHandle.createScaledWriterSystemPartitioning(SystemPartitionFunction.ROUND_ROBIN);
    public static final PartitioningHandle SCALED_WRITER_HASH_DISTRIBUTION = SystemPartitioningHandle.createScaledWriterSystemPartitioning(SystemPartitionFunction.HASH);
    public static final PartitioningHandle SOURCE_DISTRIBUTION = SystemPartitioningHandle.createSystemPartitioning(SystemPartitioning.SOURCE, SystemPartitionFunction.UNKNOWN);
    public static final PartitioningHandle ARBITRARY_DISTRIBUTION = SystemPartitioningHandle.createSystemPartitioning(SystemPartitioning.ARBITRARY, SystemPartitionFunction.UNKNOWN);
    public static final PartitioningHandle FIXED_PASSTHROUGH_DISTRIBUTION = SystemPartitioningHandle.createSystemPartitioning(SystemPartitioning.FIXED, SystemPartitionFunction.UNKNOWN);
    private final SystemPartitioning partitioning;
    private final SystemPartitionFunction function;

    private static PartitioningHandle createSystemPartitioning(SystemPartitioning partitioning, SystemPartitionFunction function) {
        return new PartitioningHandle(Optional.empty(), Optional.empty(), new SystemPartitioningHandle(partitioning, function));
    }

    private static PartitioningHandle createScaledWriterSystemPartitioning(SystemPartitionFunction function) {
        return new PartitioningHandle(Optional.empty(), Optional.empty(), new SystemPartitioningHandle(SystemPartitioning.ARBITRARY, function), true);
    }

    @JsonCreator
    public SystemPartitioningHandle(@JsonProperty(value="partitioning") SystemPartitioning partitioning, @JsonProperty(value="function") SystemPartitionFunction function) {
        this.partitioning = Objects.requireNonNull(partitioning, "partitioning is null");
        this.function = Objects.requireNonNull(function, "function is null");
    }

    @JsonProperty
    public SystemPartitioning getPartitioning() {
        return this.partitioning;
    }

    @JsonProperty
    public SystemPartitionFunction getFunction() {
        return this.function;
    }

    public String getPartitioningName() {
        return this.partitioning.name();
    }

    public boolean isSingleNode() {
        return this.partitioning == SystemPartitioning.COORDINATOR_ONLY || this.partitioning == SystemPartitioning.SINGLE;
    }

    public boolean isCoordinatorOnly() {
        return this.partitioning == SystemPartitioning.COORDINATOR_ONLY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemPartitioningHandle that = (SystemPartitioningHandle)o;
        return this.partitioning == that.partitioning && this.function == that.function;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.partitioning, this.function});
    }

    public String toString() {
        if (this.partitioning == SystemPartitioning.FIXED || this.partitioning == SystemPartitioning.ARBITRARY) {
            return this.function.toString();
        }
        return this.partitioning.toString();
    }

    public PartitionFunction getPartitionFunction(List<Type> partitionChannelTypes, boolean isHashPrecomputed, int[] bucketToPartition, TypeOperators typeOperators) {
        Objects.requireNonNull(partitionChannelTypes, "partitionChannelTypes is null");
        Objects.requireNonNull(bucketToPartition, "bucketToPartition is null");
        BucketFunction bucketFunction = this.function.createBucketFunction(partitionChannelTypes, isHashPrecomputed, bucketToPartition.length, typeOperators);
        return new BucketPartitionFunction(bucketFunction, bucketToPartition);
    }

    static enum SystemPartitioning {
        SINGLE,
        FIXED,
        SOURCE,
        COORDINATOR_ONLY,
        ARBITRARY;

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum SystemPartitionFunction {
        SINGLE{

            @Override
            public BucketFunction createBucketFunction(List<Type> partitionChannelTypes, boolean isHashPrecomputed, int bucketCount, TypeOperators typeOperators) {
                Preconditions.checkArgument((bucketCount == 1 ? 1 : 0) != 0, (Object)"Single partition can only have one bucket");
                return new SingleBucketFunction();
            }
        }
        ,
        HASH{

            @Override
            public BucketFunction createBucketFunction(List<Type> partitionChannelTypes, boolean isHashPrecomputed, int bucketCount, TypeOperators typeOperators) {
                if (isHashPrecomputed) {
                    return new HashBucketFunction(new PrecomputedHashGenerator(0), bucketCount);
                }
                return new HashBucketFunction(InterpretedHashGenerator.createPagePrefixHashGenerator(partitionChannelTypes, typeOperators), bucketCount);
            }
        }
        ,
        ROUND_ROBIN{

            @Override
            public BucketFunction createBucketFunction(List<Type> partitionChannelTypes, boolean isHashPrecomputed, int bucketCount, TypeOperators typeOperators) {
                return new RoundRobinBucketFunction(bucketCount);
            }
        }
        ,
        BROADCAST{

            @Override
            public BucketFunction createBucketFunction(List<Type> partitionChannelTypes, boolean isHashPrecomputed, int bucketCount, TypeOperators typeOperators) {
                throw new UnsupportedOperationException();
            }
        }
        ,
        UNKNOWN{

            @Override
            public BucketFunction createBucketFunction(List<Type> partitionChannelTypes, boolean isHashPrecomputed, int bucketCount, TypeOperators typeOperators) {
                throw new UnsupportedOperationException();
            }
        };


        public abstract BucketFunction createBucketFunction(List<Type> var1, boolean var2, int var3, TypeOperators var4);

        public static class RoundRobinBucketFunction
        implements BucketFunction {
            private final int bucketCount;
            private int counter;

            public RoundRobinBucketFunction(int bucketCount) {
                Preconditions.checkArgument((bucketCount > 0 ? 1 : 0) != 0, (Object)"bucketCount must be at least 1");
                this.bucketCount = bucketCount;
            }

            public int getBucket(Page page, int position) {
                int bucket = this.counter % this.bucketCount;
                this.counter = this.counter + 1 & Integer.MAX_VALUE;
                return bucket;
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("bucketCount", this.bucketCount).toString();
            }
        }

        private static class SingleBucketFunction
        implements BucketFunction {
            private SingleBucketFunction() {
            }

            public int getBucket(Page page, int position) {
                return 0;
            }
        }
    }
}

