/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import io.airlift.slice.SizeOf;
import io.trino.array.LongBigArray;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.longs.LongPriorityQueue;
import java.util.NoSuchElementException;

public class LongBigArrayFIFOQueue
implements LongPriorityQueue {
    private static final long INSTANCE_SIZE = SizeOf.instanceSize(LongBigArrayFIFOQueue.class);
    public static final long INITIAL_CAPACITY = 1024L;
    protected LongBigArray array;
    protected long length;
    protected long start;
    protected long end;

    public LongBigArrayFIFOQueue(long capacity) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.array = new LongBigArray();
        this.length = Math.max(1024L, capacity);
        this.array.ensureCapacity(this.length);
    }

    public LongBigArrayFIFOQueue() {
        this(1024L);
    }

    public long sizeOf() {
        return INSTANCE_SIZE + this.array.sizeOf();
    }

    public LongComparator comparator() {
        return null;
    }

    public long dequeueLong() {
        if (this.start == this.end) {
            throw new NoSuchElementException();
        }
        long t = this.array.get(this.start);
        if (++this.start == this.length) {
            this.start = 0L;
        }
        this.reduce();
        return t;
    }

    public long dequeueLastLong() {
        if (this.start == this.end) {
            throw new NoSuchElementException();
        }
        if (this.end == 0L) {
            this.end = this.length;
        }
        long t = this.array.get(--this.end);
        this.reduce();
        return t;
    }

    private void resize(long size, long newLength) {
        LongBigArray newArray = new LongBigArray();
        newArray.ensureCapacity(newLength);
        if (this.start >= this.end) {
            if (size != 0L) {
                this.array.copyTo(this.start, newArray, 0L, this.length - this.start);
                this.array.copyTo(0L, newArray, this.length - this.start, this.end);
            }
        } else {
            this.array.copyTo(this.start, newArray, 0L, this.end - this.start);
        }
        this.start = 0L;
        this.end = size;
        this.array = newArray;
        this.length = newLength;
    }

    private void expand() {
        this.resize(this.length, 2L * this.length);
    }

    private void reduce() {
        long size = this.longSize();
        if (this.length > 1024L && size <= this.length / 4L) {
            this.resize(size, this.length / 2L);
        }
    }

    public void enqueue(long x) {
        this.array.set(this.end++, x);
        if (this.end == this.length) {
            this.end = 0L;
        }
        if (this.end == this.start) {
            this.expand();
        }
    }

    public void enqueueFirst(long x) {
        if (this.start == 0L) {
            this.start = this.length;
        }
        this.array.set(--this.start, x);
        if (this.end == this.start) {
            this.expand();
        }
    }

    public long firstLong() {
        if (this.start == this.end) {
            throw new NoSuchElementException();
        }
        return this.array.get(this.start);
    }

    public long lastLong() {
        if (this.start == this.end) {
            throw new NoSuchElementException();
        }
        return this.array.get((this.end == 0L ? this.length : this.end) - 1L);
    }

    public void clear() {
        this.end = 0L;
        this.start = 0L;
    }

    public void trim() {
        long size = this.longSize();
        LongBigArray newArray = new LongBigArray();
        newArray.ensureCapacity(size + 1L);
        if (this.start <= this.end) {
            this.array.copyTo(this.start, newArray, 0L, this.end - this.start);
        } else {
            this.array.copyTo(this.start, newArray, 0L, this.length - this.start);
            this.array.copyTo(0L, newArray, this.length - this.start, this.end);
        }
        this.start = 0L;
        this.end = size;
        this.length = size + 1L;
        this.array = newArray;
    }

    public int size() {
        return Math.toIntExact(this.longSize());
    }

    public long longSize() {
        long apparentLength = this.end - this.start;
        return apparentLength >= 0L ? apparentLength : this.length + apparentLength;
    }

    public boolean isEmpty() {
        return this.end == this.start;
    }
}

