/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.DictionaryId;
import io.trino.spi.block.MapHashTables;
import io.trino.spi.block.TestingBlockEncodingSerde;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.type.InternalTypeManager;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;

public abstract class AbstractTestBlock {
    private static final BlockEncodingSerde BLOCK_ENCODING_SERDE = new TestingBlockEncodingSerde(arg_0 -> ((TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER).getType(arg_0));

    protected <T> void assertBlock(Block block, T[] expectedValues) {
        this.assertBlockSize(block);
        this.assertRetainedSize(block);
        this.assertBlockPositions(block, expectedValues);
        this.assertBlockPositions(AbstractTestBlock.copyBlockViaBlockSerde(block), expectedValues);
        Block blockWithNull = AbstractTestBlock.copyBlockViaBlockSerde(block).copyWithAppendedNull();
        T[] expectedValuesWithNull = Arrays.copyOf(expectedValues, expectedValues.length + 1);
        this.assertBlockPositions(blockWithNull, expectedValuesWithNull);
        this.assertBlockSize(block);
        this.assertRetainedSize(block);
        if (block.mayHaveNull()) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> block.isNull(-1)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid position -1 in block with %d positions", new Object[]{block.getPositionCount()});
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> block.isNull(block.getPositionCount())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid position %d in block with %d positions", new Object[]{block.getPositionCount(), block.getPositionCount()});
        }
        if (block instanceof ValueBlock) {
            ValueBlock valueBlock = (ValueBlock)block;
            this.assertBlockClassImplementation(valueBlock.getClass());
        }
    }

    private void assertRetainedSize(Block block) {
        long retainedSize = SizeOf.instanceSize(block.getClass());
        Field[] fields = block.getClass().getDeclaredFields();
        try {
            for (Field field : fields) {
                Class<?> type;
                if (Modifier.isStatic(field.getModifiers()) || (type = field.getType()).isPrimitive() || Type.class.isAssignableFrom(type)) continue;
                field.setAccessible(true);
                if (type == Slice.class) {
                    Slice slice = (Slice)field.get(block);
                    if (slice == null) continue;
                    retainedSize += slice.getRetainedSize();
                    continue;
                }
                if (type == BlockBuilderStatus.class) {
                    if (field.get(block) == null) continue;
                    retainedSize += (long)BlockBuilderStatus.INSTANCE_SIZE;
                    continue;
                }
                if (Block.class.isAssignableFrom(type)) {
                    retainedSize += ((Block)field.get(block)).getRetainedSizeInBytes();
                    continue;
                }
                if (type == Block[].class) {
                    Block[] blocks;
                    for (Block innerBlock : blocks = (Block[])field.get(block)) {
                        this.assertRetainedSize(innerBlock);
                        retainedSize += innerBlock.getRetainedSizeInBytes();
                    }
                    continue;
                }
                if (type == SliceOutput.class) {
                    retainedSize += ((SliceOutput)field.get(block)).getRetainedSize();
                    continue;
                }
                if (type == int[].class) {
                    retainedSize += SizeOf.sizeOf((int[])((int[])field.get(block)));
                    continue;
                }
                if (type == boolean[].class) {
                    retainedSize += SizeOf.sizeOf((boolean[])((boolean[])field.get(block)));
                    continue;
                }
                if (type == byte[].class) {
                    retainedSize += SizeOf.sizeOf((byte[])((byte[])field.get(block)));
                    continue;
                }
                if (type == long[].class) {
                    retainedSize += SizeOf.sizeOf((long[])((long[])field.get(block)));
                    continue;
                }
                if (type == short[].class) {
                    retainedSize += SizeOf.sizeOf((short[])((short[])field.get(block)));
                    continue;
                }
                if (type == DictionaryId.class) {
                    retainedSize += (long)SizeOf.instanceSize(DictionaryId.class);
                    continue;
                }
                if (type == MapHashTables.class) {
                    retainedSize += ((MapHashTables)field.get(block)).getRetainedSizeInBytes();
                    continue;
                }
                if (type == MethodHandle.class || field.getName().equals("fieldBlocksList")) continue;
                throw new IllegalArgumentException(String.format("Unknown type encountered: %s", type));
            }
        }
        catch (IllegalAccessException t) {
            throw new RuntimeException(t);
        }
        Assertions.assertThat((long)block.getRetainedSizeInBytes()).isEqualTo(retainedSize);
    }

    protected <T> void assertBlockFilteredPositions(T[] expectedValues, Block block, int ... positions) {
        Block filteredBlock = block.copyPositions(positions, 0, positions.length);
        T[] filteredExpectedValues = AbstractTestBlock.filter(expectedValues, positions);
        Assertions.assertThat((int)filteredBlock.getPositionCount()).isEqualTo(positions.length);
        this.assertBlock(filteredBlock, filteredExpectedValues);
    }

    private static <T> T[] filter(T[] expectedValues, int[] positions) {
        Object[] prunedExpectedValues = (Object[])Array.newInstance(expectedValues.getClass().getComponentType(), positions.length);
        for (int i = 0; i < prunedExpectedValues.length; ++i) {
            prunedExpectedValues[i] = expectedValues[positions[i]];
        }
        return prunedExpectedValues;
    }

    private <T> void assertBlockPositions(Block block, T[] expectedValues) {
        Assertions.assertThat((int)block.getPositionCount()).isEqualTo(expectedValues.length);
        for (int position = 0; position < block.getPositionCount(); ++position) {
            this.assertBlockPosition(block, position, expectedValues[position]);
        }
    }

    protected List<Block> splitBlock(Block block, int count) {
        double sizePerSplit = (double)block.getPositionCount() * 1.0 / (double)count;
        ImmutableList.Builder result = ImmutableList.builderWithExpectedSize((int)count);
        for (int i = 0; i < count; ++i) {
            int startPosition = Math.toIntExact(Math.round(sizePerSplit * (double)i));
            int endPosition = Math.toIntExact(Math.round(sizePerSplit * (double)(i + 1)));
            result.add((Object)block.getRegion(startPosition, endPosition - startPosition));
        }
        return result.build();
    }

    private void assertBlockSize(Block block) {
        long expectedBlockSize = AbstractTestBlock.getCompactedBlockSizeInBytes(block);
        Assertions.assertThat((long)block.getSizeInBytes()).isEqualTo(expectedBlockSize);
        Assertions.assertThat((long)block.getRegionSizeInBytes(0, block.getPositionCount())).isEqualTo(expectedBlockSize);
        List<Block> splitBlock = this.splitBlock(block, 2);
        Block firstHalf = splitBlock.get(0);
        long expectedFirstHalfSize = AbstractTestBlock.getCompactedBlockSizeInBytes(firstHalf);
        Assertions.assertThat((long)firstHalf.getSizeInBytes()).isEqualTo(expectedFirstHalfSize);
        Assertions.assertThat((long)block.getRegionSizeInBytes(0, firstHalf.getPositionCount())).isEqualTo(expectedFirstHalfSize);
        Block secondHalf = splitBlock.get(1);
        long expectedSecondHalfSize = AbstractTestBlock.getCompactedBlockSizeInBytes(secondHalf);
        Assertions.assertThat((long)secondHalf.getSizeInBytes()).isEqualTo(expectedSecondHalfSize);
        Assertions.assertThat((long)block.getRegionSizeInBytes(firstHalf.getPositionCount(), secondHalf.getPositionCount())).isEqualTo(expectedSecondHalfSize);
        boolean[] positions = new boolean[block.getPositionCount()];
        Arrays.fill(positions, 0, firstHalf.getPositionCount(), true);
        Assertions.assertThat((long)block.getPositionsSizeInBytes(positions, firstHalf.getPositionCount())).isEqualTo(expectedFirstHalfSize);
        Arrays.fill(positions, true);
        Assertions.assertThat((long)block.getPositionsSizeInBytes(positions, positions.length)).isEqualTo(expectedBlockSize);
        Arrays.fill(positions, 0, firstHalf.getPositionCount(), false);
        Assertions.assertThat((long)block.getPositionsSizeInBytes(positions, positions.length - firstHalf.getPositionCount())).isEqualTo(expectedSecondHalfSize);
    }

    protected <T> void assertBlockPosition(Block block, int position, T expectedValue) {
        this.assertPositionValue(block, position, expectedValue);
        this.assertPositionValue((Block)block.getSingleValueBlock(position), 0, expectedValue);
        this.assertPositionValue(block.getRegion(position, 1), 0, expectedValue);
        this.assertPositionValue(block.getRegion(0, position + 1), position, expectedValue);
        this.assertPositionValue(block.getRegion(position, block.getPositionCount() - position), 0, expectedValue);
        this.assertPositionValue(AbstractTestBlock.copyBlockViaBlockSerde(block.getRegion(position, 1)), 0, expectedValue);
        this.assertPositionValue(AbstractTestBlock.copyBlockViaBlockSerde(block.getRegion(0, position + 1)), position, expectedValue);
        this.assertPositionValue(AbstractTestBlock.copyBlockViaBlockSerde(block.getRegion(position, block.getPositionCount() - position)), 0, expectedValue);
        this.assertPositionValue(block.copyRegion(position, 1), 0, expectedValue);
        this.assertPositionValue(block.copyRegion(0, position + 1), position, expectedValue);
        this.assertPositionValue(block.copyRegion(position, block.getPositionCount() - position), 0, expectedValue);
        this.assertPositionValue(block.copyPositions(new int[]{position}, 0, 1), 0, expectedValue);
    }

    protected <T> void assertPositionValue(Block block, int position, T expectedValue) {
        if (expectedValue == null) {
            Assertions.assertThat((boolean)block.isNull(position)).isTrue();
            return;
        }
        Assertions.assertThat((boolean)block.isNull(position)).isFalse();
        if (expectedValue instanceof Slice) {
            int offset;
            Slice expectedSliceValue = (Slice)expectedValue;
            if (this.isByteAccessSupported()) {
                for (offset = 0; offset <= expectedSliceValue.length() - 1; ++offset) {
                    Assertions.assertThat((byte)block.getByte(position, offset)).isEqualTo(expectedSliceValue.getByte(offset));
                }
            }
            if (this.isShortAccessSupported()) {
                for (offset = 0; offset <= expectedSliceValue.length() - 2; ++offset) {
                    Assertions.assertThat((short)block.getShort(position, offset)).isEqualTo(expectedSliceValue.getShort(offset));
                }
            }
            if (this.isIntAccessSupported()) {
                for (offset = 0; offset <= expectedSliceValue.length() - 4; ++offset) {
                    Assertions.assertThat((int)block.getInt(position, offset)).isEqualTo(expectedSliceValue.getInt(offset));
                }
            }
            if (this.isLongAccessSupported()) {
                for (offset = 0; offset <= expectedSliceValue.length() - 8; ++offset) {
                    Assertions.assertThat((long)block.getLong(position, offset)).isEqualTo(expectedSliceValue.getLong(offset));
                }
            }
            if (this.isAlignedLongAccessSupported()) {
                for (offset = 0; offset <= expectedSliceValue.length() - 8; offset += 8) {
                    Assertions.assertThat((long)block.getLong(position, offset)).isEqualTo(expectedSliceValue.getLong(offset));
                }
            }
            if (this.isSliceAccessSupported()) {
                Assertions.assertThat((int)block.getSliceLength(position)).isEqualTo(expectedSliceValue.length());
                int length = block.getSliceLength(position);
                Assertions.assertThat((int)length).isEqualTo(expectedSliceValue.length());
                for (int offset2 = 0; offset2 < length - 3; ++offset2) {
                    Assertions.assertThat((Comparable)block.getSlice(position, offset2, 3)).isEqualTo((Object)expectedSliceValue.slice(offset2, 3));
                }
            }
            this.assertPositionEquals(block, position, expectedSliceValue);
        } else if (expectedValue instanceof long[]) {
            long[] expected = (long[])expectedValue;
            Block actual = (Block)block.getObject(position, Block.class);
            Assertions.assertThat((int)actual.getPositionCount()).isEqualTo(expected.length);
            for (int i = 0; i < expected.length; ++i) {
                Assertions.assertThat((long)BigintType.BIGINT.getLong(actual, i)).isEqualTo(expected[i]);
            }
        } else if (expectedValue instanceof Slice[]) {
            Slice[] expected = (Slice[])expectedValue;
            Block actual = (Block)block.getObject(position, Block.class);
            Assertions.assertThat((int)actual.getPositionCount()).isEqualTo(expected.length);
            for (int i = 0; i < expected.length; ++i) {
                Assertions.assertThat((Comparable)VarcharType.VARCHAR.getSlice(actual, i)).isEqualTo((Object)expected[i]);
            }
        } else if (expectedValue instanceof long[][]) {
            long[][] expected = (long[][])expectedValue;
            Block actual = (Block)block.getObject(position, Block.class);
            Assertions.assertThat((int)actual.getPositionCount()).isEqualTo(expected.length);
            for (int i = 0; i < expected.length; ++i) {
                this.assertPositionValue(actual, i, expected[i]);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected boolean isByteAccessSupported() {
        return true;
    }

    protected boolean isShortAccessSupported() {
        return true;
    }

    protected boolean isIntAccessSupported() {
        return true;
    }

    protected boolean isLongAccessSupported() {
        return true;
    }

    protected boolean isAlignedLongAccessSupported() {
        return false;
    }

    protected boolean isSliceAccessSupported() {
        return true;
    }

    protected void assertPositionEquals(Block block, int position, Slice expectedBytes) {
    }

    private static long getCompactedBlockSizeInBytes(Block block) {
        if (block instanceof DictionaryBlock) {
            return ((DictionaryBlock)block).compact().getSizeInBytes();
        }
        return AbstractTestBlock.copyBlockViaCopyRegion(block).getSizeInBytes();
    }

    private static Block copyBlockViaCopyRegion(Block block) {
        return block.copyRegion(0, block.getPositionCount());
    }

    private static Block copyBlockViaBlockSerde(Block block) {
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1024);
        BLOCK_ENCODING_SERDE.writeBlock((SliceOutput)sliceOutput, block);
        return BLOCK_ENCODING_SERDE.readBlock((SliceInput)sliceOutput.slice().getInput());
    }

    private static Block toSingeValuedBlock(Slice expectedValue) {
        VariableWidthBlockBuilder blockBuilder = VarbinaryType.VARBINARY.createBlockBuilder(null, 1, expectedValue.length());
        VarbinaryType.VARBINARY.writeSlice((BlockBuilder)blockBuilder, expectedValue);
        return blockBuilder.build();
    }

    private static Slice createGreaterValue(Slice expectedValue, int offset, int length) {
        DynamicSliceOutput greaterOutput = new DynamicSliceOutput(length + 1);
        greaterOutput.writeBytes(expectedValue, offset, length);
        greaterOutput.writeByte(95);
        return greaterOutput.slice();
    }

    protected static Slice[] createExpectedValues(int positionCount) {
        Slice[] expectedValues = new Slice[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = AbstractTestBlock.createExpectedValue(position);
        }
        return expectedValues;
    }

    protected static Slice createExpectedValue(int length) {
        DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(16);
        for (int index = 0; index < length; ++index) {
            dynamicSliceOutput.writeByte(length * (index + 1));
        }
        return dynamicSliceOutput.slice();
    }

    protected static <T> T[] alternatingNullValues(T[] objects) {
        T[] objectsWithNulls = Arrays.copyOf(objects, objects.length * 2 + 1);
        for (int i = 0; i < objects.length; ++i) {
            objectsWithNulls[i * 2] = null;
            objectsWithNulls[i * 2 + 1] = objects[i];
        }
        objectsWithNulls[objectsWithNulls.length - 1] = null;
        return objectsWithNulls;
    }

    protected static void assertEstimatedDataSizeForStats(BlockBuilder blockBuilder, Slice[] expectedSliceValues) {
        Block block = blockBuilder.build();
        Assertions.assertThat((int)block.getPositionCount()).isEqualTo(expectedSliceValues.length);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            int expectedSize = expectedSliceValues[i] == null ? 0 : expectedSliceValues[i].length();
            Assertions.assertThat((long)block.getEstimatedDataSizeForStats(i)).isEqualTo((long)expectedSize);
        }
        Block nullValueBlock = blockBuilder.newBlockBuilderLike(null).appendNull().build();
        Assertions.assertThat((long)nullValueBlock.getEstimatedDataSizeForStats(0)).isEqualTo(0L);
    }

    protected static void testCopyRegionCompactness(Block block) {
        AbstractTestBlock.assertCompact(block.copyRegion(0, block.getPositionCount()));
        if (block.getPositionCount() > 0) {
            AbstractTestBlock.assertCompact(block.copyRegion(0, block.getPositionCount() - 1));
            AbstractTestBlock.assertCompact(block.copyRegion(1, block.getPositionCount() - 1));
        }
    }

    protected static void assertCompact(Block block) {
        Assertions.assertThat((Object)block.copyRegion(0, block.getPositionCount())).isSameAs((Object)block);
    }

    protected static void assertNotCompact(Block block) {
        Assertions.assertThat((Object)block.copyRegion(0, block.getPositionCount())).isNotSameAs((Object)block);
    }

    protected static void testCompactBlock(Block block) {
        AbstractTestBlock.assertCompact(block);
        AbstractTestBlock.testCopyRegionCompactness(block);
    }

    protected static void testIncompactBlock(Block block) {
        AbstractTestBlock.assertNotCompact(block);
        AbstractTestBlock.testCopyRegionCompactness(block);
    }

    private void assertBlockClassImplementation(Class<? extends ValueBlock> clazz) {
        for (Method method : clazz.getMethods()) {
            if (method.getReturnType() == ValueBlock.class && !method.isBridge()) {
                throw new AssertionError((Object)String.format("ValueBlock method %s should override return type to be %s", method, clazz.getSimpleName()));
            }
        }
    }
}

