/*
 * Decompiled with CFR 0.152.
 */
package io.trino.dispatcher;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.Threads;
import io.airlift.json.JsonCodec;
import io.airlift.node.NodeInfo;
import io.airlift.units.Duration;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.client.NodeVersion;
import io.trino.connector.CatalogProperties;
import io.trino.connector.CatalogServiceProvider;
import io.trino.connector.ConnectorCatalogServiceProvider;
import io.trino.connector.ConnectorServices;
import io.trino.connector.ConnectorServicesProvider;
import io.trino.cost.StatsAndCosts;
import io.trino.dispatcher.LocalDispatchQuery;
import io.trino.event.QueryMonitor;
import io.trino.event.QueryMonitorConfig;
import io.trino.eventlistener.EventListenerConfig;
import io.trino.eventlistener.EventListenerManager;
import io.trino.execution.ClusterSizeMonitor;
import io.trino.execution.DataDefinitionExecution;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.ExecutionFailureInfo;
import io.trino.execution.QueryPreparer;
import io.trino.execution.QueryState;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.StageInfo;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.InMemoryNodeManager;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.LanguageFunctionProvider;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.SessionPropertyManager;
import io.trino.operator.OperatorStats;
import io.trino.plugin.base.security.AllowAllSystemAccessControl;
import io.trino.security.AccessControl;
import io.trino.security.AccessControlConfig;
import io.trino.security.AccessControlManager;
import io.trino.server.protocol.Slug;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.resourcegroups.QueryType;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.sql.tree.CreateTable;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SaveMode;
import io.trino.sql.tree.Statement;
import io.trino.testing.TestingEventListenerManager;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionManager;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLocalDispatchQuery {
    private CountDownLatch countDownLatch;

    @Test
    public void testSubmittedForDispatchedQuery() throws InterruptedException {
        this.countDownLatch = new CountDownLatch(1);
        ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControl = new AccessControlManager(NodeVersion.UNKNOWN, transactionManager, (EventListenerManager)TestingEventListenerManager.emptyEventListenerManager(), new AccessControlConfig(), OpenTelemetry.noop(), "default");
        accessControl.setSystemAccessControls(List.of(AllowAllSystemAccessControl.INSTANCE));
        QueryStateMachine queryStateMachine = QueryStateMachine.begin(Optional.empty(), (String)"sql", Optional.empty(), (Session)SessionTestUtils.TEST_SESSION, (URI)URI.create("fake://fake-query"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)transactionManager, (AccessControl)accessControl, (Executor)executor, (Metadata)metadata, (WarningCollector)WarningCollector.NOOP, (PlanOptimizersStatsCollector)PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector(), Optional.of(QueryType.DATA_DEFINITION), (boolean)true, (NodeVersion)new NodeVersion("test"));
        QueryMonitor queryMonitor = new QueryMonitor(JsonCodec.jsonCodec(StageInfo.class), JsonCodec.jsonCodec(OperatorStats.class), JsonCodec.jsonCodec(ExecutionFailureInfo.class), JsonCodec.jsonCodec(StatsAndCosts.class), new EventListenerManager(new EventListenerConfig()), new NodeInfo("node"), new NodeVersion("version"), new SessionPropertyManager(), (Metadata)metadata, new FunctionManager((CatalogServiceProvider)new ConnectorCatalogServiceProvider("function provider", (ConnectorServicesProvider)new NoConnectorServicesProvider(), ConnectorServices::getFunctionProvider), new GlobalFunctionCatalog(), LanguageFunctionProvider.DISABLED), new QueryMonitorConfig());
        CreateTable createTable = new CreateTable(QualifiedName.of((String)"table"), (List)ImmutableList.of(), SaveMode.FAIL, (List)ImmutableList.of(), Optional.empty());
        QueryPreparer.PreparedQuery preparedQuery = new QueryPreparer.PreparedQuery((Statement)createTable, (List)ImmutableList.of(), Optional.empty());
        DataDefinitionExecution.DataDefinitionExecutionFactory dataDefinitionExecutionFactory = new DataDefinitionExecution.DataDefinitionExecutionFactory((Map)ImmutableMap.of(CreateTable.class, (Object)new TestCreateTableTask()));
        DataDefinitionExecution dataDefinitionExecution = dataDefinitionExecutionFactory.createQueryExecution(preparedQuery, queryStateMachine, Slug.createNew(), WarningCollector.NOOP, null);
        LocalDispatchQuery localDispatchQuery = new LocalDispatchQuery(queryStateMachine, Futures.immediateFuture((Object)dataDefinitionExecution), queryMonitor, (ClusterSizeMonitor)new TestClusterSizeMonitor((InternalNodeManager)new InMemoryNodeManager((Set)ImmutableSet.of()), new NodeSchedulerConfig()), (Executor)executor, queryExecution -> dataDefinitionExecution.start());
        queryStateMachine.addStateChangeListener(state -> {
            if (state.ordinal() >= QueryState.PLANNING.ordinal()) {
                this.countDownLatch.countDown();
            }
        });
        localDispatchQuery.startWaitingForResources();
        this.countDownLatch.await();
        Assertions.assertThat((boolean)localDispatchQuery.getDispatchInfo().getCoordinatorLocation().isPresent()).isTrue();
    }

    private static class NoConnectorServicesProvider
    implements ConnectorServicesProvider {
        private NoConnectorServicesProvider() {
        }

        public void loadInitialCatalogs() {
        }

        public void ensureCatalogsLoaded(Session session, List<CatalogProperties> catalogs) {
        }

        public void pruneCatalogs(Set<CatalogHandle> catalogsInUse) {
            throw new UnsupportedOperationException();
        }

        public ConnectorServices getConnectorServices(CatalogHandle catalogHandle) {
            throw new UnsupportedOperationException();
        }
    }

    private static class TestCreateTableTask
    implements DataDefinitionTask<CreateTable> {
        private TestCreateTableTask() {
        }

        public String getName() {
            return "test";
        }

        public ListenableFuture<Void> execute(CreateTable statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
            try {
                while (true) {
                    Thread.sleep(10000L);
                }
            }
            catch (InterruptedException e) {
                return null;
            }
        }
    }

    private static class TestClusterSizeMonitor
    extends ClusterSizeMonitor {
        public TestClusterSizeMonitor(InternalNodeManager nodeManager, NodeSchedulerConfig nodeSchedulerConfig) {
            super(nodeManager, nodeSchedulerConfig);
        }

        public synchronized ListenableFuture<Void> waitForMinimumWorkers(int executionMinCount, Duration executionMaxWait) {
            return Futures.immediateVoidFuture();
        }
    }
}

