/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.ObjectMapperProvider;
import io.opentelemetry.api.trace.Span;
import io.trino.SessionTestUtils;
import io.trino.client.NodeVersion;
import io.trino.connector.CatalogServiceProvider;
import io.trino.cost.StatsAndCosts;
import io.trino.event.SplitMonitor;
import io.trino.eventlistener.EventListenerConfig;
import io.trino.eventlistener.EventListenerManager;
import io.trino.exchange.ExchangeManagerRegistry;
import io.trino.execution.BaseTestSqlTaskManager;
import io.trino.execution.DynamicFilterConfig;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.ScheduledSplit;
import io.trino.execution.SplitAssignment;
import io.trino.execution.SqlTask;
import io.trino.execution.TableExecuteContextManager;
import io.trino.execution.TaskInfo;
import io.trino.execution.TaskManagerConfig;
import io.trino.execution.TestingPageSourceProvider;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.scheduler.NodeScheduler;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.execution.scheduler.NodeSelectorFactory;
import io.trino.execution.scheduler.UniformNodeSelectorFactory;
import io.trino.index.IndexManager;
import io.trino.metadata.InMemoryNodeManager;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.Split;
import io.trino.metadata.TableHandle;
import io.trino.operator.DirectExchangeClientSupplier;
import io.trino.operator.PagesIndex;
import io.trino.operator.index.IndexJoinLookupStats;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.spiller.GenericSpillerFactory;
import io.trino.spiller.SpillerFactory;
import io.trino.split.PageSinkManager;
import io.trino.split.PageSourceManager;
import io.trino.split.PageSourceProvider;
import io.trino.sql.PlannerContext;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.gen.JoinCompiler;
import io.trino.sql.gen.JoinFilterFunctionCompiler;
import io.trino.sql.gen.OrderingCompiler;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.planner.CompilerConfig;
import io.trino.sql.planner.LocalExecutionPlanner;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.DynamicFilterSourceNode;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingMetadata;
import io.trino.testing.TestingSplit;
import io.trino.type.BlockTypeOperators;
import io.trino.util.FinalizerService;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class TaskTestUtils {
    public static final PlanNodeId TABLE_SCAN_NODE_ID = new PlanNodeId("tableScan");
    private static final CatalogHandle CATALOG_HANDLE = TestingHandles.TEST_TABLE_HANDLE.getCatalogHandle();
    public static final ScheduledSplit SPLIT = new ScheduledSplit(0L, TABLE_SCAN_NODE_ID, new Split(CATALOG_HANDLE, (ConnectorSplit)TestingSplit.createLocalSplit()));
    public static final ImmutableList<SplitAssignment> EMPTY_SPLIT_ASSIGNMENTS = ImmutableList.of();
    public static final Symbol SYMBOL = new Symbol("column");
    public static final PlanFragment PLAN_FRAGMENT = new PlanFragment(new PlanFragmentId("fragment"), (PlanNode)TableScanNode.newInstance((PlanNodeId)TABLE_SCAN_NODE_ID, (TableHandle)TestingHandles.TEST_TABLE_HANDLE, (List)ImmutableList.of((Object)SYMBOL), (Map)ImmutableMap.of((Object)SYMBOL, (Object)new TestingMetadata.TestingColumnHandle("column", 0, (Type)BigintType.BIGINT)), (boolean)false, Optional.empty()), (Map)ImmutableMap.of((Object)SYMBOL, (Object)VarcharType.VARCHAR), SystemPartitioningHandle.SOURCE_DISTRIBUTION, Optional.empty(), (List)ImmutableList.of((Object)TABLE_SCAN_NODE_ID), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)SYMBOL)).withBucketToPartition(Optional.of(new int[1])), StatsAndCosts.empty(), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty());
    public static final DynamicFilterId DYNAMIC_FILTER_SOURCE_ID = new DynamicFilterId("filter");
    public static final PlanFragment PLAN_FRAGMENT_WITH_DYNAMIC_FILTER_SOURCE = new PlanFragment(new PlanFragmentId("fragment"), (PlanNode)new DynamicFilterSourceNode(new PlanNodeId("dynamicFilterSource"), (PlanNode)TableScanNode.newInstance((PlanNodeId)TABLE_SCAN_NODE_ID, (TableHandle)TestingHandles.TEST_TABLE_HANDLE, (List)ImmutableList.of((Object)SYMBOL), (Map)ImmutableMap.of((Object)SYMBOL, (Object)new TestingMetadata.TestingColumnHandle("column", 0, (Type)BigintType.BIGINT)), (boolean)false, Optional.empty()), (Map)ImmutableMap.of((Object)DYNAMIC_FILTER_SOURCE_ID, (Object)SYMBOL)), (Map)ImmutableMap.of((Object)SYMBOL, (Object)VarcharType.VARCHAR), SystemPartitioningHandle.SOURCE_DISTRIBUTION, Optional.empty(), (List)ImmutableList.of((Object)TABLE_SCAN_NODE_ID), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)SYMBOL)).withBucketToPartition(Optional.of(new int[1])), StatsAndCosts.empty(), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty());

    private TaskTestUtils() {
    }

    public static LocalExecutionPlanner createTestingPlanner() {
        PageSourceManager pageSourceManager = new PageSourceManager(CatalogServiceProvider.singleton((CatalogHandle)CATALOG_HANDLE, (Object)new TestingPageSourceProvider()));
        FinalizerService finalizerService = new FinalizerService();
        BlockTypeOperators blockTypeOperators = new BlockTypeOperators(TestingPlannerContext.PLANNER_CONTEXT.getTypeOperators());
        NodeScheduler nodeScheduler = new NodeScheduler((NodeSelectorFactory)new UniformNodeSelectorFactory((InternalNodeManager)new InMemoryNodeManager(new InternalNode[0]), new NodeSchedulerConfig().setIncludeCoordinator(true), new NodeTaskMap(finalizerService)));
        NodePartitioningManager nodePartitioningManager = new NodePartitioningManager(nodeScheduler, TestingPlannerContext.PLANNER_CONTEXT.getTypeOperators(), CatalogServiceProvider.fail());
        PageFunctionCompiler pageFunctionCompiler = new PageFunctionCompiler(TestingPlannerContext.PLANNER_CONTEXT.getFunctionManager(), 0);
        return new LocalExecutionPlanner(TestingPlannerContext.PLANNER_CONTEXT, TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)TestingPlannerContext.PLANNER_CONTEXT), Optional.empty(), (PageSourceProvider)pageSourceManager, new IndexManager(CatalogServiceProvider.fail()), nodePartitioningManager, new PageSinkManager(CatalogServiceProvider.fail()), (DirectExchangeClientSupplier)new BaseTestSqlTaskManager.MockDirectExchangeClientSupplier(), new ExpressionCompiler(TestingPlannerContext.PLANNER_CONTEXT.getFunctionManager(), pageFunctionCompiler), pageFunctionCompiler, new JoinFilterFunctionCompiler(TestingPlannerContext.PLANNER_CONTEXT.getFunctionManager()), new IndexJoinLookupStats(), new TaskManagerConfig(), (SpillerFactory)new GenericSpillerFactory((types, spillContext, memoryContext) -> {
            throw new UnsupportedOperationException();
        }), (types, spillContext, memoryContext) -> {
            throw new UnsupportedOperationException();
        }, (types, partitionFunction, spillContext, memoryContext) -> {
            throw new UnsupportedOperationException();
        }, (PagesIndex.Factory)new PagesIndex.TestingFactory(false), new JoinCompiler(TestingPlannerContext.PLANNER_CONTEXT.getTypeOperators()), new OrderingCompiler(TestingPlannerContext.PLANNER_CONTEXT.getTypeOperators()), new DynamicFilterConfig(), blockTypeOperators, TestingPlannerContext.PLANNER_CONTEXT.getTypeOperators(), new TableExecuteContextManager(), new ExchangeManagerRegistry(), new NodeVersion("test"), new CompilerConfig());
    }

    public static TaskInfo updateTask(SqlTask sqlTask, List<SplitAssignment> splitAssignments, OutputBuffers outputBuffers) {
        return sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Span.getInvalid(), Optional.of(PLAN_FRAGMENT), splitAssignments, outputBuffers, (Map)ImmutableMap.of(), false);
    }

    public static SplitMonitor createTestSplitMonitor() {
        return new SplitMonitor(new EventListenerManager(new EventListenerConfig()), new ObjectMapperProvider().get());
    }
}

