/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.execution.BaseDataDefinitionTaskTest;
import io.trino.execution.DropTableTask;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.SaveMode;
import io.trino.sql.tree.DropTable;
import io.trino.sql.tree.QualifiedName;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDropTableTask
extends BaseDataDefinitionTaskTest {
    @Test
    public void testDropExistingTable() {
        QualifiedObjectName tableName = TestDropTableTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test_catalog", TestDropTableTask.someTable(tableName), SaveMode.FAIL);
        Assertions.assertThat(this.metadata.getTableHandle(this.testSession, tableName)).isPresent();
        MoreFutures.getFutureValue(this.executeDropTable(TestDropTableTask.asQualifiedName(tableName), false));
        Assertions.assertThat(this.metadata.getTableHandle(this.testSession, tableName)).isEmpty();
    }

    @Test
    public void testDropNotExistingTable() {
        QualifiedName tableName = TestDropTableTask.qualifiedName("not_existing_table");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeDropTable(tableName, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessage("Table '%s' does not exist", new Object[]{tableName});
    }

    @Test
    public void testDropTableIfExistsWithoutExistingCatalog() {
        QualifiedName tableName = QualifiedName.of((String)"non_existing_catalog", (String[])new String[]{"non_existing_schema", "not_existing_table"});
        MoreFutures.getFutureValue(this.executeDropTable(tableName, true));
    }

    @Test
    public void testDropTableIfExistsWithoutExistingSchema() {
        QualifiedName tableName = QualifiedName.of((String)"test_catalog", (String[])new String[]{"non_existing_schema", "not_existing_table"});
        MoreFutures.getFutureValue(this.executeDropTable(tableName, true));
    }

    @Test
    public void testDropTableIfExistsWithoutExistingTable() {
        QualifiedName tableName = TestDropTableTask.qualifiedName("not_existing_table");
        MoreFutures.getFutureValue(this.executeDropTable(tableName, true));
    }

    @Test
    public void testDropTableOnView() {
        QualifiedName viewName = TestDropTableTask.qualifiedName("existing_view");
        this.metadata.createView(this.testSession, TestDropTableTask.asQualifiedObjectName(viewName), TestDropTableTask.someView(), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeDropTable(viewName, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.GENERIC_USER_ERROR}).hasMessage("Table '%s' does not exist, but a view with that name exists. Did you mean DROP VIEW %s?", new Object[]{viewName, viewName});
    }

    @Test
    public void testDropTableIfExistsOnView() {
        QualifiedName viewName = TestDropTableTask.qualifiedName("existing_view");
        this.metadata.createView(this.testSession, TestDropTableTask.asQualifiedObjectName(viewName), TestDropTableTask.someView(), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeDropTable(viewName, true))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.GENERIC_USER_ERROR}).hasMessage("Table '%s' does not exist, but a view with that name exists. Did you mean DROP VIEW %s?", new Object[]{viewName, viewName});
    }

    @Test
    public void testDropTableOnMaterializedView() {
        QualifiedName viewName = TestDropTableTask.qualifiedName("existing_materialized_view");
        this.metadata.createMaterializedView(this.testSession, TestDropTableTask.asQualifiedObjectName(viewName), this.someMaterializedView(), false, false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeDropTable(viewName, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.GENERIC_USER_ERROR}).hasMessage("Table '%s' does not exist, but a materialized view with that name exists. Did you mean DROP MATERIALIZED VIEW %s?", new Object[]{viewName, viewName});
    }

    @Test
    public void testDropTableIfExistsOnMaterializedView() {
        QualifiedName viewName = TestDropTableTask.qualifiedName("existing_materialized_view");
        this.metadata.createMaterializedView(this.testSession, TestDropTableTask.asQualifiedObjectName(viewName), this.someMaterializedView(), false, false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeDropTable(viewName, true))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.GENERIC_USER_ERROR}).hasMessage("Table '%s' does not exist, but a materialized view with that name exists. Did you mean DROP MATERIALIZED VIEW %s?", new Object[]{viewName, viewName});
    }

    private ListenableFuture<Void> executeDropTable(QualifiedName tableName, boolean exists) {
        return new DropTableTask((Metadata)this.metadata, (AccessControl)new AllowAllAccessControl()).execute(new DropTable(tableName, exists), this.queryStateMachine, (List)ImmutableList.of(), WarningCollector.NOOP);
    }
}

