/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.connector.CatalogServiceProvider;
import io.trino.execution.BaseDataDefinitionTaskTest;
import io.trino.execution.SetPropertiesTask;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TablePropertyManager;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.SetProperties;
import io.trino.sql.tree.StringLiteral;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSetPropertiesTask
extends BaseDataDefinitionTaskTest {
    @Test
    public void testSetMaterializedViewProperties() {
        QualifiedObjectName materializedViewName = TestSetPropertiesTask.qualifiedObjectName("test_materialized_view");
        this.metadata.createMaterializedView(this.testSession, materializedViewName, this.someMaterializedView(), false, false);
        this.executeSetProperties(new SetProperties(SetProperties.Type.MATERIALIZED_VIEW, TestSetPropertiesTask.asQualifiedName(materializedViewName), (List)ImmutableList.of((Object)new Property(new Identifier("property1"), (Expression)new LongLiteral("111")), (Object)new Property(new Identifier("property2"), (Expression)new StringLiteral("abc")))));
        Assertions.assertThat((Map)this.metadata.getMaterializedView(this.testSession, materializedViewName).get().getProperties()).isEqualTo((Object)ImmutableMap.of((Object)"property1", (Object)111L, (Object)"property2", (Object)"abc"));
        this.executeSetProperties(new SetProperties(SetProperties.Type.MATERIALIZED_VIEW, TestSetPropertiesTask.asQualifiedName(materializedViewName), (List)ImmutableList.of((Object)new Property(new Identifier("property1")), (Object)new Property(new Identifier("property2")))));
        Assertions.assertThat((Map)this.metadata.getMaterializedView(this.testSession, materializedViewName).get().getProperties()).isEqualTo((Object)ImmutableMap.of((Object)"property2", (Object)"defaultProperty2Value"));
    }

    private void executeSetProperties(SetProperties statement) {
        new SetPropertiesTask(this.plannerContext, (AccessControl)new AllowAllAccessControl(), new TablePropertyManager(CatalogServiceProvider.fail()), this.materializedViewPropertyManager).execute(statement, this.queryStateMachine, (List)ImmutableList.of(), WarningCollector.NOOP);
    }
}

