/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slice;
import io.airlift.stats.CounterStat;
import io.airlift.stats.GcMonitor;
import io.airlift.stats.TestingGcMonitor;
import io.airlift.tracing.Tracing;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.trino.SessionTestUtils;
import io.trino.exchange.ExchangeManagerRegistry;
import io.trino.execution.DynamicFiltersCollector;
import io.trino.execution.SplitAssignment;
import io.trino.execution.SqlTask;
import io.trino.execution.SqlTaskExecutionFactory;
import io.trino.execution.StageId;
import io.trino.execution.TaskId;
import io.trino.execution.TaskInfo;
import io.trino.execution.TaskManagerConfig;
import io.trino.execution.TaskState;
import io.trino.execution.TaskStateMachine;
import io.trino.execution.TaskStatus;
import io.trino.execution.TaskTestUtils;
import io.trino.execution.buffer.BufferResult;
import io.trino.execution.buffer.BufferState;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.buffer.PagesSerdeUtil;
import io.trino.execution.buffer.PipelinedOutputBuffers;
import io.trino.execution.executor.TaskExecutor;
import io.trino.execution.executor.timesharing.TimeSharingTaskExecutor;
import io.trino.memory.MemoryPool;
import io.trino.memory.QueryContext;
import io.trino.operator.TaskContext;
import io.trino.spi.QueryId;
import io.trino.spi.predicate.Domain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.spiller.SpillSpaceTracker;
import io.trino.sql.planner.LocalExecutionPlanner;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.Assert;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestSqlTask {
    public static final PipelinedOutputBuffers.OutputBufferId OUT = new PipelinedOutputBuffers.OutputBufferId(0);
    private TaskExecutor taskExecutor;
    private ScheduledExecutorService taskNotificationExecutor;
    private ScheduledExecutorService driverYieldExecutor;
    private SqlTaskExecutionFactory sqlTaskExecutionFactory;
    private final AtomicInteger nextTaskId = new AtomicInteger();

    @BeforeAll
    public void setUp() {
        this.taskExecutor = new TimeSharingTaskExecutor(8, 16, 3, 4, Ticker.systemTicker());
        this.taskExecutor.start();
        this.taskNotificationExecutor = Executors.newScheduledThreadPool(10, Threads.threadsNamed((String)"task-notification-%s"));
        this.driverYieldExecutor = Executors.newScheduledThreadPool(2, Threads.threadsNamed((String)"driver-yield-%s"));
        LocalExecutionPlanner planner = TaskTestUtils.createTestingPlanner();
        this.sqlTaskExecutionFactory = new SqlTaskExecutionFactory((Executor)this.taskNotificationExecutor, this.taskExecutor, planner, TaskTestUtils.createTestSplitMonitor(), Tracing.noopTracer(), new TaskManagerConfig());
    }

    @AfterAll
    public void destroy() {
        this.taskExecutor.stop();
        this.taskExecutor = null;
        this.taskNotificationExecutor.shutdownNow();
        this.driverYieldExecutor.shutdown();
        this.sqlTaskExecutionFactory = null;
    }

    @Test
    @Timeout(value=30L)
    public void testEmptyQuery() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        TaskInfo taskInfo = sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Span.getInvalid(), Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of(), (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withNoMoreBufferIds(), (Map)ImmutableMap.of(), false);
        Assertions.assertThat((Comparable)taskInfo.getTaskStatus().getState()).isEqualTo((Object)TaskState.RUNNING);
        Assertions.assertThat((long)taskInfo.getTaskStatus().getVersion()).isEqualTo(0L);
        taskInfo = sqlTask.getTaskInfo();
        Assertions.assertThat((Comparable)taskInfo.getTaskStatus().getState()).isEqualTo((Object)TaskState.RUNNING);
        Assertions.assertThat((long)taskInfo.getTaskStatus().getVersion()).isEqualTo(0L);
        taskInfo = sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Span.getInvalid(), Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of((Object)new SplitAssignment(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of(), true)), (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withNoMoreBufferIds(), (Map)ImmutableMap.of(), false);
        Assertions.assertThat((Comparable)taskInfo.getTaskStatus().getState()).isEqualTo((Object)TaskState.FINISHED);
        taskInfo = (TaskInfo)sqlTask.getTaskInfo(0L).get();
        Assertions.assertThat((Comparable)taskInfo.getTaskStatus().getState()).isEqualTo((Object)TaskState.FINISHED);
    }

    @Test
    @Timeout(value=30L)
    public void testSimpleQuery() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        Assertions.assertThat((Comparable)sqlTask.getTaskStatus().getState()).isEqualTo((Object)TaskState.RUNNING);
        Assertions.assertThat((long)sqlTask.getTaskStatus().getVersion()).isEqualTo(0L);
        sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Span.getInvalid(), Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of((Object)new SplitAssignment(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of((Object)TaskTestUtils.SPLIT), true)), (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds(), (Map)ImmutableMap.of(), false);
        TaskInfo taskInfo = (TaskInfo)sqlTask.getTaskInfo(0L).get();
        Assertions.assertThat((Comparable)taskInfo.getTaskStatus().getState()).isEqualTo((Object)TaskState.FLUSHING);
        Assertions.assertThat((long)taskInfo.getTaskStatus().getVersion()).isEqualTo(1L);
        Assertions.assertThat((boolean)sqlTask.getTaskInfo(0L).isDone()).isTrue();
        BufferResult results = (BufferResult)sqlTask.getTaskResults(OUT, 0L, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).get();
        Assertions.assertThat((boolean)results.isBufferComplete()).isFalse();
        Assertions.assertThat((int)results.getSerializedPages().size()).isEqualTo(1);
        Assertions.assertThat((int)PagesSerdeUtil.getSerializedPagePositionCount((Slice)((Slice)results.getSerializedPages().get(0)))).isEqualTo(1);
        boolean moreResults = true;
        while (moreResults) {
            moreResults = !(results = (BufferResult)sqlTask.getTaskResults(OUT, results.getToken() + (long)results.getSerializedPages().size(), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).get()).isBufferComplete();
        }
        Assertions.assertThat((int)results.getSerializedPages().size()).isEqualTo(0);
        TaskInfo info = sqlTask.destroyTaskResults(OUT);
        Assertions.assertThat((Comparable)info.getOutputBuffers().getState()).isEqualTo((Object)BufferState.FINISHED);
        taskInfo = (TaskInfo)sqlTask.getTaskInfo(info.getTaskStatus().getVersion()).get();
        Assertions.assertThat((Comparable)taskInfo.getTaskStatus().getState()).isEqualTo((Object)TaskState.FINISHED);
        Assertions.assertThat((boolean)sqlTask.getTaskInfo(100L).isDone()).isTrue();
        taskInfo = sqlTask.getTaskInfo();
        Assertions.assertThat((Comparable)taskInfo.getTaskStatus().getState()).isEqualTo((Object)TaskState.FINISHED);
    }

    @Test
    public void testCancel() {
        int attempts;
        SqlTask sqlTask = this.createInitialTask();
        TaskInfo taskInfo = sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Span.getInvalid(), Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of(), (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds(), (Map)ImmutableMap.of(), false);
        Assertions.assertThat((Comparable)taskInfo.getTaskStatus().getState()).isEqualTo((Object)TaskState.RUNNING);
        Assertions.assertThat((Comparable)taskInfo.getStats().getEndTime()).isNull();
        taskInfo = sqlTask.getTaskInfo();
        Assertions.assertThat((Comparable)taskInfo.getTaskStatus().getState()).isEqualTo((Object)TaskState.RUNNING);
        Assertions.assertThat((Comparable)taskInfo.getStats().getEndTime()).isNull();
        taskInfo = sqlTask.cancel();
        Assertions.assertThat((boolean)taskInfo.getTaskStatus().getState().isTerminatingOrDone()).isTrue();
        for (attempts = 1; !taskInfo.getTaskStatus().getState().isDone() && attempts < 3; ++attempts) {
            taskInfo = (TaskInfo)Futures.getUnchecked((Future)sqlTask.getTaskInfo(taskInfo.getTaskStatus().getVersion()));
        }
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)taskInfo.getTaskStatus().getState()).describedAs("Failed to see CANCELED after " + attempts + " attempts", new Object[0])).isEqualTo((Object)TaskState.CANCELED);
        Assertions.assertThat((Comparable)taskInfo.getStats().getEndTime()).isNotNull();
        taskInfo = sqlTask.getTaskInfo();
        Assertions.assertThat((Comparable)taskInfo.getTaskStatus().getState()).isEqualTo((Object)TaskState.CANCELED);
        Assertions.assertThat((Comparable)taskInfo.getStats().getEndTime()).isNotNull();
    }

    @Test
    @Timeout(value=30L)
    public void testAbort() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        Assertions.assertThat((Comparable)sqlTask.getTaskStatus().getState()).isEqualTo((Object)TaskState.RUNNING);
        Assertions.assertThat((long)sqlTask.getTaskStatus().getVersion()).isEqualTo(0L);
        sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Span.getInvalid(), Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of((Object)new SplitAssignment(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of((Object)TaskTestUtils.SPLIT), true)), (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds(), (Map)ImmutableMap.of(), false);
        TaskInfo taskInfo = (TaskInfo)sqlTask.getTaskInfo(0L).get();
        Assertions.assertThat((Comparable)taskInfo.getTaskStatus().getState()).isEqualTo((Object)TaskState.FLUSHING);
        Assertions.assertThat((long)taskInfo.getTaskStatus().getVersion()).isEqualTo(1L);
        sqlTask.destroyTaskResults(OUT);
        taskInfo = (TaskInfo)sqlTask.getTaskInfo(taskInfo.getTaskStatus().getVersion()).get();
        Assertions.assertThat((Comparable)taskInfo.getTaskStatus().getState()).isEqualTo((Object)TaskState.FINISHED);
        taskInfo = sqlTask.getTaskInfo();
        Assertions.assertThat((Comparable)taskInfo.getTaskStatus().getState()).isEqualTo((Object)TaskState.FINISHED);
    }

    @Test
    public void testBufferCloseOnFinish() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        PipelinedOutputBuffers outputBuffers = PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds();
        TaskTestUtils.updateTask(sqlTask, TaskTestUtils.EMPTY_SPLIT_ASSIGNMENTS, (OutputBuffers)outputBuffers);
        ListenableFuture bufferResult = sqlTask.getTaskResults(OUT, 0L, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        Assertions.assertThat((boolean)bufferResult.isDone()).isFalse();
        TaskTestUtils.updateTask(sqlTask, (List<SplitAssignment>)ImmutableList.of((Object)new SplitAssignment(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of(), true)), (OutputBuffers)outputBuffers);
        sqlTask.destroyTaskResults(OUT);
        bufferResult.get(1L, TimeUnit.SECONDS);
        bufferResult = sqlTask.getTaskResults(OUT, 0L, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        Assertions.assertThat((boolean)bufferResult.isDone()).isTrue();
        Assertions.assertThat((boolean)((BufferResult)bufferResult.get()).isBufferComplete()).isTrue();
    }

    @Test
    public void testBufferCloseOnCancel() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        TaskTestUtils.updateTask(sqlTask, TaskTestUtils.EMPTY_SPLIT_ASSIGNMENTS, (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
        ListenableFuture bufferResult = sqlTask.getTaskResults(OUT, 0L, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        Assertions.assertThat((boolean)bufferResult.isDone()).isFalse();
        sqlTask.cancel();
        Assertions.assertThat((boolean)sqlTask.getTaskInfo().getTaskStatus().getState().isTerminatingOrDone()).isTrue();
        bufferResult.get(1L, TimeUnit.SECONDS);
        bufferResult = sqlTask.getTaskResults(OUT, 0L, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        Assertions.assertThat((boolean)bufferResult.isDone()).isTrue();
        Assertions.assertThat((boolean)((BufferResult)bufferResult.get()).isBufferComplete()).isTrue();
    }

    @Test
    @Timeout(value=30L)
    public void testBufferNotCloseOnFail() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        TaskTestUtils.updateTask(sqlTask, TaskTestUtils.EMPTY_SPLIT_ASSIGNMENTS, (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
        ListenableFuture bufferResult = sqlTask.getTaskResults(OUT, 0L, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        Assertions.assertThat((boolean)bufferResult.isDone()).isFalse();
        long taskStatusVersion = sqlTask.getTaskInfo().getTaskStatus().getVersion();
        sqlTask.failed((Throwable)new Exception("test"));
        TaskInfo taskInfo = (TaskInfo)sqlTask.getTaskInfo(taskStatusVersion).get();
        Assertions.assertThat((boolean)taskInfo.getTaskStatus().getState().isTerminatingOrDone()).isTrue();
        taskStatusVersion = taskInfo.getTaskStatus().getVersion();
        Assertions.assertThat((Comparable)((TaskInfo)sqlTask.getTaskInfo(taskStatusVersion).get()).getTaskStatus().getState()).isEqualTo((Object)TaskState.FAILED);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> bufferResult.get(1L, TimeUnit.SECONDS)).isInstanceOf(TimeoutException.class)).hasMessageContaining("Waited 1 seconds");
        Assertions.assertThat((boolean)sqlTask.getTaskResults(OUT, 0L, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).isDone()).isFalse();
    }

    @Test
    @Timeout(value=30L)
    public void testDynamicFilters() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Span.getInvalid(), Optional.of(TaskTestUtils.PLAN_FRAGMENT_WITH_DYNAMIC_FILTER_SOURCE), (List)ImmutableList.of((Object)new SplitAssignment(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of((Object)TaskTestUtils.SPLIT), false)), (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds(), (Map)ImmutableMap.of(), false);
        Assertions.assertThat((long)sqlTask.getTaskStatus().getDynamicFiltersVersion()).isEqualTo(0L);
        TaskContext taskContext = sqlTask.getQueryContext().getTaskContextByTaskId(sqlTask.getTaskId());
        ListenableFuture future = sqlTask.getTaskStatus(0L);
        Assertions.assertThat((boolean)future.isDone()).isFalse();
        taskContext.updateDomains((Map)ImmutableMap.of((Object)TaskTestUtils.DYNAMIC_FILTER_SOURCE_ID, (Object)Domain.none((Type)BigintType.BIGINT)));
        Assertions.assertThat((long)sqlTask.getTaskStatus().getVersion()).isEqualTo(1L);
        Assertions.assertThat((long)sqlTask.getTaskStatus().getDynamicFiltersVersion()).isEqualTo(1L);
        future.get();
    }

    @Test
    @Timeout(value=30L)
    public void testDynamicFilterFetchAfterTaskDone() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        PipelinedOutputBuffers outputBuffers = PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds();
        sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Span.getInvalid(), Optional.of(TaskTestUtils.PLAN_FRAGMENT_WITH_DYNAMIC_FILTER_SOURCE), (List)ImmutableList.of((Object)new SplitAssignment(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of(), false)), (OutputBuffers)outputBuffers, (Map)ImmutableMap.of(), false);
        Assertions.assertThat((long)sqlTask.getTaskStatus().getDynamicFiltersVersion()).isEqualTo(0L);
        TaskTestUtils.updateTask(sqlTask, (List<SplitAssignment>)ImmutableList.of((Object)new SplitAssignment(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of(), true)), (OutputBuffers)outputBuffers);
        TaskInfo info = sqlTask.destroyTaskResults(OUT);
        Assertions.assertThat((Comparable)info.getOutputBuffers().getState()).isEqualTo((Object)BufferState.FINISHED);
        Assert.assertEventually((Duration)new Duration(10.0, TimeUnit.SECONDS), () -> {
            TaskStatus status = (TaskStatus)sqlTask.getTaskStatus(info.getTaskStatus().getVersion()).get();
            Assertions.assertThat((Comparable)status.getState()).isEqualTo((Object)TaskState.FINISHED);
            Assertions.assertThat((long)status.getDynamicFiltersVersion()).isEqualTo(1L);
        });
        DynamicFiltersCollector.VersionedDynamicFilterDomains versionedDynamicFilters = sqlTask.acknowledgeAndGetNewDynamicFilterDomains(0L);
        Assertions.assertThat((long)versionedDynamicFilters.getVersion()).isEqualTo(1L);
        Assertions.assertThat((Map)versionedDynamicFilters.getDynamicFilterDomains()).isEqualTo((Object)ImmutableMap.of((Object)TaskTestUtils.DYNAMIC_FILTER_SOURCE_ID, (Object)Domain.none((Type)VarcharType.VARCHAR)));
    }

    private SqlTask createInitialTask() {
        TaskId taskId = new TaskId(new StageId("query", 0), this.nextTaskId.incrementAndGet(), 0);
        URI location = URI.create("fake://task/" + taskId);
        QueryContext queryContext = new QueryContext(new QueryId("query"), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), new MemoryPool(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)), (GcMonitor)new TestingGcMonitor(), (Executor)this.taskNotificationExecutor, this.driverYieldExecutor, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), new SpillSpaceTracker(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)));
        queryContext.addTaskContext(new TaskStateMachine(taskId, (Executor)this.taskNotificationExecutor), TestingSession.testSessionBuilder().build(), () -> {}, false, false);
        return SqlTask.createSqlTask((TaskId)taskId, (URI)location, (String)"fake", (QueryContext)queryContext, (Tracer)Tracing.noopTracer(), (SqlTaskExecutionFactory)this.sqlTaskExecutionFactory, (ExecutorService)this.taskNotificationExecutor, sqlTask -> {}, (DataSize)DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE), (DataSize)DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.MEGABYTE), (ExchangeManagerRegistry)new ExchangeManagerRegistry(), (CounterStat)new CounterStat());
    }
}

