/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.node.NodeInfo;
import io.airlift.stats.GcMonitor;
import io.airlift.stats.TestingGcMonitor;
import io.airlift.tracing.Tracing;
import io.airlift.units.Duration;
import io.opentelemetry.api.trace.Span;
import io.trino.Session;
import io.trino.connector.CatalogConnector;
import io.trino.connector.CatalogFactory;
import io.trino.connector.CatalogProperties;
import io.trino.connector.CatalogPruneTaskConfig;
import io.trino.connector.ConnectorName;
import io.trino.connector.ConnectorServices;
import io.trino.connector.ConnectorServicesProvider;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.TestingLocalCatalogPruneTask;
import io.trino.connector.WorkerDynamicCatalogManager;
import io.trino.exchange.ExchangeManagerRegistry;
import io.trino.execution.BaseTestSqlTaskManager;
import io.trino.execution.LocationFactory;
import io.trino.execution.SplitAssignment;
import io.trino.execution.SplitRunner;
import io.trino.execution.SqlTaskManager;
import io.trino.execution.StageId;
import io.trino.execution.TaskId;
import io.trino.execution.TaskManagementExecutor;
import io.trino.execution.TaskManagerConfig;
import io.trino.execution.TaskTestUtils;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.buffer.PipelinedOutputBuffers;
import io.trino.execution.executor.RunningSplitInfo;
import io.trino.execution.executor.TaskExecutor;
import io.trino.execution.executor.TaskHandle;
import io.trino.memory.LocalMemoryManager;
import io.trino.memory.NodeMemoryConfig;
import io.trino.metadata.CatalogManager;
import io.trino.metadata.LanguageFunctionProvider;
import io.trino.metadata.WorkerLanguageFunctionProvider;
import io.trino.spi.VersionEmbedder;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spiller.LocalSpillManager;
import io.trino.spiller.NodeSpillConfig;
import io.trino.sql.planner.PlanFragment;
import io.trino.testing.TestingConnectorContext;
import io.trino.testing.TestingSession;
import io.trino.transaction.NoOpTransactionManager;
import io.trino.transaction.TransactionInfo;
import io.trino.transaction.TransactionManager;
import io.trino.version.EmbedVersion;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestSqlTaskManagerRaceWithCatalogPrune {
    private static final int NUM_TASKS = 20000;
    private static final ConnectorServicesProvider NOOP_CONNECTOR_SERVICES_PROVIDER = new ConnectorServicesProvider(){

        public void loadInitialCatalogs() {
        }

        public void ensureCatalogsLoaded(Session session, List<CatalogProperties> catalogs) {
        }

        public void pruneCatalogs(Set<CatalogHandle> catalogsInUse) {
        }

        public ConnectorServices getConnectorServices(CatalogHandle catalogHandle) {
            return null;
        }
    };
    private static final CatalogFactory MOCK_CATALOG_FACTORY = new CatalogFactory(){

        public void addConnectorFactory(ConnectorFactory connectorFactory, Function<CatalogHandle, ClassLoader> duplicatePluginClassLoaderFactory) {
        }

        public CatalogConnector createCatalog(CatalogProperties catalogProperties) {
            Connector connector = MockConnectorFactory.create().create(catalogProperties.getCatalogHandle().getCatalogName(), catalogProperties.getProperties(), (ConnectorContext)new TestingConnectorContext());
            ConnectorServices noOpConnectorService = new ConnectorServices(Tracing.noopTracer(), catalogProperties.getCatalogHandle(), connector, () -> {});
            return new CatalogConnector(catalogProperties.getCatalogHandle(), new ConnectorName("mock"), noOpConnectorService, noOpConnectorService, noOpConnectorService, Optional.of(catalogProperties));
        }

        public CatalogConnector createCatalog(CatalogHandle catalogHandle, ConnectorName connectorName, Connector connector) {
            throw new UnsupportedOperationException("Only implement what is needed by worker catalog manager");
        }
    };
    private static final TaskExecutor NOOP_TASK_EXECUTOR = new TaskExecutor(){

        public TaskHandle addTask(TaskId taskId, DoubleSupplier utilizationSupplier, int initialSplitConcurrency, Duration splitConcurrencyAdjustFrequency, OptionalInt maxDriversPerTask) {
            return new TaskHandle(){

                public boolean isDestroyed() {
                    return false;
                }
            };
        }

        public void removeTask(TaskHandle taskHandle) {
        }

        public List<ListenableFuture<Void>> enqueueSplits(TaskHandle taskHandle, boolean intermediate, List<? extends SplitRunner> taskSplits) {
            return ImmutableList.of();
        }

        public Set<TaskId> getStuckSplitTaskIds(Duration processingDurationThreshold, Predicate<RunningSplitInfo> filter) {
            return ImmutableSet.of();
        }

        public void start() {
        }

        public void stop() {
        }
    };
    private final ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(2, 2, 10L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>());
    private final AtomicInteger sequence = new AtomicInteger(1);

    @AfterAll
    public void cleanup() {
        this.threadPoolExecutor.shutdown();
    }

    @Test
    public void testMultipleTaskUpdatesWithMultipleCatalogPrunes() {
        WorkerDynamicCatalogManager workerConnectorServiceProvider = new WorkerDynamicCatalogManager(MOCK_CATALOG_FACTORY);
        SqlTaskManager workerTaskManager = TestSqlTaskManagerRaceWithCatalogPrune.getWorkerTaskManagerWithConnectorServiceProvider((ConnectorServicesProvider)workerConnectorServiceProvider);
        TestingLocalCatalogPruneTask catalogPruneTask = new TestingLocalCatalogPruneTask((TransactionManager)new NoInfoTransactionManager(), CatalogManager.NO_CATALOGS, NOOP_CONNECTOR_SERVICES_PROVIDER, new NodeInfo("testversion"), new CatalogPruneTaskConfig(), workerTaskManager);
        ListenableFuture catalogTaskFuture = Futures.submit(() -> this.lambda$testMultipleTaskUpdatesWithMultipleCatalogPrunes$1(workerTaskManager, (ConnectorServicesProvider)workerConnectorServiceProvider), (Executor)this.threadPoolExecutor);
        ListenableFuture pruneCatalogsFuture = Futures.submit(() -> {
            for (int i = 0; i < 20000; ++i) {
                catalogPruneTask.pruneWorkerCatalogs();
                try {
                    Thread.sleep(0L, ThreadLocalRandom.current().nextInt(25, 75));
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }, (Executor)this.threadPoolExecutor);
        Assertions.assertDoesNotThrow(() -> TestSqlTaskManagerRaceWithCatalogPrune.lambda$testMultipleTaskUpdatesWithMultipleCatalogPrunes$3((Future)catalogTaskFuture));
        Assertions.assertDoesNotThrow(() -> TestSqlTaskManagerRaceWithCatalogPrune.lambda$testMultipleTaskUpdatesWithMultipleCatalogPrunes$4((Future)pruneCatalogsFuture));
    }

    private TaskId newTaskId() {
        return new TaskId(new StageId("query" + this.sequence.incrementAndGet(), 0), 1, 0);
    }

    private static SqlTaskManager getWorkerTaskManagerWithConnectorServiceProvider(ConnectorServicesProvider workerConnectorServiceProvider) {
        return new SqlTaskManager((VersionEmbedder)new EmbedVersion("testversion"), workerConnectorServiceProvider, TaskTestUtils.createTestingPlanner(), (LanguageFunctionProvider)new WorkerLanguageFunctionProvider(), (LocationFactory)new BaseTestSqlTaskManager.MockLocationFactory(), NOOP_TASK_EXECUTOR, TaskTestUtils.createTestSplitMonitor(), new NodeInfo("testversion"), new LocalMemoryManager(new NodeMemoryConfig()), new TaskManagementExecutor(), new TaskManagerConfig().setInfoMaxAge(Duration.ZERO), new NodeMemoryConfig(), new LocalSpillManager(new NodeSpillConfig()), new NodeSpillConfig(), (GcMonitor)new TestingGcMonitor(), Tracing.noopTracer(), new ExchangeManagerRegistry(), ignore -> true);
    }

    private static PlanFragment fragmentWithCatalog(CatalogHandle catalogHandle) {
        return TaskTestUtils.PLAN_FRAGMENT.withActiveCatalogs((List)ImmutableList.of((Object)new CatalogProperties(catalogHandle, new ConnectorName("mock"), (Map)ImmutableMap.of())));
    }

    private static /* synthetic */ Void lambda$testMultipleTaskUpdatesWithMultipleCatalogPrunes$4(Future pruneCatalogsFuture) throws Throwable {
        return (Void)pruneCatalogsFuture.get(2L, TimeUnit.MINUTES);
    }

    private static /* synthetic */ Void lambda$testMultipleTaskUpdatesWithMultipleCatalogPrunes$3(Future catalogTaskFuture) throws Throwable {
        return (Void)catalogTaskFuture.get(2L, TimeUnit.MINUTES);
    }

    private /* synthetic */ void lambda$testMultipleTaskUpdatesWithMultipleCatalogPrunes$1(SqlTaskManager workerTaskManager, ConnectorServicesProvider workerConnectorServiceProvider) {
        for (int i = 0; i < 20000; ++i) {
            String catalogName = "catalog_" + i;
            CatalogHandle catalogHandle = CatalogHandle.createRootCatalogHandle((String)catalogName, (CatalogHandle.CatalogVersion)new CatalogHandle.CatalogVersion(UUID.randomUUID().toString()));
            TaskId taskId = this.newTaskId();
            workerTaskManager.updateTask(TestingSession.testSession(), taskId, Span.getInvalid(), Optional.of(TestSqlTaskManagerRaceWithCatalogPrune.fragmentWithCatalog(catalogHandle)), (List)ImmutableList.of((Object)new SplitAssignment(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of(), true)), (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(BaseTestSqlTaskManager.OUT, 0).withNoMoreBufferIds(), (Map)ImmutableMap.of(), false);
            try {
                Thread.sleep(0L, ThreadLocalRandom.current().nextInt(25, 75));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            Assertions.assertDoesNotThrow(() -> workerConnectorServiceProvider.getConnectorServices(catalogHandle));
            workerTaskManager.cancelTask(taskId);
            if ((i & 0x3F) != 0) continue;
            workerTaskManager.removeOldTasks();
        }
    }

    private static class NoInfoTransactionManager
    extends NoOpTransactionManager {
        private NoInfoTransactionManager() {
        }

        public List<TransactionInfo> getAllTransactionInfos() {
            return ImmutableList.of();
        }
    }
}

