/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.Lists;
import io.trino.array.LongBigArray;
import io.trino.operator.GroupedTopNRankAccumulator;
import io.trino.operator.RowIdComparisonHashStrategy;
import io.trino.operator.RowIdComparisonStrategy;
import io.trino.operator.RowIdHashStrategy;
import io.trino.operator.RowReference;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestGroupedTopNRankAccumulator {
    private static final RowIdComparisonHashStrategy STRATEGY = new RowIdComparisonHashStrategy(){

        public int compare(long leftRowId, long rightRowId) {
            return Long.compare(leftRowId, rightRowId);
        }

        public long hashCode(long rowId) {
            return rowId;
        }
    };

    @DataProvider
    public static Object[][] parameters() {
        List<Integer> topNs = Arrays.asList(1, 2, 3);
        List<Integer> valueCounts = Arrays.asList(0, 1, 2, 4, 8);
        List<Integer> groupCounts = Arrays.asList(1, 2, 3);
        List<Boolean> drainWithRankings = Arrays.asList(true, false);
        return TestGroupedTopNRankAccumulator.to2DArray(Lists.cartesianProduct((List[])new List[]{topNs, valueCounts, groupCounts, drainWithRankings}));
    }

    private static Object[][] to2DArray(List<List<Object>> nestedList) {
        Object[][] array = new Object[nestedList.size()][];
        for (int i = 0; i < nestedList.size(); ++i) {
            array[i] = nestedList.get(i).toArray();
        }
        return array;
    }

    @Test(dataProvider="parameters")
    public void testSinglePeerGroupInsert(int topN, long valueCount, long groupCount, boolean drainWithRanking) {
        LongArrayList evicted = new LongArrayList();
        GroupedTopNRankAccumulator accumulator = new GroupedTopNRankAccumulator(STRATEGY, topN, ((List)evicted)::add);
        accumulator.verifyIntegrity();
        int rowId = -1;
        int i = 0;
        while ((long)i < valueCount) {
            int groupId = 0;
            while ((long)groupId < groupCount) {
                Assertions.assertThat((boolean)accumulator.add(groupId, TestGroupedTopNRankAccumulator.toRowReference(rowId))).isTrue();
                accumulator.verifyIntegrity();
                Assertions.assertThat((boolean)evicted.isEmpty()).isTrue();
                ++groupId;
            }
            ++i;
        }
        int groupId = 0;
        while ((long)groupId < groupCount) {
            LongBigArray rowIdOutput = new LongBigArray();
            LongBigArray rankingOutput = new LongBigArray();
            if (drainWithRanking) {
                Assertions.assertThat((long)accumulator.drainTo(groupId, rowIdOutput, rankingOutput)).isEqualTo(valueCount);
            } else {
                Assertions.assertThat((long)accumulator.drainTo(groupId, rowIdOutput)).isEqualTo(valueCount);
            }
            accumulator.verifyIntegrity();
            int i2 = 0;
            while ((long)i2 < valueCount) {
                Assertions.assertThat((long)rowIdOutput.get((long)i2)).isEqualTo((long)rowId);
                if (drainWithRanking) {
                    Assertions.assertThat((long)rankingOutput.get((long)i2)).isEqualTo(1L);
                }
                ++i2;
            }
            ++groupId;
        }
    }

    @Test(dataProvider="parameters")
    public void testIncreasingAllUniqueValues(int topN, long valueCount, long groupCount, boolean drainWithRanking) {
        LongArrayList evicted = new LongArrayList();
        GroupedTopNRankAccumulator accumulator = new GroupedTopNRankAccumulator(STRATEGY, topN, ((List)evicted)::add);
        accumulator.verifyIntegrity();
        int rowId = 0;
        while ((long)rowId < valueCount) {
            int groupId = 0;
            while ((long)groupId < groupCount) {
                Assertions.assertThat((boolean)accumulator.add(groupId, TestGroupedTopNRankAccumulator.toRowReference(rowId))).isEqualTo(rowId < topN);
                accumulator.verifyIntegrity();
                Assertions.assertThat((boolean)evicted.isEmpty()).isTrue();
                ++groupId;
            }
            ++rowId;
        }
        long expectedResultCount = Math.min(valueCount, (long)topN);
        int groupId = 0;
        while ((long)groupId < groupCount) {
            LongBigArray rowIdOutput = new LongBigArray();
            LongBigArray rankingOutput = new LongBigArray();
            if (drainWithRanking) {
                Assertions.assertThat((long)accumulator.drainTo(groupId, rowIdOutput, rankingOutput)).isEqualTo(expectedResultCount);
            } else {
                Assertions.assertThat((long)accumulator.drainTo(groupId, rowIdOutput)).isEqualTo(expectedResultCount);
            }
            accumulator.verifyIntegrity();
            int rowId2 = 0;
            while ((long)rowId2 < expectedResultCount) {
                Assertions.assertThat((long)rowIdOutput.get((long)rowId2)).isEqualTo((long)rowId2);
                if (drainWithRanking) {
                    Assertions.assertThat((long)rankingOutput.get((long)rowId2)).isEqualTo((long)(rowId2 + 1));
                }
                ++rowId2;
            }
            ++groupId;
        }
    }

    @Test(dataProvider="parameters")
    public void testDecreasingAllUniqueValues(int topN, long valueCount, long groupCount, boolean drainWithRanking) {
        LongArrayList evicted = new LongArrayList();
        GroupedTopNRankAccumulator accumulator = new GroupedTopNRankAccumulator(STRATEGY, topN, ((List)evicted)::add);
        accumulator.verifyIntegrity();
        ArrayList<Long> expectedEvicted = new ArrayList<Long>();
        for (long rowId = valueCount - 1L; rowId >= 0L; --rowId) {
            int groupId = 0;
            while ((long)groupId < groupCount) {
                Assertions.assertThat((boolean)accumulator.add(groupId, TestGroupedTopNRankAccumulator.toRowReference(rowId))).isTrue();
                accumulator.verifyIntegrity();
                if (rowId >= (long)topN) {
                    expectedEvicted.add(rowId);
                }
                ++groupId;
            }
        }
        Assertions.assertThat((List)evicted).isEqualTo(expectedEvicted);
        int groupId = 0;
        while ((long)groupId < groupCount) {
            LongBigArray rowIdOutput = new LongBigArray();
            LongBigArray rankingOutput = new LongBigArray();
            long expectedResultCount = Math.min(valueCount, (long)topN);
            if (drainWithRanking) {
                Assertions.assertThat((long)accumulator.drainTo(groupId, rowIdOutput, rankingOutput)).isEqualTo(expectedResultCount);
            } else {
                Assertions.assertThat((long)accumulator.drainTo(groupId, rowIdOutput)).isEqualTo(expectedResultCount);
            }
            accumulator.verifyIntegrity();
            int rowId = 0;
            while ((long)rowId < expectedResultCount) {
                Assertions.assertThat((long)rowIdOutput.get((long)rowId)).isEqualTo((long)rowId);
                if (drainWithRanking) {
                    Assertions.assertThat((long)rankingOutput.get((long)rowId)).isEqualTo((long)(rowId + 1));
                }
                ++rowId;
            }
            ++groupId;
        }
    }

    @Test
    public void testMultipleDuplicateValues() {
        int topN = 3;
        LongArrayList evicted = new LongArrayList();
        GroupedTopNRankAccumulator accumulator = new GroupedTopNRankAccumulator(STRATEGY, topN, ((List)evicted)::add);
        accumulator.verifyIntegrity();
        Assertions.assertThat((boolean)accumulator.add(0, TestGroupedTopNRankAccumulator.toRowReference(0L))).isTrue();
        accumulator.verifyIntegrity();
        Assertions.assertThat((boolean)evicted.isEmpty()).isTrue();
        Assertions.assertThat((boolean)accumulator.add(0, TestGroupedTopNRankAccumulator.toRowReference(1L))).isTrue();
        accumulator.verifyIntegrity();
        Assertions.assertThat((boolean)evicted.isEmpty()).isTrue();
        Assertions.assertThat((boolean)accumulator.add(0, TestGroupedTopNRankAccumulator.toRowReference(0L))).isTrue();
        accumulator.verifyIntegrity();
        Assertions.assertThat((boolean)evicted.isEmpty()).isTrue();
        Assertions.assertThat((boolean)accumulator.add(0, TestGroupedTopNRankAccumulator.toRowReference(1L))).isTrue();
        accumulator.verifyIntegrity();
        Assertions.assertThat((boolean)evicted.isEmpty()).isTrue();
        Assertions.assertThat((boolean)accumulator.add(0, TestGroupedTopNRankAccumulator.toRowReference(0L))).isTrue();
        accumulator.verifyIntegrity();
        Assertions.assertThat((List)evicted).isEqualTo(Arrays.asList(1L, 1L));
        Assertions.assertThat((boolean)accumulator.add(0, TestGroupedTopNRankAccumulator.toRowReference(-1L))).isTrue();
        accumulator.verifyIntegrity();
        Assertions.assertThat((List)evicted).isEqualTo(Arrays.asList(1L, 1L));
        Assertions.assertThat((boolean)accumulator.add(0, TestGroupedTopNRankAccumulator.toRowReference(-1L))).isTrue();
        accumulator.verifyIntegrity();
        Assertions.assertThat((List)evicted).isEqualTo(Arrays.asList(1L, 1L));
        LongBigArray rowIdOutput = new LongBigArray();
        LongBigArray rankingOutput = new LongBigArray();
        Assertions.assertThat((long)accumulator.drainTo(0, rowIdOutput, rankingOutput)).isEqualTo(5L);
        Assertions.assertThat((long)rowIdOutput.get(0L)).isEqualTo(-1L);
        Assertions.assertThat((long)rankingOutput.get(0L)).isEqualTo(1L);
        Assertions.assertThat((long)rowIdOutput.get(1L)).isEqualTo(-1L);
        Assertions.assertThat((long)rankingOutput.get(1L)).isEqualTo(1L);
        Assertions.assertThat((long)rowIdOutput.get(2L)).isEqualTo(0L);
        Assertions.assertThat((long)rankingOutput.get(2L)).isEqualTo(3L);
        Assertions.assertThat((long)rowIdOutput.get(3L)).isEqualTo(0L);
        Assertions.assertThat((long)rankingOutput.get(3L)).isEqualTo(3L);
        Assertions.assertThat((long)rowIdOutput.get(4L)).isEqualTo(0L);
        Assertions.assertThat((long)rankingOutput.get(4L)).isEqualTo(3L);
    }

    private static RowReference toRowReference(final long rowId) {
        return new RowReference(){

            public int compareTo(RowIdComparisonStrategy strategy, long otherRowId) {
                return strategy.compare(rowId, otherRowId);
            }

            public boolean equals(RowIdHashStrategy strategy, long otherRowId) {
                return strategy.equals(rowId, otherRowId);
            }

            public long hash(RowIdHashStrategy strategy) {
                return strategy.hashCode(rowId);
            }

            public long allocateRowId() {
                return rowId;
            }
        };
    }
}

