/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.RowPageBuilder;
import io.trino.RowPagesBuilder;
import io.trino.operator.GroupByHash;
import io.trino.operator.GroupedTopNRankBuilder;
import io.trino.operator.NoChannelGroupByHash;
import io.trino.operator.PageAssertions;
import io.trino.operator.PageWithPositionComparator;
import io.trino.operator.PageWithPositionEqualsAndHash;
import io.trino.operator.SimplePageWithPositionComparator;
import io.trino.operator.SimplePageWithPositionEqualsAndHash;
import io.trino.operator.UpdateMemory;
import io.trino.operator.Work;
import io.trino.spi.Page;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.gen.JoinCompiler;
import io.trino.type.BlockTypeOperators;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestGroupedTopNRankBuilder {
    @DataProvider
    public static Object[][] produceRanking() {
        return new Object[][]{{true}, {false}};
    }

    @Test
    public void testEmptyInput() {
        GroupedTopNRankBuilder groupedTopNBuilder = new GroupedTopNRankBuilder((List)ImmutableList.of((Object)BigintType.BIGINT), (left, leftPosition, right, rightPosition) -> {
            throw new UnsupportedOperationException();
        }, new PageWithPositionEqualsAndHash(){

            public boolean equals(Page left, int leftPosition, Page right, int rightPosition) {
                throw new UnsupportedOperationException();
            }

            public long hashCode(Page page, int position) {
                throw new UnsupportedOperationException();
            }
        }, 5, false, new int[0], (GroupByHash)new NoChannelGroupByHash());
        Assertions.assertThat((boolean)groupedTopNBuilder.buildResult().hasNext()).isFalse();
    }

    @Test(dataProvider="produceRanking")
    public void testSingleGroupTopN(boolean produceRanking) {
        TypeOperators typeOperators = new TypeOperators();
        BlockTypeOperators blockTypeOperators = new BlockTypeOperators(typeOperators);
        ImmutableList types = ImmutableList.of((Object)DoubleType.DOUBLE);
        GroupedTopNRankBuilder groupedTopNBuilder = new GroupedTopNRankBuilder((List)types, (PageWithPositionComparator)new SimplePageWithPositionComparator((List)types, (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), typeOperators), (PageWithPositionEqualsAndHash)new SimplePageWithPositionEqualsAndHash((List)types, (List)ImmutableList.of((Object)0), blockTypeOperators), 3, produceRanking, new int[0], (GroupByHash)new NoChannelGroupByHash());
        Assertions.assertThat((boolean)groupedTopNBuilder.processPage(RowPageBuilder.rowPageBuilder((Iterable<Type>)types).row(0.3).row(0.3).row(0.2).build()).process()).isTrue();
        Assertions.assertThat((boolean)groupedTopNBuilder.processPage(RowPageBuilder.rowPageBuilder((Iterable<Type>)types).row(0.4).build()).process()).isTrue();
        Assertions.assertThat((boolean)groupedTopNBuilder.processPage(RowPageBuilder.rowPageBuilder((Iterable<Type>)types).row(0.1).row(0.2).row(0.3).row(0.2).row(0.1).build()).process()).isTrue();
        ImmutableList output = ImmutableList.copyOf((Iterator)groupedTopNBuilder.buildResult());
        Assertions.assertThat((int)output.size()).isEqualTo(1);
        Object outputTypes = ImmutableList.of((Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT);
        Page expected = RowPageBuilder.rowPageBuilder((Iterable<Type>)outputTypes).row(0.1, 1).row(0.1, 1).row(0.2, 3).row(0.2, 3).row(0.2, 3).build();
        if (!produceRanking) {
            outputTypes = outputTypes.subList(0, outputTypes.size() - 1);
            expected = TestGroupedTopNRankBuilder.dropLastColumn(expected);
        }
        PageAssertions.assertPageEquals((List<? extends Type>)outputTypes, (Page)Iterables.getOnlyElement((Iterable)output), expected);
    }

    @Test(dataProvider="produceRanking")
    public void testMultiGroupTopN(boolean produceRanking) {
        TypeOperators typeOperators = new TypeOperators();
        BlockTypeOperators blockTypeOperators = new BlockTypeOperators(typeOperators);
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE);
        GroupByHash groupByHash = this.createGroupByHash((Type)types.get(0), UpdateMemory.NOOP, typeOperators);
        GroupedTopNRankBuilder groupedTopNBuilder = new GroupedTopNRankBuilder((List)types, (PageWithPositionComparator)new SimplePageWithPositionComparator((List)types, (List)ImmutableList.of((Object)1), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), typeOperators), (PageWithPositionEqualsAndHash)new SimplePageWithPositionEqualsAndHash((List)types, (List)ImmutableList.of((Object)1), blockTypeOperators), 3, produceRanking, new int[]{0}, groupByHash);
        Assertions.assertThat((boolean)groupedTopNBuilder.processPage(RowPageBuilder.rowPageBuilder((Iterable<Type>)types).row(0L, 0.3).row(0L, 0.3).row(0L, 0.3).row(0L, 0.2).row(1L, 0.2).build()).process()).isTrue();
        Assertions.assertThat((boolean)groupedTopNBuilder.processPage(RowPageBuilder.rowPageBuilder((Iterable<Type>)types).row(0L, 0.4).row(1L, 0.4).build()).process()).isTrue();
        Assertions.assertThat((boolean)groupedTopNBuilder.processPage(RowPageBuilder.rowPageBuilder((Iterable<Type>)types).row(0L, 0.1).row(1L, 0.2).row(0L, 0.3).row(0L, 0.2).row(1L, 0.5).row(1L, 0.4).row(1L, 0.3).row(1L, 0.3).build()).process()).isTrue();
        ImmutableList output = ImmutableList.copyOf((Iterator)groupedTopNBuilder.buildResult());
        Assertions.assertThat((int)output.size()).isEqualTo(1);
        Object outputTypes = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT);
        Page expected = RowPageBuilder.rowPageBuilder((Iterable<Type>)outputTypes).row(0, 0.1, 1).row(0, 0.2, 2).row(0, 0.2, 2).row(1, 0.2, 1).row(1, 0.2, 1).row(1, 0.3, 3).row(1, 0.3, 3).build();
        if (!produceRanking) {
            outputTypes = outputTypes.subList(0, outputTypes.size() - 1);
            expected = TestGroupedTopNRankBuilder.dropLastColumn(expected);
        }
        PageAssertions.assertPageEquals((List<? extends Type>)outputTypes, (Page)Iterables.getOnlyElement((Iterable)output), expected);
    }

    @Test
    public void testYield() {
        TypeOperators typeOperators = new TypeOperators();
        BlockTypeOperators blockTypeOperators = new BlockTypeOperators(typeOperators);
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE);
        Page input = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(1L, 0.3).row(1L, 0.2).row(1L, 0.9).row(1L, 0.1).build().get(0);
        input.compact();
        AtomicBoolean unblock = new AtomicBoolean();
        GroupByHash groupByHash = this.createGroupByHash((Type)types.get(0), unblock::get, typeOperators);
        GroupedTopNRankBuilder groupedTopNBuilder = new GroupedTopNRankBuilder((List)types, (PageWithPositionComparator)new SimplePageWithPositionComparator((List)types, (List)ImmutableList.of((Object)1), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), typeOperators), (PageWithPositionEqualsAndHash)new SimplePageWithPositionEqualsAndHash((List)types, (List)ImmutableList.of((Object)1), blockTypeOperators), 5, false, new int[]{0}, groupByHash);
        Work work = groupedTopNBuilder.processPage(input);
        Assertions.assertThat((boolean)work.process()).isFalse();
        Assertions.assertThat((boolean)work.process()).isFalse();
        unblock.set(true);
        Assertions.assertThat((boolean)work.process()).isTrue();
        ImmutableList output = ImmutableList.copyOf((Iterator)groupedTopNBuilder.buildResult());
        Assertions.assertThat((int)output.size()).isEqualTo(1);
        Page expected = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(1L, 0.1).row(1L, 0.2).row(1L, 0.3).row(1L, 0.9).build().get(0);
        PageAssertions.assertPageEquals((List<? extends Type>)types, (Page)output.get(0), expected);
    }

    private GroupByHash createGroupByHash(Type partitionType, UpdateMemory updateMemory, TypeOperators typeOperators) {
        return GroupByHash.createGroupByHash((List)ImmutableList.of((Object)partitionType), (boolean)false, (int)1, (boolean)false, (JoinCompiler)new JoinCompiler(typeOperators), (UpdateMemory)updateMemory);
    }

    private static Page dropLastColumn(Page page) {
        Preconditions.checkArgument((page.getChannelCount() > 0 ? 1 : 0) != 0);
        return page.getColumns(IntStream.range(0, page.getChannelCount() - 1).toArray());
    }
}

