/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import io.trino.ExceededMemoryLimitException;
import io.trino.RowPagesBuilder;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.operator.DriverContext;
import io.trino.operator.DummySpillerFactory;
import io.trino.operator.OperatorAssertion;
import io.trino.operator.OperatorFactory;
import io.trino.operator.OrderByOperator;
import io.trino.operator.PagesIndex;
import io.trino.spi.Page;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.OrderingCompiler;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.MaterializedResult;
import io.trino.testing.TestingTaskContext;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestOrderByOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private DummySpillerFactory spillerFactory;
    private final TypeOperators typeOperators = new TypeOperators();

    @DataProvider
    public static Object[][] spillEnabled() {
        return new Object[][]{{false, false, 0}, {true, false, 8}, {true, true, 8}, {true, false, 0}, {true, true, 0}};
    }

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
        this.spillerFactory = new DummySpillerFactory();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
        this.spillerFactory = null;
    }

    @Test(dataProvider="spillEnabled")
    public void testMultipleOutputPages(boolean spillEnabled, boolean revokeMemoryWhenAddingPages, long memoryLimit) {
        int numberOfRows = 80000;
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).addSequencePage(numberOfRows, 0, 0).build();
        OrderByOperator.OrderByOperatorFactory operatorFactory = new OrderByOperator.OrderByOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), (List)ImmutableList.of((Object)1), 10, (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)SortOrder.DESC_NULLS_LAST), (PagesIndex.Factory)new PagesIndex.TestingFactory(false), spillEnabled, Optional.of(this.spillerFactory), new OrderingCompiler(this.typeOperators));
        DriverContext driverContext = this.createDriverContext(memoryLimit);
        MaterializedResult.Builder expectedBuilder = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE});
        for (int i = 0; i < numberOfRows; ++i) {
            expectedBuilder.row(new Object[]{(double)numberOfRows - (double)i - 1.0});
        }
        MaterializedResult expected = expectedBuilder.build();
        List<Page> pages = OperatorAssertion.toPages((OperatorFactory)operatorFactory, driverContext, input, revokeMemoryWhenAddingPages);
        io.airlift.testing.Assertions.assertGreaterThan((Comparable)Integer.valueOf(pages.size()), (Comparable)Integer.valueOf(1), (String)"Expected more than one output page");
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), expected.getTypes(), pages);
        Assertions.assertThat((List)actual.getMaterializedRows()).isEqualTo((Object)expected.getMaterializedRows());
        ((AbstractBooleanAssert)Assertions.assertThat((spillEnabled == this.spillerFactory.getSpillsCount() > 0L ? 1 : 0) != 0).describedAs(String.format("Spill state mismatch. Expected spill: %s, spill count: %s", spillEnabled, this.spillerFactory.getSpillsCount()), new Object[0])).isTrue();
    }

    @Test(dataProvider="spillEnabled")
    public void testSingleFieldKey(boolean spillEnabled, boolean revokeMemoryWhenAddingPages, long memoryLimit) {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(1L, 0.1).row(2L, 0.2).pageBreak().row(-1L, -0.1).row(4L, 0.4).build();
        OrderByOperator.OrderByOperatorFactory operatorFactory = new OrderByOperator.OrderByOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), (List)ImmutableList.of((Object)1), 10, (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), (PagesIndex.Factory)new PagesIndex.TestingFactory(false), spillEnabled, Optional.of(this.spillerFactory), new OrderingCompiler(this.typeOperators));
        DriverContext driverContext = this.createDriverContext(memoryLimit);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE}).row(new Object[]{-0.1}).row(new Object[]{0.1}).row(new Object[]{0.2}).row(new Object[]{0.4}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, driverContext, input, expected, revokeMemoryWhenAddingPages);
    }

    @Test(dataProvider="spillEnabled")
    public void testMultiFieldKey(boolean spillEnabled, boolean revokeMemoryWhenAddingPages, long memoryLimit) {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, BigintType.BIGINT}).row("a", 1L).row("b", 2L).pageBreak().row("b", 3L).row("a", 4L).build();
        OrderByOperator.OrderByOperatorFactory operatorFactory = new OrderByOperator.OrderByOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT), (List)ImmutableList.of((Object)0, (Object)1), 10, (List)ImmutableList.of((Object)0, (Object)1), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST, (Object)SortOrder.DESC_NULLS_LAST), (PagesIndex.Factory)new PagesIndex.TestingFactory(false), spillEnabled, Optional.of(this.spillerFactory), new OrderingCompiler(this.typeOperators));
        DriverContext driverContext = this.createDriverContext(memoryLimit);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{"a", 4L}).row(new Object[]{"a", 1L}).row(new Object[]{"b", 3L}).row(new Object[]{"b", 2L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, driverContext, input, expected, revokeMemoryWhenAddingPages);
    }

    @Test(dataProvider="spillEnabled")
    public void testReverseOrder(boolean spillEnabled, boolean revokeMemoryWhenAddingPages, long memoryLimit) {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(1L, 0.1).row(2L, 0.2).pageBreak().row(-1L, -0.1).row(4L, 0.4).build();
        OrderByOperator.OrderByOperatorFactory operatorFactory = new OrderByOperator.OrderByOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), (List)ImmutableList.of((Object)0), 10, (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)SortOrder.DESC_NULLS_LAST), (PagesIndex.Factory)new PagesIndex.TestingFactory(false), spillEnabled, Optional.of(this.spillerFactory), new OrderingCompiler(this.typeOperators));
        DriverContext driverContext = this.createDriverContext(memoryLimit);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{4L}).row(new Object[]{2L}).row(new Object[]{1L}).row(new Object[]{-1L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, driverContext, input, expected, revokeMemoryWhenAddingPages);
    }

    @Test
    public void testMemoryLimit() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(1L, 0.1).row(2L, 0.2).pageBreak().row(-1L, -0.1).row(4L, 0.4).build();
        DriverContext driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (DataSize)DataSize.ofBytes((long)10L)).addPipelineContext(0, true, true, false).addDriverContext();
        OrderByOperator.OrderByOperatorFactory operatorFactory = new OrderByOperator.OrderByOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), (List)ImmutableList.of((Object)1), 10, (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), (PagesIndex.Factory)new PagesIndex.TestingFactory(false), false, Optional.of(this.spillerFactory), new OrderingCompiler(this.typeOperators));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> OperatorAssertion.toPages((OperatorFactory)operatorFactory, driverContext, input)).isInstanceOf(ExceededMemoryLimitException.class)).hasMessageMatching("Query exceeded per-node memory limit of 10B.*");
    }

    private DriverContext createDriverContext(long memoryLimit) {
        return TestingTaskContext.builder((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).setMemoryPoolSize(DataSize.succinctBytes((long)memoryLimit)).build().addPipelineContext(0, true, true, false).addDriverContext();
    }
}

