/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.block.BlockAssertions;
import io.trino.jmh.Benchmarks;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.operator.aggregation.GroupedAggregator;
import io.trino.operator.aggregation.TestingAggregationFunction;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.plan.AggregationNode;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Test;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.runner.RunnerException;

@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=3)
@Warmup(iterations=7)
@Measurement(iterations=20)
public class BenchmarkGroupedTypedHistogram {
    @Benchmark
    public GroupedAggregator testSharedGroupWithLargeBlocksRunner(Data data) {
        GroupedAggregator groupedAggregator = data.groupedAggregator;
        for (int i = 0; i < data.numGroups; ++i) {
            int groupCount = data.groupCounts[i];
            int[] groupByIdBlock = data.groupByIdBlocks[i];
            Page page = data.pages[i];
            groupedAggregator.processPage(groupCount, groupByIdBlock, page);
        }
        return groupedAggregator;
    }

    private static TestingAggregationFunction getInternalAggregationFunctionVarChar() {
        TestingFunctionResolution functionResolution = new TestingFunctionResolution();
        return functionResolution.getAggregateFunction("histogram", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR}));
    }

    @Test
    public void test() {
        Data data = new Data();
        data.setUp();
        this.testSharedGroupWithLargeBlocksRunner(data);
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkGroupedTypedHistogram.class).withOptions(optionsBuilder -> optionsBuilder.addProfiler(GCProfiler.class)).run();
    }

    @State(value=Scope.Thread)
    public static class Data {
        @Param(value={"10000"})
        private int numGroups;
        @Param(value={"5000"})
        private int rowCount;
        @Param(value={"0.1"})
        private float distinctFraction;
        @Param(value={"32"})
        private int rowSize;
        private final Random random = new Random();
        private Page[] pages;
        private int[] groupCounts;
        private int[][] groupByIdBlocks;
        private GroupedAggregator groupedAggregator;

        @Setup
        public void setUp() {
            this.pages = new Page[this.numGroups];
            this.groupCounts = new int[this.numGroups];
            this.groupByIdBlocks = new int[this.numGroups][];
            for (int j = 0; j < this.numGroups; ++j) {
                ArrayList<String> valueList = new ArrayList<String>();
                for (int i = 0; i < this.rowCount; ++i) {
                    boolean distinctValue;
                    String str = String.valueOf(i % 10);
                    String item = IntStream.range(0, this.rowSize).mapToObj(x -> str).collect(Collectors.joining());
                    boolean bl = distinctValue = this.random.nextDouble() < (double)this.distinctFraction;
                    if (distinctValue) {
                        valueList.add(j + "-" + item);
                        continue;
                    }
                    valueList.add(item);
                }
                ValueBlock block = BlockAssertions.createStringsBlock(valueList);
                Page page = new Page(new Block[]{block});
                int[] groupByIdBlock = AggregationTestUtils.createGroupByIdBlock(j, page.getPositionCount());
                this.pages[j] = page;
                this.groupCounts[j] = j;
                this.groupByIdBlocks[j] = groupByIdBlock;
            }
            TestingAggregationFunction aggregationFunction = BenchmarkGroupedTypedHistogram.getInternalAggregationFunctionVarChar();
            this.groupedAggregator = aggregationFunction.createAggregatorFactory(AggregationNode.Step.SINGLE, (List<Integer>)ImmutableList.of((Object)0), OptionalInt.empty()).createGroupedAggregator();
        }
    }

    public static enum ProbeType {
        LINEAR,
        SUM_OF_COUNT,
        SUM_OF_SQUARE;

    }
}

