/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.unnest;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ColumnarArray;
import io.trino.spi.block.ColumnarMap;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;

public final class TestingUnnesterUtil {
    private TestingUnnesterUtil() {
    }

    public static Block createSimpleBlock(Slice[] values) {
        VariableWidthBlockBuilder elementBlockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, values.length);
        for (Slice v : values) {
            if (v == null) {
                elementBlockBuilder.appendNull();
                continue;
            }
            VarcharType.VARCHAR.writeSlice((BlockBuilder)elementBlockBuilder, v);
        }
        return elementBlockBuilder.build();
    }

    public static Block createArrayBlock(Slice[][] values) {
        ArrayType arrayType = new ArrayType((Type)VarcharType.VARCHAR);
        ArrayBlockBuilder blockBuilder = arrayType.createBlockBuilder(null, 100, 100);
        for (Slice[] expectedValue : values) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            arrayType.writeObject((BlockBuilder)blockBuilder, (Object)TestingUnnesterUtil.createSimpleBlock(expectedValue));
        }
        return blockBuilder.build();
    }

    public static Block createArrayBlockOfRowBlocks(Slice[][][] elements, RowType rowType) {
        ArrayType arrayType = new ArrayType((Type)rowType);
        ArrayBlockBuilder arrayBlockBuilder = arrayType.createBlockBuilder(null, 100, 100);
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] == null) {
                arrayBlockBuilder.appendNull();
                continue;
            }
            Slice[][] expectedValues = elements[i];
            RowBlockBuilder elementBlockBuilder = rowType.createBlockBuilder(null, elements[i].length);
            for (Slice[] expectedValue : expectedValues) {
                if (expectedValue == null) {
                    elementBlockBuilder.appendNull();
                    continue;
                }
                elementBlockBuilder.buildEntry(fieldBuilders -> {
                    for (int fieldId = 0; fieldId < expectedValue.length; ++fieldId) {
                        Slice v = expectedValue[fieldId];
                        if (v == null) {
                            ((BlockBuilder)fieldBuilders.get(fieldId)).appendNull();
                            continue;
                        }
                        VarcharType.VARCHAR.writeSlice((BlockBuilder)fieldBuilders.get(fieldId), v);
                    }
                });
            }
            arrayType.writeObject((BlockBuilder)arrayBlockBuilder, (Object)elementBlockBuilder.build());
        }
        return arrayBlockBuilder.build();
    }

    public static boolean nullExists(Slice[][] elements) {
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] == null) continue;
            for (int j = 0; j < elements[i].length; ++j) {
                if (elements[i][j] != null) continue;
                return true;
            }
        }
        return false;
    }

    public static Slice[] computeExpectedUnnestedOutput(Slice[][] elements, int[] requiredOutputCounts, int startPosition, int length) {
        Preconditions.checkArgument((startPosition >= 0 && length >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((startPosition + length - 1 < requiredOutputCounts.length ? 1 : 0) != 0);
        Preconditions.checkArgument((elements.length == requiredOutputCounts.length ? 1 : 0) != 0);
        int outputCount = 0;
        for (int i = 0; i < length; ++i) {
            int position = startPosition + i;
            int arrayLength = elements[position] == null ? 0 : elements[position].length;
            Preconditions.checkArgument((requiredOutputCounts[position] >= arrayLength ? 1 : 0) != 0);
            outputCount += requiredOutputCounts[position];
        }
        Slice[] expectedOutput = new Slice[outputCount];
        int offset = 0;
        for (int i = 0; i < length; ++i) {
            int j;
            int position = startPosition + i;
            int arrayLength = elements[position] == null ? 0 : elements[position].length;
            int requiredCount = requiredOutputCounts[position];
            for (j = 0; j < arrayLength; ++j) {
                expectedOutput[offset++] = elements[position][j];
            }
            for (j = 0; j < requiredCount - arrayLength; ++j) {
                expectedOutput[offset++] = null;
            }
        }
        return expectedOutput;
    }

    public static Slice[][] getFieldElements(Slice[][][] slices, int fieldNo) {
        Slice[][] output = new Slice[slices.length][];
        for (int i = 0; i < slices.length; ++i) {
            if (slices[i] != null) {
                output[i] = new Slice[slices[i].length];
                for (int j = 0; j < slices[i].length; ++j) {
                    output[i][j] = slices[i][j] != null ? slices[i][j][fieldNo] : null;
                }
                continue;
            }
            output[i] = null;
        }
        return output;
    }

    public static void validateTestInput(int[] requiredOutputCounts, int[] unnestedLengths, Slice[][][] slices, int fieldCount) {
        Objects.requireNonNull(requiredOutputCounts, "requiredOutputCounts is null");
        Objects.requireNonNull(unnestedLengths, "unnestedLengths is null");
        Objects.requireNonNull(slices, "slices array is null");
        int positionCount = slices.length;
        Assertions.assertThat((int)requiredOutputCounts.length).isEqualTo(positionCount);
        Assertions.assertThat((int)unnestedLengths.length).isEqualTo(positionCount);
        for (int i = 0; i < requiredOutputCounts.length; ++i) {
            Assertions.assertThat((unnestedLengths[i] <= requiredOutputCounts[i] ? 1 : 0) != 0).isTrue();
        }
        for (int index = 0; index < positionCount; ++index) {
            Slice[][] entry = slices[index];
            int entryLength = entry != null ? entry.length : 0;
            Assertions.assertThat((int)entryLength).isEqualTo(unnestedLengths[index]);
            for (int i = 0; i < entryLength; ++i) {
                if (entry[i] == null) continue;
                Assertions.assertThat((int)entry[i].length).isEqualTo(fieldCount);
            }
        }
    }

    public static Slice[] createReplicatedOutputSlice(Slice[] input, int[] counts) {
        Assertions.assertThat((int)input.length).isEqualTo(counts.length);
        int outputLength = 0;
        for (int i = 0; i < input.length; ++i) {
            outputLength += counts[i];
        }
        Slice[] output = new Slice[outputLength];
        int offset = 0;
        for (int i = 0; i < input.length; ++i) {
            for (int j = 0; j < counts[i]; ++j) {
                output[offset++] = input[i];
            }
        }
        return output;
    }

    static Slice[][][] column(Slice[][] ... arraysOfRow) {
        return arraysOfRow;
    }

    static Slice[][] array(Slice[] ... rows) {
        return rows;
    }

    static Slice[] toSlices(String ... values) {
        Slice[] slices = new Slice[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            slices[i] = Slices.utf8Slice((String)values[i]);
        }
        return slices;
    }

    static UnnestedLengths calculateMaxCardinalities(Page page, List<Type> replicatedTypes, List<Type> unnestTypes, boolean outer) {
        int positionCount = page.getPositionCount();
        int[] maxCardinalities = new int[positionCount];
        int replicatedChannelCount = replicatedTypes.size();
        int unnestChannelCount = unnestTypes.size();
        for (int i = 0; i < unnestChannelCount; ++i) {
            int j;
            Type type = unnestTypes.get(i);
            Block block = page.getBlock(replicatedChannelCount + i);
            Assertions.assertThat((type instanceof ArrayType || type instanceof MapType ? 1 : 0) != 0).isTrue();
            if (type instanceof ArrayType) {
                ColumnarArray columnarArray = ColumnarArray.toColumnarArray((Block)block);
                for (j = 0; j < positionCount; ++j) {
                    maxCardinalities[j] = Math.max(maxCardinalities[j], columnarArray.getLength(j));
                }
                continue;
            }
            if (type instanceof MapType) {
                ColumnarMap columnarMap = ColumnarMap.toColumnarMap((Block)block);
                for (j = 0; j < positionCount; ++j) {
                    maxCardinalities[j] = Math.max(maxCardinalities[j], columnarMap.getEntryCount(j));
                }
                continue;
            }
            throw new RuntimeException("expected an ArrayType or MapType, but found " + type);
        }
        if (outer) {
            boolean[] nullAppendForOuter = new boolean[positionCount];
            for (int j = 0; j < positionCount; ++j) {
                if (maxCardinalities[j] != 0) continue;
                maxCardinalities[j] = 1;
                nullAppendForOuter[j] = true;
            }
            return new UnnestedLengths(maxCardinalities, Optional.of(nullAppendForOuter));
        }
        return new UnnestedLengths(maxCardinalities, Optional.empty());
    }

    static Page buildExpectedPage(Page page, List<Type> replicatedTypes, List<Type> unnestTypes, List<Type> outputTypes, UnnestedLengths unnestedLengths, boolean withOrdinality) {
        int i;
        int totalEntries = IntStream.of(unnestedLengths.getMaxCardinalities()).sum();
        int[] maxCardinalities = unnestedLengths.getMaxCardinalities();
        int channelCount = page.getChannelCount();
        Assertions.assertThat((channelCount > 1 ? 1 : 0) != 0).isTrue();
        Block[] outputBlocks = new Block[outputTypes.size()];
        int outputChannel = 0;
        for (i = 0; i < replicatedTypes.size(); ++i) {
            outputBlocks[outputChannel++] = TestingUnnesterUtil.buildExpectedReplicatedBlock(page.getBlock(i), replicatedTypes.get(i), maxCardinalities, totalEntries);
        }
        for (i = 0; i < unnestTypes.size(); ++i) {
            Type type = unnestTypes.get(i);
            Block inputBlock = page.getBlock(replicatedTypes.size() + i);
            if (type instanceof ArrayType) {
                Type elementType = ((ArrayType)type).getElementType();
                if (elementType instanceof RowType) {
                    Block[] blocks;
                    List rowTypes = elementType.getTypeParameters();
                    Block[] blockArray = blocks = TestingUnnesterUtil.buildExpectedUnnestedArrayOfRowBlock(inputBlock, rowTypes, maxCardinalities, totalEntries);
                    int n = blockArray.length;
                    for (int j = 0; j < n; ++j) {
                        Block block = blockArray[j];
                        outputBlocks[outputChannel++] = block;
                    }
                    continue;
                }
                outputBlocks[outputChannel++] = TestingUnnesterUtil.buildExpectedUnnestedArrayBlock(inputBlock, ((ArrayType)unnestTypes.get(i)).getElementType(), maxCardinalities, totalEntries);
                continue;
            }
            if (type instanceof MapType) {
                Block[] blocks;
                MapType mapType = (MapType)unnestTypes.get(i);
                for (Block block : blocks = TestingUnnesterUtil.buildExpectedUnnestedMapBlocks(inputBlock, mapType.getKeyType(), mapType.getValueType(), maxCardinalities, totalEntries)) {
                    outputBlocks[outputChannel++] = block;
                }
                continue;
            }
            throw new RuntimeException("expected an ArrayType or MapType, but found " + type);
        }
        if (withOrdinality) {
            outputBlocks[outputChannel++] = TestingUnnesterUtil.buildExpectedOrdinalityBlock(unnestedLengths, totalEntries);
        }
        return new Page(outputBlocks);
    }

    static List<Type> buildOutputTypes(List<Type> replicatedTypes, List<Type> unnestTypes, boolean withOrdinality) {
        ArrayList<Type> outputTypes = new ArrayList<Type>();
        for (Type replicatedType : replicatedTypes) {
            outputTypes.add(replicatedType);
        }
        for (Type unnestType : unnestTypes) {
            if (unnestType instanceof ArrayType) {
                Type elementType = ((ArrayType)unnestType).getElementType();
                if (elementType instanceof RowType) {
                    List rowTypes = ((RowType)elementType).getTypeParameters();
                    for (Type rowType : rowTypes) {
                        outputTypes.add(rowType);
                    }
                    continue;
                }
                outputTypes.add(elementType);
                continue;
            }
            if (!(unnestType instanceof MapType)) continue;
            outputTypes.add(((MapType)unnestType).getKeyType());
            outputTypes.add(((MapType)unnestType).getValueType());
        }
        if (withOrdinality) {
            outputTypes.add((Type)BigintType.BIGINT);
        }
        return outputTypes;
    }

    static Page mergePages(List<Type> types, List<Page> pages) {
        PageBuilder pageBuilder = new PageBuilder(types);
        int totalPositionCount = 0;
        for (Page page : pages) {
            Verify.verify((page.getChannelCount() == types.size() ? 1 : 0) != 0, (String)String.format("Number of channels in page %d is not equal to number of types %d", page.getChannelCount(), types.size()), (Object[])new Object[0]);
            for (int i = 0; i < types.size(); ++i) {
                BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(i);
                Block block = page.getBlock(i);
                for (int position = 0; position < page.getPositionCount(); ++position) {
                    if (block.isNull(position)) {
                        blockBuilder.appendNull();
                        continue;
                    }
                    types.get(i).appendTo(block, position, blockBuilder);
                }
            }
            totalPositionCount += page.getPositionCount();
        }
        pageBuilder.declarePositions(totalPositionCount);
        return pageBuilder.build();
    }

    private static Block buildExpectedReplicatedBlock(Block block, Type type, int[] maxCardinalities, int totalEntries) {
        BlockBuilder blockBuilder = type.createBlockBuilder(null, totalEntries);
        int positionCount = block.getPositionCount();
        for (int i = 0; i < positionCount; ++i) {
            int cardinality = maxCardinalities[i];
            for (int j = 0; j < cardinality; ++j) {
                type.appendTo(block, i, blockBuilder);
            }
        }
        return blockBuilder.build();
    }

    private static Block buildExpectedUnnestedArrayBlock(Block block, Type type, int[] maxCardinalities, int totalEntries) {
        ColumnarArray columnarArray = ColumnarArray.toColumnarArray((Block)block);
        Block elementBlock = columnarArray.getElementsBlock();
        BlockBuilder blockBuilder = type.createBlockBuilder(null, totalEntries);
        int positionCount = block.getPositionCount();
        int elementBlockPosition = 0;
        for (int i = 0; i < positionCount; ++i) {
            int cardinality = columnarArray.getLength(i);
            for (int j = 0; j < cardinality; ++j) {
                type.appendTo(elementBlock, elementBlockPosition++, blockBuilder);
            }
            int maxCardinality = maxCardinalities[i];
            for (int j = cardinality; j < maxCardinality; ++j) {
                blockBuilder.appendNull();
            }
        }
        return blockBuilder.build();
    }

    private static Block[] buildExpectedUnnestedMapBlocks(Block block, Type keyType, Type valueType, int[] maxCardinalities, int totalEntries) {
        ColumnarMap columnarMap = ColumnarMap.toColumnarMap((Block)block);
        Block keyBlock = columnarMap.getKeysBlock();
        Block valuesBlock = columnarMap.getValuesBlock();
        BlockBuilder keyBlockBuilder = keyType.createBlockBuilder(null, totalEntries);
        BlockBuilder valueBlockBuilder = valueType.createBlockBuilder(null, totalEntries);
        int positionCount = block.getPositionCount();
        int blockPosition = 0;
        for (int i = 0; i < positionCount; ++i) {
            int cardinality = columnarMap.getEntryCount(i);
            for (int j = 0; j < cardinality; ++j) {
                keyType.appendTo(keyBlock, blockPosition, keyBlockBuilder);
                valueType.appendTo(valuesBlock, blockPosition, valueBlockBuilder);
                ++blockPosition;
            }
            int maxCardinality = maxCardinalities[i];
            for (int j = cardinality; j < maxCardinality; ++j) {
                keyBlockBuilder.appendNull();
                valueBlockBuilder.appendNull();
            }
        }
        Block[] blocks = new Block[]{keyBlockBuilder.build(), valueBlockBuilder.build()};
        return blocks;
    }

    private static Block[] buildExpectedUnnestedArrayOfRowBlock(Block block, List<Type> rowTypes, int[] maxCardinalities, int totalEntries) {
        ColumnarArray columnarArray = ColumnarArray.toColumnarArray((Block)block);
        Block elementBlock = columnarArray.getElementsBlock();
        List fields = RowBlock.getRowFieldsFromBlock((Block)elementBlock);
        Block[] blocks = new Block[fields.size()];
        int positionCount = block.getPositionCount();
        for (int i = 0; i < fields.size(); ++i) {
            BlockBuilder blockBuilder = rowTypes.get(i).createBlockBuilder(null, totalEntries);
            for (int j = 0; j < positionCount; ++j) {
                int rowBlockIndex = columnarArray.getOffset(j);
                int cardinality = columnarArray.getLength(j);
                for (int k = 0; k < cardinality; ++k) {
                    rowTypes.get(i).appendTo((Block)fields.get(i), rowBlockIndex + k, blockBuilder);
                }
                int maxCardinality = maxCardinalities[j];
                for (int k = cardinality; k < maxCardinality; ++k) {
                    blockBuilder.appendNull();
                }
            }
            blocks[i] = blockBuilder.build();
        }
        return blocks;
    }

    private static Block buildExpectedOrdinalityBlock(UnnestedLengths unnestedLengths, int totalEntries) {
        int[] maxCardinalities = unnestedLengths.getMaxCardinalities();
        BlockBuilder ordinalityBlockBuilder = BigintType.BIGINT.createBlockBuilder(null, totalEntries);
        for (int i = 0; i < maxCardinalities.length; ++i) {
            int maxCardinality = maxCardinalities[i];
            if (maxCardinality == 1 && unnestedLengths.isNullAppendForOuter(i)) {
                ordinalityBlockBuilder.appendNull();
                continue;
            }
            for (int ordinalityCount = 1; ordinalityCount <= maxCardinality; ++ordinalityCount) {
                BigintType.BIGINT.writeLong(ordinalityBlockBuilder, (long)ordinalityCount);
            }
        }
        return ordinalityBlockBuilder.build();
    }

    static class UnnestedLengths {
        private final int[] maxCardinalities;
        private final Optional<boolean[]> nullAppendForOuter;

        public UnnestedLengths(int[] maxCardinalities, Optional<boolean[]> nullAppendForOuter) {
            this.maxCardinalities = Objects.requireNonNull(maxCardinalities, "maxCardinalities is null");
            this.nullAppendForOuter = Objects.requireNonNull(nullAppendForOuter, "nullAppendForOuter is null");
            if (nullAppendForOuter.isPresent()) {
                Preconditions.checkArgument((maxCardinalities.length == nullAppendForOuter.get().length ? 1 : 0) != 0);
            }
        }

        public int[] getMaxCardinalities() {
            return this.maxCardinalities;
        }

        public boolean isNullAppendForOuter(int position) {
            if (this.nullAppendForOuter.isEmpty()) {
                return false;
            }
            Preconditions.checkArgument((position >= 0 && position < this.nullAppendForOuter.get().length ? 1 : 0) != 0);
            return this.nullAppendForOuter.get()[position];
        }
    }
}

