/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import io.airlift.jaxrs.testing.GuavaMultivaluedMap;
import io.opentelemetry.api.trace.Span;
import io.trino.Session;
import io.trino.client.ProtocolHeaders;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.SessionPropertyManager;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.server.HttpRequestSessionContextFactory;
import io.trino.server.ProtocolConfig;
import io.trino.server.QuerySessionSupplier;
import io.trino.server.SessionContext;
import io.trino.server.protocol.PreparedStatementEncoder;
import io.trino.spi.QueryId;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.type.TimeZoneKey;
import io.trino.sql.SqlEnvironmentConfig;
import io.trino.sql.SqlPath;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionManager;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestQuerySessionSupplier {
    private static final MultivaluedMap<String, String> TEST_HEADERS = new GuavaMultivaluedMap((Multimap)ImmutableListMultimap.builder().put((Object)ProtocolHeaders.TRINO_HEADERS.requestUser(), (Object)"testUser").put((Object)ProtocolHeaders.TRINO_HEADERS.requestSource(), (Object)"testSource").put((Object)ProtocolHeaders.TRINO_HEADERS.requestCatalog(), (Object)"testCatalog").put((Object)ProtocolHeaders.TRINO_HEADERS.requestSchema(), (Object)"testSchema").put((Object)ProtocolHeaders.TRINO_HEADERS.requestPath(), (Object)"testPath").put((Object)ProtocolHeaders.TRINO_HEADERS.requestLanguage(), (Object)"zh-TW").put((Object)ProtocolHeaders.TRINO_HEADERS.requestTimeZone(), (Object)"Asia/Taipei").put((Object)ProtocolHeaders.TRINO_HEADERS.requestClientInfo(), (Object)"client-info").put((Object)ProtocolHeaders.TRINO_HEADERS.requestClientTags(), (Object)"tag1,tag2 ,tag3, tag2").put((Object)ProtocolHeaders.TRINO_HEADERS.requestSession(), (Object)"query_max_memory=1GB").put((Object)ProtocolHeaders.TRINO_HEADERS.requestSession(), (Object)"join_distribution_type=partitioned,max_hash_partition_count = 43").put((Object)ProtocolHeaders.TRINO_HEADERS.requestPreparedStatement(), (Object)"query1=select * from foo,query2=select * from bar").build());
    private static final HttpRequestSessionContextFactory SESSION_CONTEXT_FACTORY = new HttpRequestSessionContextFactory(new PreparedStatementEncoder(new ProtocolConfig()), (Metadata)MetadataManager.createTestMetadataManager(), ImmutableSet::of, (AccessControl)new AllowAllAccessControl());

    @Test
    public void testCreateSession() {
        SessionContext context = SESSION_CONTEXT_FACTORY.createSessionContext(TEST_HEADERS, Optional.empty(), Optional.of("testRemote"), Optional.empty());
        QuerySessionSupplier sessionSupplier = TestQuerySessionSupplier.createSessionSupplier(new SqlEnvironmentConfig());
        Session session = sessionSupplier.createSession(new QueryId("test_query_id"), Span.getInvalid(), context);
        Assertions.assertThat((Object)session.getQueryId()).isEqualTo((Object)new QueryId("test_query_id"));
        Assertions.assertThat((String)session.getUser()).isEqualTo("testUser");
        Assertions.assertThat((String)((String)session.getSource().get())).isEqualTo("testSource");
        Assertions.assertThat((String)((String)session.getCatalog().get())).isEqualTo("testCatalog");
        Assertions.assertThat((String)((String)session.getSchema().get())).isEqualTo("testSchema");
        Assertions.assertThat((String)session.getPath().getRawPath()).isEqualTo("testPath");
        Assertions.assertThat((Object)session.getLocale()).isEqualTo((Object)Locale.TAIWAN);
        Assertions.assertThat((Object)session.getTimeZoneKey()).isEqualTo((Object)TimeZoneKey.getTimeZoneKey((String)"Asia/Taipei"));
        Assertions.assertThat((String)((String)session.getRemoteUserAddress().get())).isEqualTo("testRemote");
        Assertions.assertThat((String)((String)session.getClientInfo().get())).isEqualTo("client-info");
        Assertions.assertThat((Collection)session.getClientTags()).isEqualTo((Object)ImmutableSet.of((Object)"tag1", (Object)"tag2", (Object)"tag3"));
        Assertions.assertThat((Map)session.getSystemProperties()).isEqualTo((Object)ImmutableMap.builder().put((Object)"query_max_memory", (Object)"1GB").put((Object)"join_distribution_type", (Object)"partitioned").put((Object)"max_hash_partition_count", (Object)"43").buildOrThrow());
        Assertions.assertThat((Map)session.getPreparedStatements()).isEqualTo((Object)ImmutableMap.builder().put((Object)"query1", (Object)"select * from foo").put((Object)"query2", (Object)"select * from bar").buildOrThrow());
    }

    @Test
    public void testEmptyClientTags() {
        GuavaMultivaluedMap headers1 = new GuavaMultivaluedMap((Multimap)ImmutableListMultimap.of((Object)ProtocolHeaders.TRINO_HEADERS.requestUser(), (Object)"testUser"));
        SessionContext context1 = SESSION_CONTEXT_FACTORY.createSessionContext((MultivaluedMap)headers1, Optional.empty(), Optional.of("remoteAddress"), Optional.empty());
        Assertions.assertThat((Collection)context1.getClientTags()).isEqualTo((Object)ImmutableSet.of());
        GuavaMultivaluedMap headers2 = new GuavaMultivaluedMap((Multimap)ImmutableListMultimap.builder().put((Object)ProtocolHeaders.TRINO_HEADERS.requestUser(), (Object)"testUser").put((Object)ProtocolHeaders.TRINO_HEADERS.requestClientTags(), (Object)"").build());
        SessionContext context2 = SESSION_CONTEXT_FACTORY.createSessionContext((MultivaluedMap)headers2, Optional.empty(), Optional.of("remoteAddress"), Optional.empty());
        Assertions.assertThat((Collection)context2.getClientTags()).isEqualTo((Object)ImmutableSet.of());
    }

    @Test
    public void testClientCapabilities() {
        GuavaMultivaluedMap headers1 = new GuavaMultivaluedMap((Multimap)ImmutableListMultimap.builder().put((Object)ProtocolHeaders.TRINO_HEADERS.requestUser(), (Object)"testUser").put((Object)ProtocolHeaders.TRINO_HEADERS.requestClientCapabilities(), (Object)"foo, bar").build());
        SessionContext context1 = SESSION_CONTEXT_FACTORY.createSessionContext((MultivaluedMap)headers1, Optional.empty(), Optional.of("remoteAddress"), Optional.empty());
        Assertions.assertThat((Collection)context1.getClientCapabilities()).isEqualTo((Object)ImmutableSet.of((Object)"foo", (Object)"bar"));
        GuavaMultivaluedMap headers2 = new GuavaMultivaluedMap((Multimap)ImmutableListMultimap.of((Object)ProtocolHeaders.TRINO_HEADERS.requestUser(), (Object)"testUser"));
        SessionContext context2 = SESSION_CONTEXT_FACTORY.createSessionContext((MultivaluedMap)headers2, Optional.empty(), Optional.of("remoteAddress"), Optional.empty());
        Assertions.assertThat((Collection)context2.getClientCapabilities()).isEqualTo((Object)ImmutableSet.of());
    }

    @Test
    public void testInvalidTimeZone() {
        GuavaMultivaluedMap headers = new GuavaMultivaluedMap((Multimap)ImmutableListMultimap.builder().put((Object)ProtocolHeaders.TRINO_HEADERS.requestUser(), (Object)"testUser").put((Object)ProtocolHeaders.TRINO_HEADERS.requestTimeZone(), (Object)"unknown_timezone").build());
        SessionContext context = SESSION_CONTEXT_FACTORY.createSessionContext((MultivaluedMap)headers, Optional.empty(), Optional.of("remoteAddress"), Optional.empty());
        QuerySessionSupplier sessionSupplier = TestQuerySessionSupplier.createSessionSupplier(new SqlEnvironmentConfig());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sessionSupplier.createSession(new QueryId("test_query_id"), Span.getInvalid(), context)).isInstanceOf(TrinoException.class)).hasMessage("Time zone not supported: unknown_timezone");
    }

    @Test
    public void testSqlPathCreation() {
        String rawPath = "normal.schema,\"who.uses.periods\".\"in.schema.names\",\"same,deal\".\"with,commas\",aterrible.\"thing!@#$%^&*()\"";
        SqlPath path = SqlPath.buildPath((String)rawPath, Optional.empty());
        Assertions.assertThat((List)path.getPath()).isEqualTo((Object)ImmutableList.builder().add((Object)new CatalogSchemaName("system", "$query")).add((Object)new CatalogSchemaName("system", "builtin")).add((Object)new CatalogSchemaName("normal", "schema")).add((Object)new CatalogSchemaName("who.uses.periods", "in.schema.names")).add((Object)new CatalogSchemaName("same,deal", "with,commas")).add((Object)new CatalogSchemaName("aterrible", "thing!@#$%^&*()")).build());
        Assertions.assertThat((String)path.toString()).isEqualTo(rawPath);
    }

    @Test
    public void testDefaultCatalogAndSchema() {
        Session session = TestQuerySessionSupplier.createSession((ListMultimap<String, String>)ImmutableListMultimap.of((Object)ProtocolHeaders.TRINO_HEADERS.requestUser(), (Object)"testUser"), new SqlEnvironmentConfig());
        Assertions.assertThat((Optional)session.getCatalog()).isEmpty();
        Assertions.assertThat((Optional)session.getSchema()).isEmpty();
        session = TestQuerySessionSupplier.createSession((ListMultimap<String, String>)ImmutableListMultimap.of((Object)ProtocolHeaders.TRINO_HEADERS.requestUser(), (Object)"testUser"), new SqlEnvironmentConfig().setDefaultCatalog("default-catalog"));
        Assertions.assertThat((Optional)session.getCatalog()).contains((Object)"default-catalog");
        Assertions.assertThat((Optional)session.getSchema()).isEmpty();
        session = TestQuerySessionSupplier.createSession((ListMultimap<String, String>)ImmutableListMultimap.of((Object)ProtocolHeaders.TRINO_HEADERS.requestUser(), (Object)"testUser"), new SqlEnvironmentConfig().setDefaultCatalog("default-catalog").setDefaultSchema("default-schema"));
        Assertions.assertThat((Optional)session.getCatalog()).contains((Object)"default-catalog");
        Assertions.assertThat((Optional)session.getSchema()).contains((Object)"default-schema");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestQuerySessionSupplier.createSessionSupplier(new SqlEnvironmentConfig().setDefaultSchema("schema"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Default schema cannot be set if catalog is not set");
        session = TestQuerySessionSupplier.createSession((ListMultimap<String, String>)ImmutableListMultimap.builder().put((Object)ProtocolHeaders.TRINO_HEADERS.requestUser(), (Object)"testUser").put((Object)ProtocolHeaders.TRINO_HEADERS.requestCatalog(), (Object)"catalog").put((Object)ProtocolHeaders.TRINO_HEADERS.requestSchema(), (Object)"schema").build(), new SqlEnvironmentConfig().setDefaultCatalog("default-catalog").setDefaultSchema("default-schema"));
        Assertions.assertThat((Optional)session.getCatalog()).contains((Object)"catalog");
        Assertions.assertThat((Optional)session.getSchema()).contains((Object)"schema");
        session = TestQuerySessionSupplier.createSession((ListMultimap<String, String>)ImmutableListMultimap.builder().put((Object)ProtocolHeaders.TRINO_HEADERS.requestUser(), (Object)"testUser").put((Object)ProtocolHeaders.TRINO_HEADERS.requestCatalog(), (Object)"catalog").build(), new SqlEnvironmentConfig().setDefaultCatalog("default-catalog").setDefaultSchema("default-schema"));
        Assertions.assertThat((Optional)session.getCatalog()).contains((Object)"catalog");
        Assertions.assertThat((Optional)session.getSchema()).isEmpty();
    }

    private static Session createSession(ListMultimap<String, String> headers, SqlEnvironmentConfig config) {
        GuavaMultivaluedMap headerMap = new GuavaMultivaluedMap(headers);
        SessionContext context = SESSION_CONTEXT_FACTORY.createSessionContext((MultivaluedMap)headerMap, Optional.empty(), Optional.of("testRemote"), Optional.empty());
        QuerySessionSupplier sessionSupplier = TestQuerySessionSupplier.createSessionSupplier(config);
        return sessionSupplier.createSession(new QueryId("test_query_id"), Span.getInvalid(), context);
    }

    private static QuerySessionSupplier createSessionSupplier(SqlEnvironmentConfig config) {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager(transactionManager).build();
        return new QuerySessionSupplier((Metadata)metadata, (AccessControl)new AllowAllAccessControl(), new SessionPropertyManager(), config);
    }
}

