/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.operator.scalar.JoniRegexpCasts;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.expression.FieldDereference;
import io.trino.spi.expression.FunctionName;
import io.trino.spi.expression.StandardFunctions;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.planner.BuiltinFunctionCallBuilder;
import io.trino.sql.planner.ConnectorExpressionTranslator;
import io.trino.sql.planner.LiteralEncoder;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ArithmeticUnaryExpression;
import io.trino.sql.tree.BetweenPredicate;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.DoubleLiteral;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.InListExpression;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.IsNotNullPredicate;
import io.trino.sql.tree.IsNullPredicate;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.NullIfExpression;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.SymbolReference;
import io.trino.testing.TestingSession;
import io.trino.transaction.TestingTransactionManager;
import io.trino.transaction.TransactionBuilder;
import io.trino.transaction.TransactionManager;
import io.trino.type.JoniRegexpType;
import io.trino.type.LikeFunctions;
import io.trino.type.LikePatternType;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestConnectorExpressionTranslator {
    private static final Session TEST_SESSION = TestingSession.testSessionBuilder().build();
    private static final TypeAnalyzer TYPE_ANALYZER = TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)TestingPlannerContext.PLANNER_CONTEXT);
    private static final Type ROW_TYPE = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"int_symbol_1", (Type)IntegerType.INTEGER), RowType.field((String)"varchar_symbol_1", (Type)VarcharType.createVarcharType((int)5))});
    private static final VarcharType VARCHAR_TYPE = VarcharType.createVarcharType((int)25);
    private static final ArrayType VARCHAR_ARRAY_TYPE = new ArrayType((Type)VARCHAR_TYPE);
    private static final LiteralEncoder LITERAL_ENCODER = new LiteralEncoder(TestingPlannerContext.PLANNER_CONTEXT);
    private static final Map<Symbol, Type> symbols = ImmutableMap.builder().put((Object)new Symbol("double_symbol_1"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("double_symbol_2"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("row_symbol_1"), (Object)ROW_TYPE).put((Object)new Symbol("varchar_symbol_1"), (Object)VARCHAR_TYPE).put((Object)new Symbol("boolean_symbol_1"), (Object)BooleanType.BOOLEAN).buildOrThrow();
    private static final TypeProvider TYPE_PROVIDER = TypeProvider.copyOf(symbols);
    private static final Map<String, Symbol> variableMappings = (Map)symbols.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((Symbol)entry.getKey()).getName(), Map.Entry::getKey));

    @Test
    public void testTranslateConstant() {
        this.testTranslateConstant(true, (Type)BooleanType.BOOLEAN);
        this.testTranslateConstant(42L, (Type)TinyintType.TINYINT);
        this.testTranslateConstant(42L, (Type)SmallintType.SMALLINT);
        this.testTranslateConstant(42L, (Type)IntegerType.INTEGER);
        this.testTranslateConstant(42L, (Type)BigintType.BIGINT);
        this.testTranslateConstant(42L, (Type)RealType.REAL);
        this.testTranslateConstant(42.0, (Type)DoubleType.DOUBLE);
        this.testTranslateConstant(4200L, (Type)DecimalType.createDecimalType((int)4, (int)2));
        this.testTranslateConstant(4200L, (Type)DecimalType.createDecimalType((int)8, (int)2));
        this.testTranslateConstant(Slices.utf8Slice((String)"abc"), (Type)VarcharType.createVarcharType((int)3));
        this.testTranslateConstant(Slices.utf8Slice((String)"abc"), (Type)VarcharType.createVarcharType((int)33));
    }

    private void testTranslateConstant(Object nativeValue, Type type) {
        this.assertTranslationRoundTrips(LITERAL_ENCODER.toExpression(nativeValue, type), (ConnectorExpression)new Constant(nativeValue, type));
    }

    @Test
    public void testTranslateSymbol() {
        this.assertTranslationRoundTrips((Expression)new SymbolReference("double_symbol_1"), (ConnectorExpression)new Variable("double_symbol_1", (Type)DoubleType.DOUBLE));
    }

    @Test
    public void testTranslateRowSubscript() {
        this.assertTranslationRoundTrips((Expression)new SubscriptExpression((Expression)new SymbolReference("row_symbol_1"), (Expression)new LongLiteral("1")), (ConnectorExpression)new FieldDereference((Type)IntegerType.INTEGER, (ConnectorExpression)new Variable("row_symbol_1", ROW_TYPE), 0));
    }

    @Test
    public void testTranslateLogicalExpression() {
        for (LogicalExpression.Operator operator : LogicalExpression.Operator.values()) {
            this.assertTranslationRoundTrips((Expression)new LogicalExpression(operator, List.of(new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("double_symbol_1"), (Expression)new SymbolReference("double_symbol_2")), new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("double_symbol_1"), (Expression)new SymbolReference("double_symbol_2")))), (ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, operator == LogicalExpression.Operator.AND ? StandardFunctions.AND_FUNCTION_NAME : StandardFunctions.OR_FUNCTION_NAME, List.of(new Call((Type)BooleanType.BOOLEAN, StandardFunctions.LESS_THAN_OPERATOR_FUNCTION_NAME, List.of(new Variable("double_symbol_1", (Type)DoubleType.DOUBLE), new Variable("double_symbol_2", (Type)DoubleType.DOUBLE))), new Call((Type)BooleanType.BOOLEAN, StandardFunctions.EQUAL_OPERATOR_FUNCTION_NAME, List.of(new Variable("double_symbol_1", (Type)DoubleType.DOUBLE), new Variable("double_symbol_2", (Type)DoubleType.DOUBLE))))));
        }
    }

    @Test
    public void testTranslateComparisonExpression() {
        for (ComparisonExpression.Operator operator : ComparisonExpression.Operator.values()) {
            this.assertTranslationRoundTrips((Expression)new ComparisonExpression(operator, (Expression)new SymbolReference("double_symbol_1"), (Expression)new SymbolReference("double_symbol_2")), (ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, ConnectorExpressionTranslator.functionNameForComparisonOperator((ComparisonExpression.Operator)operator), List.of(new Variable("double_symbol_1", (Type)DoubleType.DOUBLE), new Variable("double_symbol_2", (Type)DoubleType.DOUBLE))));
        }
    }

    @Test
    public void testTranslateArithmeticBinary() {
        for (ArithmeticBinaryExpression.Operator operator : ArithmeticBinaryExpression.Operator.values()) {
            this.assertTranslationRoundTrips((Expression)new ArithmeticBinaryExpression(operator, (Expression)new SymbolReference("double_symbol_1"), (Expression)new SymbolReference("double_symbol_2")), (ConnectorExpression)new Call((Type)DoubleType.DOUBLE, ConnectorExpressionTranslator.functionNameForArithmeticBinaryOperator((ArithmeticBinaryExpression.Operator)operator), List.of(new Variable("double_symbol_1", (Type)DoubleType.DOUBLE), new Variable("double_symbol_2", (Type)DoubleType.DOUBLE))));
        }
    }

    @Test
    public void testTranslateArithmeticUnaryMinus() {
        this.assertTranslationRoundTrips((Expression)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)new SymbolReference("double_symbol_1")), (ConnectorExpression)new Call((Type)DoubleType.DOUBLE, StandardFunctions.NEGATE_FUNCTION_NAME, List.of(new Variable("double_symbol_1", (Type)DoubleType.DOUBLE))));
    }

    @Test
    public void testTranslateArithmeticUnaryPlus() {
        this.assertTranslationToConnectorExpression(TEST_SESSION, (Expression)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.PLUS, (Expression)new SymbolReference("double_symbol_1")), (ConnectorExpression)new Variable("double_symbol_1", (Type)DoubleType.DOUBLE));
    }

    @Test
    public void testTranslateBetween() {
        this.assertTranslationToConnectorExpression(TEST_SESSION, (Expression)new BetweenPredicate((Expression)new SymbolReference("double_symbol_1"), (Expression)new DoubleLiteral("1.2"), (Expression)new SymbolReference("double_symbol_2")), (ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.AND_FUNCTION_NAME, List.of(new Call((Type)BooleanType.BOOLEAN, StandardFunctions.GREATER_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, List.of(new Variable("double_symbol_1", (Type)DoubleType.DOUBLE), new Constant((Object)1.2, (Type)DoubleType.DOUBLE))), new Call((Type)BooleanType.BOOLEAN, StandardFunctions.LESS_THAN_OR_EQUAL_OPERATOR_FUNCTION_NAME, List.of(new Variable("double_symbol_1", (Type)DoubleType.DOUBLE), new Variable("double_symbol_2", (Type)DoubleType.DOUBLE))))));
    }

    @Test
    public void testTranslateIsNull() {
        this.assertTranslationRoundTrips((Expression)new IsNullPredicate((Expression)new SymbolReference("varchar_symbol_1")), (ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.IS_NULL_FUNCTION_NAME, List.of(new Variable("varchar_symbol_1", (Type)VARCHAR_TYPE))));
    }

    @Test
    public void testTranslateNotExpression() {
        this.assertTranslationRoundTrips((Expression)new NotExpression((Expression)new SymbolReference("boolean_symbol_1")), (ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.NOT_FUNCTION_NAME, List.of(new Variable("boolean_symbol_1", (Type)BooleanType.BOOLEAN))));
    }

    @Test
    public void testTranslateIsNotNull() {
        this.assertTranslationRoundTrips((Expression)new IsNotNullPredicate((Expression)new SymbolReference("varchar_symbol_1")), (ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.NOT_FUNCTION_NAME, List.of(new Call((Type)BooleanType.BOOLEAN, StandardFunctions.IS_NULL_FUNCTION_NAME, List.of(new Variable("varchar_symbol_1", (Type)VARCHAR_TYPE))))));
    }

    @Test
    public void testTranslateCast() {
        this.assertTranslationRoundTrips((Expression)new Cast((Expression)new SymbolReference("varchar_symbol_1"), TypeSignatureTranslator.toSqlType((Type)VARCHAR_TYPE)), (ConnectorExpression)new Call((Type)VARCHAR_TYPE, StandardFunctions.CAST_FUNCTION_NAME, List.of(new Variable("varchar_symbol_1", (Type)VARCHAR_TYPE))));
        VarcharType longerVarchar = VarcharType.createVarcharType((int)(VARCHAR_TYPE.getBoundedLength() + 1));
        this.assertTranslationToConnectorExpression(TEST_SESSION, (Expression)new Cast((Expression)new SymbolReference("varchar_symbol_1"), TypeSignatureTranslator.toSqlType((Type)longerVarchar), false, true), (ConnectorExpression)new Call((Type)longerVarchar, StandardFunctions.CAST_FUNCTION_NAME, List.of(new Variable("varchar_symbol_1", (Type)VARCHAR_TYPE))));
        this.assertTranslationToConnectorExpression(TEST_SESSION, (Expression)new Cast((Expression)new SymbolReference("varchar_symbol_1"), TypeSignatureTranslator.toSqlType((Type)BigintType.BIGINT), true, true), Optional.empty());
    }

    @Test
    public void testTranslateLike() {
        TestingTransactionManager transactionManager = new TestingTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager((TransactionManager)transactionManager).build();
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)new AllowAllAccessControl()).readOnly().execute(TEST_SESSION, transactionSession -> {
            String pattern = "%pattern%";
            Call translated = new Call((Type)BooleanType.BOOLEAN, StandardFunctions.LIKE_FUNCTION_NAME, List.of(new Variable("varchar_symbol_1", (Type)VARCHAR_TYPE), new Constant((Object)Slices.wrappedBuffer((byte[])pattern.getBytes(StandardCharsets.UTF_8)), (Type)VarcharType.createVarcharType((int)pattern.length()))));
            this.assertTranslationToConnectorExpression((Session)transactionSession, (Expression)BuiltinFunctionCallBuilder.resolve((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata()).setName("$like").addArgument((Type)VARCHAR_TYPE, (Expression)new SymbolReference("varchar_symbol_1")).addArgument((Type)LikePatternType.LIKE_PATTERN, LITERAL_ENCODER.toExpression((Object)LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)pattern)), (Type)LikePatternType.LIKE_PATTERN)).build(), (Optional<ConnectorExpression>)Optional.of(translated));
            this.assertTranslationFromConnectorExpression((Session)transactionSession, (ConnectorExpression)translated, (Expression)BuiltinFunctionCallBuilder.resolve((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata()).setName("$like").addArgument((Type)VARCHAR_TYPE, (Expression)new SymbolReference("varchar_symbol_1")).addArgument((Type)LikePatternType.LIKE_PATTERN, (Expression)BuiltinFunctionCallBuilder.resolve((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata()).setName("$like_pattern").addArgument((Type)VarcharType.createVarcharType((int)pattern.length()), (Expression)new StringLiteral(pattern)).build()).build());
            String escape = "\\";
            translated = new Call((Type)BooleanType.BOOLEAN, StandardFunctions.LIKE_FUNCTION_NAME, List.of(new Variable("varchar_symbol_1", (Type)VARCHAR_TYPE), new Constant((Object)Slices.wrappedBuffer((byte[])pattern.getBytes(StandardCharsets.UTF_8)), (Type)VarcharType.createVarcharType((int)pattern.length())), new Constant((Object)Slices.wrappedBuffer((byte[])escape.getBytes(StandardCharsets.UTF_8)), (Type)VarcharType.createVarcharType((int)escape.length()))));
            this.assertTranslationToConnectorExpression((Session)transactionSession, (Expression)BuiltinFunctionCallBuilder.resolve((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata()).setName("$like").addArgument((Type)VARCHAR_TYPE, (Expression)new SymbolReference("varchar_symbol_1")).addArgument((Type)LikePatternType.LIKE_PATTERN, LITERAL_ENCODER.toExpression((Object)LikeFunctions.likePattern((Slice)Slices.utf8Slice((String)pattern), (Slice)Slices.utf8Slice((String)escape)), (Type)LikePatternType.LIKE_PATTERN)).build(), (Optional<ConnectorExpression>)Optional.of(translated));
            this.assertTranslationFromConnectorExpression((Session)transactionSession, (ConnectorExpression)translated, (Expression)BuiltinFunctionCallBuilder.resolve((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata()).setName("$like").addArgument((Type)VARCHAR_TYPE, (Expression)new SymbolReference("varchar_symbol_1")).addArgument((Type)LikePatternType.LIKE_PATTERN, (Expression)BuiltinFunctionCallBuilder.resolve((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata()).setName("$like_pattern").addArgument((Type)VarcharType.createVarcharType((int)pattern.length()), (Expression)new StringLiteral(pattern)).addArgument((Type)VarcharType.createVarcharType((int)1), (Expression)new StringLiteral(escape)).build()).build());
        });
    }

    @Test
    public void testTranslateNullIf() {
        this.assertTranslationRoundTrips((Expression)new NullIfExpression((Expression)new SymbolReference("varchar_symbol_1"), (Expression)new SymbolReference("varchar_symbol_1")), (ConnectorExpression)new Call((Type)VARCHAR_TYPE, StandardFunctions.NULLIF_FUNCTION_NAME, List.of(new Variable("varchar_symbol_1", (Type)VARCHAR_TYPE), new Variable("varchar_symbol_1", (Type)VARCHAR_TYPE))));
    }

    @Test
    public void testTranslateResolvedFunction() {
        TestingTransactionManager transactionManager = new TestingTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager((TransactionManager)transactionManager).build();
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)new AllowAllAccessControl()).readOnly().execute(TEST_SESSION, transactionSession -> this.assertTranslationRoundTrips((Session)transactionSession, (Expression)BuiltinFunctionCallBuilder.resolve((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata()).setName("lower").addArgument((Type)VARCHAR_TYPE, (Expression)new SymbolReference("varchar_symbol_1")).build(), (ConnectorExpression)new Call((Type)VARCHAR_TYPE, new FunctionName("lower"), List.of(new Variable("varchar_symbol_1", (Type)VARCHAR_TYPE)))));
    }

    @Test
    public void testTranslateRegularExpression() {
        TestingTransactionManager transactionManager = new TestingTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager((TransactionManager)transactionManager).build();
        TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)new AllowAllAccessControl()).readOnly().execute(TEST_SESSION, transactionSession -> {
            FunctionCall input = BuiltinFunctionCallBuilder.resolve((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata()).setName("regexp_like").addArgument((Type)VARCHAR_TYPE, (Expression)new SymbolReference("varchar_symbol_1")).addArgument((Type)JoniRegexpType.JONI_REGEXP, LITERAL_ENCODER.toExpression((Object)JoniRegexpCasts.joniRegexp((Slice)Slices.utf8Slice((String)"a+")), (Type)JoniRegexpType.JONI_REGEXP)).build();
            Call translated = new Call((Type)BooleanType.BOOLEAN, new FunctionName("regexp_like"), List.of(new Variable("varchar_symbol_1", (Type)VARCHAR_TYPE), new Constant((Object)Slices.utf8Slice((String)"a+"), (Type)VarcharType.createVarcharType((int)2))));
            FunctionCall translatedBack = BuiltinFunctionCallBuilder.resolve((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata()).setName("regexp_like").addArgument((Type)VARCHAR_TYPE, (Expression)new SymbolReference("varchar_symbol_1")).addArgument((Type)JoniRegexpType.JONI_REGEXP, (Expression)new Cast((Expression)new StringLiteral("a+"), TypeSignatureTranslator.toSqlType((Type)JoniRegexpType.JONI_REGEXP))).build();
            this.assertTranslationToConnectorExpression((Session)transactionSession, (Expression)input, (ConnectorExpression)translated);
            this.assertTranslationFromConnectorExpression((Session)transactionSession, (ConnectorExpression)translated, (Expression)translatedBack);
        });
    }

    @Test
    public void testTranslateIn() {
        String value = "value_1";
        this.assertTranslationRoundTrips((Expression)new InPredicate((Expression)new SymbolReference("varchar_symbol_1"), (Expression)new InListExpression(List.of(new SymbolReference("varchar_symbol_1"), new StringLiteral(value)))), (ConnectorExpression)new Call((Type)BooleanType.BOOLEAN, StandardFunctions.IN_PREDICATE_FUNCTION_NAME, List.of(new Variable("varchar_symbol_1", (Type)VARCHAR_TYPE), new Call((Type)VARCHAR_ARRAY_TYPE, StandardFunctions.ARRAY_CONSTRUCTOR_FUNCTION_NAME, List.of(new Variable("varchar_symbol_1", (Type)VARCHAR_TYPE), new Constant((Object)Slices.wrappedBuffer((byte[])value.getBytes(StandardCharsets.UTF_8)), (Type)VarcharType.createVarcharType((int)value.length())))))));
        this.assertTranslationToConnectorExpression(TEST_SESSION, (Expression)new InPredicate((Expression)new SymbolReference("varchar_symbol_1"), (Expression)new InListExpression(List.of(new SymbolReference("varchar_symbol_1"), new NullLiteral()))), Optional.empty());
    }

    private void assertTranslationRoundTrips(Expression expression, ConnectorExpression connectorExpression) {
        this.assertTranslationRoundTrips(TEST_SESSION, expression, connectorExpression);
    }

    private void assertTranslationRoundTrips(Session session, Expression expression, ConnectorExpression connectorExpression) {
        this.assertTranslationToConnectorExpression(session, expression, Optional.of(connectorExpression));
        this.assertTranslationFromConnectorExpression(session, connectorExpression, expression);
    }

    private void assertTranslationToConnectorExpression(Session session, Expression expression, ConnectorExpression connectorExpression) {
        this.assertTranslationToConnectorExpression(session, expression, Optional.of(connectorExpression));
    }

    private void assertTranslationToConnectorExpression(Session session, Expression expression, Optional<ConnectorExpression> connectorExpression) {
        Optional translation = ConnectorExpressionTranslator.translate((Session)session, (Expression)expression, (TypeProvider)TYPE_PROVIDER, (PlannerContext)TestingPlannerContext.PLANNER_CONTEXT, (TypeAnalyzer)TYPE_ANALYZER);
        Assertions.assertThat((boolean)connectorExpression.isPresent()).isEqualTo(translation.isPresent());
        translation.ifPresent(value -> Assertions.assertThat((Object)value).isEqualTo(connectorExpression.get()));
    }

    private void assertTranslationFromConnectorExpression(Session session, ConnectorExpression connectorExpression, Expression expected) {
        Expression translation = ConnectorExpressionTranslator.translate((Session)session, (ConnectorExpression)connectorExpression, (PlannerContext)TestingPlannerContext.PLANNER_CONTEXT, variableMappings, (LiteralEncoder)LITERAL_ENCODER);
        Assertions.assertThat((Object)translation).isEqualTo((Object)expected);
    }
}

