/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.StatsProvider;
import io.trino.spi.connector.ColumnHandle;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.iterative.rule.UseNonPartitionedJoinLookupSource;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.testing.TestingMetadata;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestGetSourceTablesRowCount {
    @Test
    public void testMissingSourceStats() {
        PlanBuilder planBuilder = this.planBuilder();
        Symbol symbol = planBuilder.symbol("col");
        Assertions.assertThat((double)this.getSourceTablesRowCount((PlanNode)planBuilder.tableScan(tableScan -> tableScan.setSymbols((List<Symbol>)ImmutableList.of((Object)symbol)).setAssignments((Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)symbol, (Object)new TestingMetadata.TestingColumnHandle("col"))).setStatistics(Optional.of(PlanNodeStatsEstimate.unknown()))))).isNaN();
    }

    @Test
    public void testTwoSourcePlanNodes() {
        PlanBuilder planBuilder = this.planBuilder();
        Symbol symbol = planBuilder.symbol("col");
        Symbol sourceSymbol1 = planBuilder.symbol("source1");
        Symbol sourceSymbol2 = planBuilder.symbol("soruce2");
        Assertions.assertThat((double)this.getSourceTablesRowCount((PlanNode)planBuilder.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)symbol, (Object)sourceSymbol1).put((Object)symbol, (Object)sourceSymbol2).build(), (List<PlanNode>)ImmutableList.of((Object)planBuilder.tableScan(tableScan -> tableScan.setSymbols((List<Symbol>)ImmutableList.of((Object)sourceSymbol1)).setAssignments((Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)sourceSymbol1, (Object)new TestingMetadata.TestingColumnHandle("col"))).setStatistics(Optional.of(TestGetSourceTablesRowCount.stats(10)))), (Object)planBuilder.values(new PlanNodeId("valuesNode"), 20, sourceSymbol2))))).isEqualTo(30.0);
    }

    @Test
    public void testJoinNode() {
        PlanBuilder planBuilder = this.planBuilder();
        Symbol sourceSymbol1 = planBuilder.symbol("source1");
        Symbol sourceSymbol2 = planBuilder.symbol("soruce2");
        Assertions.assertThat((double)this.getSourceTablesRowCount((PlanNode)planBuilder.join(JoinNode.Type.INNER, (PlanNode)planBuilder.values(sourceSymbol1), (PlanNode)planBuilder.values(sourceSymbol2), new JoinNode.EquiJoinClause[0]))).isNaN();
    }

    private double getSourceTablesRowCount(PlanNode planNode) {
        return UseNonPartitionedJoinLookupSource.getSourceTablesRowCount((PlanNode)planNode, (Lookup)Lookup.noLookup(), (StatsProvider)TestGetSourceTablesRowCount.testStatsProvider());
    }

    private PlanBuilder planBuilder() {
        return new PlanBuilder(new PlanNodeIdAllocator(), TestingPlannerContext.PLANNER_CONTEXT, TestingSession.testSessionBuilder().build());
    }

    private static StatsProvider testStatsProvider() {
        return node -> {
            if (node instanceof TableScanNode) {
                return ((TableScanNode)node).getStatistics().orElse(PlanNodeStatsEstimate.unknown());
            }
            if (node instanceof ValuesNode) {
                return TestGetSourceTablesRowCount.stats(((ValuesNode)node).getRowCount());
            }
            return PlanNodeStatsEstimate.unknown();
        };
    }

    private static PlanNodeStatsEstimate stats(int rowCount) {
        return PlanNodeStatsEstimate.builder().setOutputRowCount((double)rowCount).build();
    }
}

