/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import io.trino.spi.Plugin;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.OptimizeDuplicateInsensitiveJoins;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.junit.jupiter.api.Test;

public class TestOptimizeDuplicateInsensitiveJoins
extends BaseRuleTest {
    public TestOptimizeDuplicateInsensitiveJoins() {
        super(new Plugin[0]);
    }

    @Test
    public void testNoAggregation() {
        this.tester().assertThat((Rule<?>)new OptimizeDuplicateInsensitiveJoins(this.tester().getMetadata())).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.symbol("a")), (PlanNode)p.values(p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testAggregation() {
        this.tester().assertThat((Rule<?>)new OptimizeDuplicateInsensitiveJoins(this.tester().getMetadata())).on(p -> {
            Symbol symbolA = p.symbol("a");
            Symbol symbolB = p.symbol("b");
            Symbol output = p.symbol("out");
            return p.aggregation(a -> a.singleGroupingSet(symbolA).addAggregation(output, PlanBuilder.expression("count()"), (List<Type>)ImmutableList.of()).source((PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(symbolA), (PlanNode)p.values(symbolB), new JoinNode.EquiJoinClause[0])));
        }).doesNotFire();
    }

    @Test
    public void testEmptyAggregation() {
        this.tester().assertThat((Rule<?>)new OptimizeDuplicateInsensitiveJoins(this.tester().getMetadata())).on(p -> {
            Symbol symbolA = p.symbol("a");
            Symbol symbolB = p.symbol("b");
            return p.aggregation(a -> a.singleGroupingSet(symbolA).source((PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(symbolA), (PlanNode)p.values(symbolB), new JoinNode.EquiJoinClause[0])));
        }).matches(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.left(PlanMatchPattern.values("A")).right(PlanMatchPattern.values("B"))).with(JoinNode.class, JoinNode::isMaySkipOutputDuplicates)));
    }

    @Test
    public void testNestedJoins() {
        this.tester().assertThat((Rule<?>)new OptimizeDuplicateInsensitiveJoins(this.tester().getMetadata())).on(p -> {
            Symbol symbolA = p.symbol("a");
            Symbol symbolB = p.symbol("b");
            Symbol symbolC = p.symbol("c");
            return p.aggregation(a -> a.singleGroupingSet(symbolA).source((PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(symbolA), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{symbolB}), (PlanNode)p.filter(PlanBuilder.expression("b > 10"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(symbolB), (PlanNode)p.values(symbolC), new JoinNode.EquiJoinClause[0]))), new JoinNode.EquiJoinClause[0])));
        }).matches(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.left(PlanMatchPattern.values("A")).right(PlanMatchPattern.project(PlanMatchPattern.filter("B > 10", PlanMatchPattern.join(JoinNode.Type.INNER, rightJoinBuilder -> rightJoinBuilder.left(PlanMatchPattern.values("B")).right(PlanMatchPattern.values("C"))).with(JoinNode.class, JoinNode::isMaySkipOutputDuplicates))))).with(JoinNode.class, JoinNode::isMaySkipOutputDuplicates)));
    }

    @Test
    public void testNondeterministicJoins() {
        FunctionCall randomFunction = new FunctionCall(this.tester().getMetadata().resolveBuiltinFunction("random", (List)ImmutableList.of()).toQualifiedName(), (List)ImmutableList.of());
        this.tester().assertThat((Rule<?>)new OptimizeDuplicateInsensitiveJoins(this.tester().getMetadata())).on(p -> {
            Symbol symbolA = p.symbol("a");
            Symbol symbolB = p.symbol("b");
            Symbol symbolC = p.symbol("c");
            return p.aggregation(a -> a.singleGroupingSet(symbolA).source((PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(symbolA), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(symbolB), (PlanNode)p.values(symbolC), new JoinNode.EquiJoinClause[0]), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)symbolB.toSymbolReference(), (Expression)randomFunction), new JoinNode.EquiJoinClause[0])));
        }).matches(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.filter("B > random()").left(PlanMatchPattern.values("A")).right(PlanMatchPattern.join(JoinNode.Type.INNER, rightJoinBuilder -> rightJoinBuilder.left(PlanMatchPattern.values("B")).right(PlanMatchPattern.values("C"))).with(JoinNode.class, Predicate.not(JoinNode::isMaySkipOutputDuplicates)))).with(JoinNode.class, JoinNode::isMaySkipOutputDuplicates)));
    }

    @Test
    public void testNondeterministicFilter() {
        FunctionCall randomFunction = new FunctionCall(this.tester().getMetadata().resolveBuiltinFunction("random", (List)ImmutableList.of()).toQualifiedName(), (List)ImmutableList.of());
        this.tester().assertThat((Rule<?>)new OptimizeDuplicateInsensitiveJoins(this.tester().getMetadata())).on(p -> {
            Symbol symbolA = p.symbol("a");
            Symbol symbolB = p.symbol("b");
            return p.aggregation(a -> a.singleGroupingSet(symbolA).source((PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)symbolB.toSymbolReference(), (Expression)randomFunction), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(symbolA), (PlanNode)p.values(symbolB), new JoinNode.EquiJoinClause[0]))));
        }).doesNotFire();
    }

    @Test
    public void testNondeterministicProjection() {
        FunctionCall randomFunction = new FunctionCall(this.tester().getMetadata().resolveBuiltinFunction("random", (List)ImmutableList.of()).toQualifiedName(), (List)ImmutableList.of());
        this.tester().assertThat((Rule<?>)new OptimizeDuplicateInsensitiveJoins(this.tester().getMetadata())).on(p -> {
            Symbol symbolA = p.symbol("a");
            Symbol symbolB = p.symbol("b");
            Symbol symbolC = p.symbol("c");
            return p.aggregation(a -> a.singleGroupingSet(symbolA).source((PlanNode)p.project(Assignments.builder().putIdentity(symbolA).put(symbolC, (Expression)randomFunction).build(), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(symbolA), (PlanNode)p.values(symbolB), new JoinNode.EquiJoinClause[0]))));
        }).doesNotFire();
    }

    @Test
    public void testUnion() {
        this.tester().assertThat((Rule<?>)new OptimizeDuplicateInsensitiveJoins(this.tester().getMetadata())).on(p -> {
            Symbol symbolA = p.symbol("a");
            Symbol symbolB = p.symbol("b");
            Symbol symbolC = p.symbol("c");
            Symbol symbolD = p.symbol("d");
            Symbol symbolE = p.symbol("e");
            return p.aggregation(a -> a.singleGroupingSet(symbolE).source((PlanNode)p.union((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)symbolE, (Object)symbolA).put((Object)symbolE, (Object)symbolC).build(), (List<PlanNode>)ImmutableList.of((Object)p.join(JoinNode.Type.INNER, (PlanNode)p.values(symbolA), (PlanNode)p.values(symbolB), new JoinNode.EquiJoinClause[0]), (Object)p.join(JoinNode.Type.INNER, (PlanNode)p.values(symbolC), (PlanNode)p.values(symbolD), new JoinNode.EquiJoinClause[0])))));
        }).matches(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.union(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.left(PlanMatchPattern.values("A")).right(PlanMatchPattern.values("B"))).with(JoinNode.class, JoinNode::isMaySkipOutputDuplicates), PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.left(PlanMatchPattern.values("C")).right(PlanMatchPattern.values("D"))).with(JoinNode.class, JoinNode::isMaySkipOutputDuplicates))));
    }
}

