/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.planprinter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.cost.StatsAndCosts;
import io.trino.execution.TableInfo;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.plugin.tpch.TpchTableHandle;
import io.trino.plugin.tpch.TpchTransactionHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.TestingColumnHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.planprinter.Anonymizer;
import io.trino.sql.planner.planprinter.CounterBasedAnonymizer;
import io.trino.sql.planner.planprinter.JsonRenderer;
import io.trino.sql.planner.planprinter.NodeRepresentation;
import io.trino.sql.planner.planprinter.PlanPrinter;
import io.trino.sql.planner.planprinter.ValuePrinter;
import io.trino.testing.LocalQueryRunner;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestAnonymizeJsonRepresentation {
    private static final JsonCodec<JsonRenderer.JsonRenderedNode> JSON_RENDERED_NODE_CODEC = JsonCodec.jsonCodec(JsonRenderer.JsonRenderedNode.class);
    private static final ColumnHandle TEST_COLUMN_HANDLE_A = new TestingColumnHandle("test_column_a");
    private static final ColumnHandle TEST_COLUMN_HANDLE_B = new TestingColumnHandle("test_column_b");
    private static final ColumnHandle TEST_COLUMN_HANDLE_C = new TestingColumnHandle("test_column_c");
    private static final ColumnHandle TEST_COLUMN_HANDLE_D = new TestingColumnHandle("test_column_d");
    private static final TupleDomain<ColumnHandle> TEST_TUPLE_DOMAIN = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)TEST_COLUMN_HANDLE_A, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)TEST_COLUMN_HANDLE_B, (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)), (Object)TEST_COLUMN_HANDLE_C, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)true), (Range[])new Range[0]), (boolean)false), (Object)TEST_COLUMN_HANDLE_D, (Object)Domain.all((Type)BigintType.BIGINT)));
    private static final TableInfo TABLE_INFO = new TableInfo(Optional.of("tpch"), new QualifiedObjectName("tpch", "tiny", "orders"), TEST_TUPLE_DOMAIN);
    private LocalQueryRunner queryRunner;

    @BeforeAll
    public void setUp() {
        this.queryRunner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);
        this.queryRunner.createCatalog((String)SessionTestUtils.TEST_SESSION.getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
    }

    @AfterAll
    public void tearDown() {
        this.queryRunner.close();
        this.queryRunner = null;
    }

    @Test
    public void testAggregationPlan() {
        this.assertAnonymizedRepresentation(pb -> pb.aggregation(ab -> ab.step(AggregationNode.Step.FINAL).addAggregation(pb.symbol("sum", (Type)BigintType.BIGINT), PlanBuilder.expression("sum(x)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).singleGroupingSet(pb.symbol("y", (Type)BigintType.BIGINT), pb.symbol("z", (Type)BigintType.BIGINT)).source((PlanNode)pb.values(pb.symbol("x", (Type)BigintType.BIGINT), pb.symbol("y", (Type)BigintType.BIGINT), pb.symbol("z", (Type)BigintType.BIGINT)))), new JsonRenderer.JsonRenderedNode("1", "Aggregate", (Map)ImmutableMap.of((Object)"type", (Object)"FINAL", (Object)"keys", (Object)"[symbol_1, symbol_2]", (Object)"hash", (Object)"[]"), (List)ImmutableList.of((Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"symbol_1", (Type)BigintType.BIGINT), (Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"symbol_2", (Type)BigintType.BIGINT), (Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"symbol_3", (Type)BigintType.BIGINT)), (List)ImmutableList.of((Object)"symbol_3 := sum(\"symbol_4\")"), (List)ImmutableList.of(), (List)ImmutableList.of((Object)TestAnonymizeJsonRepresentation.valuesRepresentation("0", (List<NodeRepresentation.TypedSymbol>)ImmutableList.of((Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"symbol_4", (Type)BigintType.BIGINT), (Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"symbol_1", (Type)BigintType.BIGINT), (Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"symbol_2", (Type)BigintType.BIGINT))))));
    }

    @Test
    public void testJoinPlan() {
        this.assertAnonymizedRepresentation(pb -> pb.join(JoinNode.Type.INNER, (PlanNode)pb.values(pb.symbol("a", (Type)BigintType.BIGINT), pb.symbol("b", (Type)BigintType.BIGINT)), (PlanNode)pb.values(pb.symbol("c", (Type)BigintType.BIGINT), pb.symbol("d", (Type)BigintType.BIGINT)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(pb.symbol("a", (Type)BigintType.BIGINT), pb.symbol("d", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)pb.symbol("b", (Type)BigintType.BIGINT)), (List<Symbol>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of((Object)new DynamicFilterId("DF"), (Object)pb.symbol("d", (Type)BigintType.BIGINT))), new JsonRenderer.JsonRenderedNode("2", "InnerJoin", (Map)ImmutableMap.of((Object)"criteria", (Object)"(\"symbol_1\" = \"symbol_2\")", (Object)"hash", (Object)"[]"), (List)ImmutableList.of((Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"symbol_3", (Type)BigintType.BIGINT)), (List)ImmutableList.of((Object)"dynamicFilterAssignments = {symbol_2 -> #DF}"), (List)ImmutableList.of(), (List)ImmutableList.of((Object)TestAnonymizeJsonRepresentation.valuesRepresentation("0", (List<NodeRepresentation.TypedSymbol>)ImmutableList.of((Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"symbol_1", (Type)BigintType.BIGINT), (Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"symbol_3", (Type)BigintType.BIGINT))), (Object)TestAnonymizeJsonRepresentation.valuesRepresentation("1", (List<NodeRepresentation.TypedSymbol>)ImmutableList.of((Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"symbol_4", (Type)BigintType.BIGINT), (Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"symbol_2", (Type)BigintType.BIGINT))))));
    }

    @Test
    public void testTableScanPlan() {
        this.assertAnonymizedRepresentation(pb -> pb.tableScan(new TableHandle(this.queryRunner.getCatalogHandle("tpch"), (ConnectorTableHandle)new TpchTableHandle("tiny", "orders", 0.01), (ConnectorTransactionHandle)TpchTransactionHandle.INSTANCE), (List<Symbol>)ImmutableList.of((Object)pb.symbol("a", (Type)BigintType.BIGINT), (Object)pb.symbol("b", (Type)BigintType.BIGINT), (Object)pb.symbol("c", (Type)BigintType.BIGINT), (Object)pb.symbol("d", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)pb.symbol("a", (Type)BigintType.BIGINT), (Object)TEST_COLUMN_HANDLE_A, (Object)pb.symbol("b", (Type)BigintType.BIGINT), (Object)TEST_COLUMN_HANDLE_B, (Object)pb.symbol("c", (Type)BigintType.BIGINT), (Object)TEST_COLUMN_HANDLE_C, (Object)pb.symbol("d", (Type)BigintType.BIGINT), (Object)TEST_COLUMN_HANDLE_D), TEST_TUPLE_DOMAIN), new JsonRenderer.JsonRenderedNode("0", "TableScan", (Map)ImmutableMap.of((Object)"table", (Object)"[table = catalog_1.schema_1.table_1, connector = tpch]"), (List)ImmutableList.of((Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"symbol_1", (Type)BigintType.BIGINT), (Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"symbol_2", (Type)BigintType.BIGINT), (Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"symbol_3", (Type)BigintType.BIGINT), (Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"symbol_4", (Type)BigintType.BIGINT)), (List)ImmutableList.of((Object)"symbol_1 := column_1", (Object)"    :: [[bigint_value_1]]", (Object)"symbol_2 := column_2", (Object)"    :: [[bigint_value_1], [bigint_value_2], [bigint_value_3]]", (Object)"symbol_3 := column_3", (Object)"    :: [[bigint_value_1, bigint_value_3]]", (Object)"symbol_4 := column_4"), (List)ImmutableList.of(), (List)ImmutableList.of()));
    }

    @Test
    public void testSortPlan() {
        this.assertAnonymizedRepresentation(pb -> pb.sort((List<Symbol>)ImmutableList.of((Object)pb.symbol("a", (Type)BigintType.BIGINT)), (PlanNode)pb.values(pb.symbol("a", (Type)BigintType.BIGINT))), new JsonRenderer.JsonRenderedNode("1", "Sort", (Map)ImmutableMap.of((Object)"orderBy", (Object)"[symbol_1 ASC NULLS FIRST]"), (List)ImmutableList.of((Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"symbol_1", (Type)BigintType.BIGINT)), (List)ImmutableList.of(), (List)ImmutableList.of(), (List)ImmutableList.of((Object)TestAnonymizeJsonRepresentation.valuesRepresentation("0", (List<NodeRepresentation.TypedSymbol>)ImmutableList.of((Object)NodeRepresentation.TypedSymbol.typedSymbol((String)"symbol_1", (Type)BigintType.BIGINT))))));
    }

    private static JsonRenderer.JsonRenderedNode valuesRepresentation(String id, List<NodeRepresentation.TypedSymbol> outputs) {
        return new JsonRenderer.JsonRenderedNode(id, "Values", (Map)ImmutableMap.of(), outputs, (List)ImmutableList.of(), (List)ImmutableList.of(), (List)ImmutableList.of());
    }

    private void assertAnonymizedRepresentation(Function<PlanBuilder, PlanNode> sourceNodeSupplier, JsonRenderer.JsonRenderedNode expectedRepresentation) {
        this.queryRunner.inTransaction(session -> {
            PlanBuilder planBuilder = new PlanBuilder(new PlanNodeIdAllocator(), this.queryRunner.getPlannerContext(), (Session)session);
            ValuePrinter valuePrinter = new ValuePrinter(this.queryRunner.getMetadata(), this.queryRunner.getFunctionManager(), session);
            String jsonRenderedNode = new PlanPrinter((PlanNode)sourceNodeSupplier.apply(planBuilder), planBuilder.getTypes(), scanNode -> TABLE_INFO, (Map)ImmutableMap.of(), valuePrinter, StatsAndCosts.empty(), Optional.empty(), (Anonymizer)new CounterBasedAnonymizer()).toJson();
            Assertions.assertThat((String)jsonRenderedNode).isEqualTo(JSON_RENDERED_NODE_CODEC.toJson((Object)expectedRepresentation));
            return null;
        });
    }
}

