/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.sanity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.SessionTestUtils;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.TableHandle;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.plugin.tpch.TpchTableHandle;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.sanity.ValidateAggregationsWithDefaultValues;
import io.trino.testing.TestingTransactionHandle;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestValidateAggregationsWithDefaultValues
extends BasePlanTest {
    private PlannerContext plannerContext;
    private PlanBuilder builder;
    private Symbol symbol;
    private TableScanNode tableScanNode;

    @BeforeAll
    public void setup() {
        this.plannerContext = this.getQueryRunner().getPlannerContext();
        this.builder = new PlanBuilder(new PlanNodeIdAllocator(), this.plannerContext, SessionTestUtils.TEST_SESSION);
        CatalogHandle catalogHandle = this.getCurrentCatalogHandle();
        TableHandle nationTableHandle = new TableHandle(catalogHandle, (ConnectorTableHandle)new TpchTableHandle("sf1", "nation", 1.0), (ConnectorTransactionHandle)TestingTransactionHandle.create());
        TpchColumnHandle nationkeyColumnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.symbol = new Symbol("nationkey");
        this.tableScanNode = this.builder.tableScan(nationTableHandle, (List<Symbol>)ImmutableList.of((Object)this.symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)this.symbol, (Object)nationkeyColumnHandle));
    }

    @Test
    public void testGloballyDistributedFinalAggregationInTheSameStageAsPartialAggregation() {
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.tableScanNode))));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testGloballyDistributedFinalAggregationInTheSameStageAsPartialAggregation$2((PlanNode)root)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Final aggregation with default value not separated from partial aggregation by remote hash exchange");
    }

    @Test
    public void testSingleNodeFinalAggregationInTheSameStageAsPartialAggregation() {
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.tableScanNode))));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testSingleNodeFinalAggregationInTheSameStageAsPartialAggregation$5((PlanNode)root)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Final aggregation with default value not separated from partial aggregation by local hash exchange");
    }

    @Test
    public void testSingleThreadFinalAggregationInTheSameStageAsPartialAggregation() {
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)this.symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.values(new Symbol[0])))));
        this.validatePlan((PlanNode)root, true);
    }

    @Test
    public void testGloballyDistributedFinalAggregationSeparatedFromPartialAggregationByRemoteHashExchange() {
        Symbol symbol = new Symbol("symbol");
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.exchange(e -> e.type(ExchangeNode.Type.REPARTITION).scope(ExchangeNode.Scope.REMOTE).fixedHashDistributionPartitioningScheme((List<Symbol>)ImmutableList.of((Object)symbol), (List<Symbol>)ImmutableList.of((Object)symbol)).addInputsSet(symbol).addSource((PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.tableScanNode))))));
        this.validatePlan((PlanNode)root, false);
    }

    @Test
    public void testSingleNodeFinalAggregationSeparatedFromPartialAggregationByLocalHashExchange() {
        Symbol symbol = new Symbol("symbol");
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.exchange(e -> e.type(ExchangeNode.Type.REPARTITION).scope(ExchangeNode.Scope.LOCAL).fixedHashDistributionPartitioningScheme((List<Symbol>)ImmutableList.of((Object)symbol), (List<Symbol>)ImmutableList.of((Object)symbol)).addInputsSet(symbol).addSource((PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.tableScanNode))))));
        this.validatePlan((PlanNode)root, true);
    }

    @Test
    public void testWithPartialAggregationBelowJoin() {
        Symbol symbol = new Symbol("symbol");
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.join(JoinNode.Type.INNER, (PlanNode)this.builder.exchange(e -> e.type(ExchangeNode.Type.REPARTITION).scope(ExchangeNode.Scope.LOCAL).fixedHashDistributionPartitioningScheme((List<Symbol>)ImmutableList.of((Object)symbol), (List<Symbol>)ImmutableList.of((Object)symbol)).addInputsSet(symbol).addSource((PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.tableScanNode)))), (PlanNode)this.builder.values(new Symbol[0]), new JoinNode.EquiJoinClause[0])));
        this.validatePlan((PlanNode)root, true);
    }

    @Test
    public void testWithPartialAggregationBelowJoinWithoutSeparatingExchange() {
        Symbol symbol = new Symbol("symbol");
        AggregationNode root = this.builder.aggregation(af -> af.step(AggregationNode.Step.FINAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.builder.join(JoinNode.Type.INNER, (PlanNode)this.builder.aggregation(ap -> ap.step(AggregationNode.Step.PARTIAL).groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)this.tableScanNode)), (PlanNode)this.builder.values(new Symbol[0]), new JoinNode.EquiJoinClause[0])));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testWithPartialAggregationBelowJoinWithoutSeparatingExchange$19((PlanNode)root)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Final aggregation with default value not separated from partial aggregation by local hash exchange");
    }

    private void validatePlan(PlanNode root, boolean forceSingleNode) {
        this.getQueryRunner().inTransaction(session -> {
            session.getCatalog().ifPresent(catalog -> this.plannerContext.getMetadata().getCatalogHandle(session, catalog));
            new ValidateAggregationsWithDefaultValues(forceSingleNode).validate(root, session, this.plannerContext, TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)this.plannerContext), TypeProvider.empty(), WarningCollector.NOOP);
            return null;
        });
    }

    private /* synthetic */ void lambda$testWithPartialAggregationBelowJoinWithoutSeparatingExchange$19(PlanNode root) throws Throwable {
        this.validatePlan(root, true);
    }

    private /* synthetic */ void lambda$testSingleNodeFinalAggregationInTheSameStageAsPartialAggregation$5(PlanNode root) throws Throwable {
        this.validatePlan(root, true);
    }

    private /* synthetic */ void lambda$testGloballyDistributedFinalAggregationInTheSameStageAsPartialAggregation$2(PlanNode root) throws Throwable {
        this.validatePlan(root, false);
    }
}

