/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestArraySortAfterArrayDistinct {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testArrayDistinctAfterArraySort() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT ARRAY_DISTINCT(ARRAY_SORT(items)) as result from (VALUES (ARRAY ['elephant', 'dog', 'cat', 'dog'])) t(items)")))).matches("VALUES (ARRAY  ['cat', 'dog', 'elephant'])");
    }

    @Test
    public void testArrayDistinctAfterArraySortWithLambda() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT ARRAY_DISTINCT(ARRAY_SORT(items, (x, y) -> IF(x < y, 1, IF(x = y, 0, -1)))) as result from (VALUES (ARRAY ['elephant', 'dog', 'cat', 'dog'])) t(items)")))).matches("VALUES (ARRAY  ['elephant', 'dog', 'cat'])");
    }
}

