/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestDistinctWithOrderBy {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testOrderByReferenceWithMixedStyles() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT DISTINCT t.A FROM (VALUES 2, 1, 2) t(a) ORDER BY t.a")))).ordered().matches("VALUES 1, 2");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT DISTINCT a FROM (VALUES 2, 1, 2) t(a) ORDER BY A")))).ordered().matches("VALUES 1, 2");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT DISTINCT a FROM (VALUES 2, 1, 2) t(a) ORDER BY t.A")))).ordered().matches("VALUES 1, 2");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT DISTINCT t.a FROM (VALUES 2, 1, 2) t(a) ORDER BY A")))).ordered().matches("VALUES 1, 2");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT DISTINCT a + B FROM (VALUES (2, 2), (1, 1), (2, 2)) t(a, b) ORDER BY a + b")))).ordered().matches("VALUES 2, 4");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT DISTINCT a + B FROM (VALUES (2, 2), (1, 1), (2, 2)) t(a, b) ORDER BY a + t.b")))).ordered().matches("VALUES 2, 4");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT DISTINCT a + t.B FROM (VALUES (2, 2), (1, 1), (2, 2)) t(a, b) ORDER BY a + b")))).ordered().matches("VALUES 2, 4");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT DISTINCT a + t.B FROM (VALUES (2, 2), (1, 1), (2, 2)) t(a, b) ORDER BY a + t.b")))).ordered().matches("VALUES 2, 4");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT DISTINCT a, b a FROM (VALUES (2, 10), (1, 20), (2, 10)) T(a, b) ORDER BY T.a")))).ordered().matches("VALUES (1, 20), (2, 10)");
    }

    @Test
    public void testSelectAllAliases() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT DISTINCT t.r.* AS (a, b) FROM (VALUES ROW(CAST(ROW(1,1) AS ROW(a BIGINT, b BIGINT)))) t(r) ORDER BY a")))).matches("VALUES (BIGINT '1', BIGINT '1')");
    }

    @Test
    public void testColumnAliasing() {
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT DISTINCT 1 AS a, a + b FROM (VALUES (1, 2)) t(a, b) ORDER BY a + b")).hasMessage("line 1:1: For SELECT DISTINCT, ORDER BY expressions must appear in select list");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT DISTINCT -a AS a, a + b FROM (VALUES (1, 2)) t(a, b) ORDER BY a + b")).hasMessage("line 1:1: For SELECT DISTINCT, ORDER BY expressions must appear in select list");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT DISTINCT a, a + b FROM (VALUES (1, 2)) t(a, b) ORDER BY a + b")).hasMessage("line 1:1: For SELECT DISTINCT, ORDER BY expressions must appear in select list");
    }
}

