/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestLambdaExpressions {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testDuplicateLambdaExpressions() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT cardinality(filter(a, x -> x > 0)) FROM (VALUES    ARRAY[1,2,3],    ARRAY[0,1,2],   ARRAY[0,0,0]) AS t(a) GROUP BY cardinality(filter(a, x -> x > 0))ORDER BY cardinality(filter(a, x -> x > 0))")))).matches("VALUES BIGINT '0', BIGINT '2', BIGINT '3'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT transform(a, x -> x + 1), transform(b, x -> x + 1) FROM (VALUES ROW(ARRAY[1, 2, 3], ARRAY[10, 20, 30])) t(a, b)")))).matches("VALUES ROW(ARRAY[2, 3, 4], ARRAY[11, 21, 31])");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT transform(a, x -> x + 1), transform(b, x -> x + 1) FROM (VALUES ROW(ARRAY[1, 2, 3], ARRAY[10e0, 20e0, 30e0])) t(a, b)")))).matches("VALUES ROW(ARRAY[2, 3, 4], ARRAY[11e0, 21e0, 31e0])");
    }

    @Test
    public void testParameterName() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH t AS (     SELECT count(*) AS \"a.b c; d\" FROM (VALUES (42))     UNION ALL     SELECT * FROM (VALUES (77)) v(\"a.b c; d\") ) SELECT transform(ARRAY[1], x -> x + \"a.b c; d\") FROM t")))).matches("VALUES ARRAY[BIGINT '2'], ARRAY[BIGINT '78']");
    }

    @Test
    public void testNestedLambda() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT transform(a, x -> transform(ARRAY[x], x -> x + 1)) FROM (VALUES ARRAY[1, 2, 3]) t(a)")))).matches("VALUES ARRAY[ARRAY[2], ARRAY[3], ARRAY[4]]");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT transform(a, x -> transform(ARRAY[x], y -> y + 1)) FROM (VALUES ARRAY[1, 2, 3]) t(a)")))).matches("VALUES ARRAY[ARRAY[2], ARRAY[3], ARRAY[4]]");
    }
}

