/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestWindow {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    @Timeout(value=2L)
    public void testManyFunctionsWithSameWindow() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT\n          SUM(a) OVER w,\n          COUNT(a) OVER w,\n          MIN(a) OVER w,\n          MAX(a) OVER w,\n          SUM(b) OVER w,\n          COUNT(b) OVER w,\n          MIN(b) OVER w,\n          MAX(b) OVER w,\n          SUM(c) OVER w,\n          COUNT(c) OVER w,\n          MIN(c) OVER w,\n          MAX(c) OVER w,\n          SUM(d) OVER w,\n          COUNT(d) OVER w,\n          MIN(d) OVER w,\n          MAX(d) OVER w,\n          SUM(e) OVER w,\n          COUNT(e) OVER w,\n          MIN(e) OVER w,\n          MAX(e) OVER w,\n          SUM(f) OVER w,\n          COUNT(f) OVER w,\n          MIN(f) OVER w,\n          MAX(f) OVER w\n        FROM (\n            VALUES (1, 1, 1, 1, 1, 1, 1)\n        ) AS t(k, a, b, c, d, e, f)\n        WINDOW w AS (ORDER BY k ROWS BETWEEN 2 PRECEDING AND CURRENT ROW)\n")))).matches("VALUES (BIGINT '1', BIGINT '1', 1, 1, BIGINT '1', BIGINT '1', 1, 1, BIGINT '1', BIGINT '1', 1, 1, BIGINT '1', BIGINT '1', 1, 1, BIGINT '1', BIGINT '1', 1, 1, BIGINT '1', BIGINT '1', 1, 1)");
    }
}

