/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.routine;

import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.PlannerContext;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.routine.SqlRoutineAnalysis;
import io.trino.sql.routine.SqlRoutineAnalyzer;
import io.trino.sql.tree.FunctionSpecification;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.transaction.TestingTransactionManager;
import io.trino.transaction.TransactionBuilder;
import io.trino.transaction.TransactionManager;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;

class TestSqlRoutineAnalyzer {
    private static final SqlParser SQL_PARSER = new SqlParser();

    TestSqlRoutineAnalyzer() {
    }

    @Test
    void testParameters() {
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test(x) RETURNS int RETURN 123").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:15: Function parameters must have a name");
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test(x int, y int, x bigint) RETURNS int RETURN 123").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:29: Duplicate function parameter name: x");
    }

    @Test
    void testCharacteristics() {
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS int CALLED ON NULL INPUT CALLED ON NULL INPUT RETURN 123").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.SYNTAX_ERROR}).hasMessage("line 1:1: Multiple null-call clauses specified");
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS int RETURNS NULL ON NULL INPUT CALLED ON NULL INPUT RETURN 123").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.SYNTAX_ERROR}).hasMessage("line 1:1: Multiple null-call clauses specified");
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS int COMMENT 'abc' COMMENT 'xyz' RETURN 123").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.SYNTAX_ERROR}).hasMessage("line 1:1: Multiple comment clauses specified");
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS int LANGUAGE abc LANGUAGE xyz RETURN 123").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.SYNTAX_ERROR}).hasMessage("line 1:1: Multiple language clauses specified");
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS int NOT DETERMINISTIC DETERMINISTIC RETURN 123").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.SYNTAX_ERROR}).hasMessage("line 1:1: Multiple deterministic clauses specified");
    }

    @Test
    void testParameterTypeUnknown() {
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test(x abc) RETURNS int RETURN 123").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:15: Unknown type: abc");
    }

    @Test
    void testReturnTypeUnknown() {
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS abc RETURN 123").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:17: Unknown type: abc");
    }

    @Test
    void testReturnType() {
        TestSqlRoutineAnalyzer.analyze("FUNCTION test() RETURNS bigint RETURN smallint '123'");
        TestSqlRoutineAnalyzer.analyze("FUNCTION test() RETURNS varchar(10) RETURN 'test'");
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS varchar(2) RETURN 'test'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:43: Value of RETURN must evaluate to varchar(2) (actual: varchar(4))");
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS bigint RETURN random()").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:39: Value of RETURN must evaluate to bigint (actual: double)");
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS real RETURN random()").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:37: Value of RETURN must evaluate to real (actual: double)");
    }

    @Test
    void testLanguage() {
        Assertions.assertThat((Object)TestSqlRoutineAnalyzer.analyze("FUNCTION test() RETURNS bigint LANGUAGE SQL RETURN abs(-42)")).returns((Object)true, Assertions.from(SqlRoutineAnalysis::deterministic));
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS bigint LANGUAGE JAVASCRIPT RETURN abs(-42)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Unsupported language: JAVASCRIPT");
    }

    @Test
    void testDeterministic() {
        Assertions.assertThat((Object)TestSqlRoutineAnalyzer.analyze("FUNCTION test() RETURNS bigint RETURN abs(-42)")).returns((Object)true, Assertions.from(SqlRoutineAnalysis::deterministic));
        Assertions.assertThat((Object)TestSqlRoutineAnalyzer.analyze("FUNCTION test() RETURNS bigint DETERMINISTIC RETURN abs(-42)")).returns((Object)true, Assertions.from(SqlRoutineAnalysis::deterministic));
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS bigint NOT DETERMINISTIC RETURN abs(-42)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:1: Deterministic function declared NOT DETERMINISTIC");
        Assertions.assertThat((Object)TestSqlRoutineAnalyzer.analyze("FUNCTION test() RETURNS varchar RETURN reverse('test')")).returns((Object)true, Assertions.from(SqlRoutineAnalysis::deterministic));
        Assertions.assertThat((Object)TestSqlRoutineAnalyzer.analyze("FUNCTION test() RETURNS double NOT DETERMINISTIC RETURN 42 * random()")).returns((Object)false, Assertions.from(SqlRoutineAnalysis::deterministic));
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS double RETURN 42 * random()").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:1: Non-deterministic function declared DETERMINISTIC");
    }

    @Test
    void testIfConditionType() {
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS int\nBEGIN\n  IF random() THEN\n    RETURN 13;\n  END IF;\n  RETURN 0;\nEND\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 3:6: Condition of IF statement must evaluate to boolean (actual: double)");
    }

    @Test
    void testElseIfConditionType() {
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS int\nBEGIN\n  IF false THEN\n    RETURN 13;\n  ELSEIF random() THEN\n    RETURN 13;\n  END IF;\n  RETURN 0;\nEND\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 5:10: Condition of ELSEIF clause must evaluate to boolean (actual: double)");
    }

    @Test
    void testCaseWhenClauseValueType() {
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test(x int) RETURNS int\nBEGIN\n  CASE x\n    WHEN 13 THEN RETURN 13;\n    WHEN 'abc' THEN RETURN 42;\n  END CASE;\n  RETURN 0;\nEND\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 5:10: WHEN clause value must evaluate to CASE value type integer (actual: varchar(3))");
    }

    @Test
    void testCaseWhenClauseConditionType() {
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS int\nBEGIN\n  CASE\n    WHEN true THEN RETURN 42;\n    WHEN 13 THEN RETURN 13;\n  END CASE;\n  RETURN 0;\nEND\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 5:10: Condition of WHEN clause must evaluate to boolean (actual: integer)");
    }

    @Test
    void testMissingReturn() {
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS int BEGIN END").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_RETURN}).hasMessage("line 1:29: Function must end in a RETURN statement");
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS int\nBEGIN\n  IF false THEN\n    RETURN 13;\n  END IF;\nEND\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_RETURN}).hasMessage("line 2:1: Function must end in a RETURN statement");
    }

    @Test
    void testBadVariableDefault() {
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS int\nBEGIN\n  DECLARE x int DEFAULT 'abc';\n  RETURN 0;\nEND\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 3:25: Value of DEFAULT must evaluate to integer (actual: varchar(3))");
    }

    @Test
    void testVariableAlreadyDeclared() {
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS int\nBEGIN\n  DECLARE x int;\n  DECLARE x int;\n  RETURN 0;\nEND\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.ALREADY_EXISTS}).hasMessage("line 4:11: Variable already declared in this scope: x");
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS int\nBEGIN\n  DECLARE x int;\n  DECLARE y, x int;\n  RETURN 0;\nEND\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.ALREADY_EXISTS}).hasMessage("line 4:14: Variable already declared in this scope: x");
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS int\nBEGIN\n  DECLARE x, y, x int;\n  RETURN 0;\nEND\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.ALREADY_EXISTS}).hasMessage("line 3:17: Variable already declared in this scope: x");
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS int\nBEGIN\n  DECLARE x int;\n  BEGIN\n    DECLARE x int;\n  END;\n  RETURN 0;\nEND\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.ALREADY_EXISTS}).hasMessage("line 5:13: Variable already declared in this scope: x");
        TestSqlRoutineAnalyzer.analyze("FUNCTION test() RETURNS int\nBEGIN\n  BEGIN\n    DECLARE x int;\n  END;\n  BEGIN\n    DECLARE x varchar;\n  END;\n  RETURN 0;\nEND\n");
    }

    @Test
    void testAssignmentUnknownTarget() {
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS int\nBEGIN\n  SET x = 13;\n  RETURN 0;\nEND\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_FOUND}).hasMessage("line 3:7: Variable cannot be resolved: x");
    }

    @Test
    void testAssignmentType() {
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS int\nBEGIN\n  DECLARE x int;\n  SET x = 'abc';\n  RETURN 0;\nEND\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 4:11: Value of SET 'x' must evaluate to integer (actual: varchar(3))");
    }

    @Test
    void testWhileConditionType() {
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS int\nBEGIN\n  WHILE 13 DO\n    RETURN 0;\n  END WHILE;\n  RETURN 0;\nEND\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 3:9: Condition of WHILE statement must evaluate to boolean (actual: integer)");
    }

    @Test
    void testUntilConditionType() {
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS int\nBEGIN\n  REPEAT\n    RETURN 42;\n  UNTIL 13 END REPEAT;\n  RETURN 0;\nEND\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 5:9: Condition of REPEAT statement must evaluate to boolean (actual: integer)");
    }

    @Test
    void testIterateUnknownLabel() {
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS int\nBEGIN\n  WHILE true DO\n    ITERATE abc;\n  END WHILE;\n  RETURN 0;\nEND\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_FOUND}).hasMessage("line 4:13: Label not defined: abc");
    }

    @Test
    void testLeaveUnknownLabel() {
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS int\nBEGIN\n  LEAVE abc;\n  RETURN 0;\nEND\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_FOUND}).hasMessage("line 3:9: Label not defined: abc");
    }

    @Test
    void testDuplicateWhileLabel() {
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS int\nBEGIN\n  abc: WHILE true DO\n    LEAVE abc;\n    abc: WHILE true DO\n      LEAVE abc;\n    END WHILE;\n  END WHILE;\n  RETURN 0;\nEND\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.ALREADY_EXISTS}).hasMessage("line 5:5: Label already declared in this scope: abc");
        TestSqlRoutineAnalyzer.analyze("FUNCTION test() RETURNS int\nBEGIN\n  abc: WHILE true DO\n    LEAVE abc;\n  END WHILE;\n  abc: WHILE true DO\n    LEAVE abc;\n  END WHILE;\n  RETURN 0;\nEND\n");
    }

    @Test
    void testDuplicateRepeatLabel() {
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS int\nBEGIN\n  abc: REPEAT\n    LEAVE abc;\n    abc: REPEAT\n      LEAVE abc;\n    UNTIL true END REPEAT;\n  UNTIL true END REPEAT;\n  RETURN 0;\nEND\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.ALREADY_EXISTS}).hasMessage("line 5:5: Label already declared in this scope: abc");
        TestSqlRoutineAnalyzer.analyze("FUNCTION test() RETURNS int\nBEGIN\n  abc: REPEAT\n    LEAVE abc;\n  UNTIL true END REPEAT;\n  abc: REPEAT\n    LEAVE abc;\n  UNTIL true END REPEAT;\n  RETURN 0;\nEND\n");
    }

    @Test
    void testDuplicateLoopLabel() {
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS int\nBEGIN\n  abc: LOOP\n    LEAVE abc;\n    abc: LOOP\n      LEAVE abc;\n    END LOOP;\n  END LOOP;\n  RETURN 0;\nEND\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.ALREADY_EXISTS}).hasMessage("line 5:5: Label already declared in this scope: abc");
        TestSqlRoutineAnalyzer.analyze("FUNCTION test() RETURNS int\nBEGIN\n  abc: LOOP\n    LEAVE abc;\n  END LOOP;\n  abc: LOOP\n    LEAVE abc;\n  END LOOP;\n  RETURN 0;\nEND\n");
    }

    @Test
    void testSubquery() {
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS int RETURN (SELECT 123)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:36: Queries are not allowed in functions");
        TestSqlRoutineAnalyzer.assertFails("FUNCTION test() RETURNS int\nBEGIN\n  RETURN (SELECT 123);\nEND\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 3:10: Queries are not allowed in functions");
    }

    private static TrinoExceptionAssert assertFails(@Language(value="SQL") String function) {
        return TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestSqlRoutineAnalyzer.analyze(function));
    }

    private static SqlRoutineAnalysis analyze(@Language(value="SQL") String function) {
        FunctionSpecification specification = SQL_PARSER.createFunctionSpecification(function);
        TestingTransactionManager transactionManager = new TestingTransactionManager();
        PlannerContext plannerContext = TestingPlannerContext.plannerContextBuilder().withTransactionManager(transactionManager).build();
        return (SqlRoutineAnalysis)TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)plannerContext.getMetadata(), (AccessControl)new AllowAllAccessControl()).singleStatement().execute(TestingSession.testSession(), transactionSession -> {
            SqlRoutineAnalyzer analyzer = new SqlRoutineAnalyzer(plannerContext, WarningCollector.NOOP);
            return analyzer.analyze(transactionSession, (AccessControl)new AllowAllAccessControl(), specification);
        });
    }
}

