/*
 * Decompiled with CFR 0.152.
 */
package io.trino.transaction;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.metadata.CatalogManager;
import io.trino.metadata.CatalogMetadata;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingHandles;
import io.trino.testing.assertions.Assert;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionInfo;
import io.trino.transaction.TransactionManager;
import io.trino.transaction.TransactionManagerConfig;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestTransactionManager {
    private final ExecutorService finishingExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"transaction-%s"));

    @AfterAll
    public void tearDown() {
        this.finishingExecutor.shutdownNow();
    }

    @Test
    public void testTransactionWorkflow() {
        try (LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);){
            TransactionManager transactionManager = queryRunner.getTransactionManager();
            queryRunner.createCatalog("test_catalog", (ConnectorFactory)new TpchConnectorFactory(), (Map)ImmutableMap.of());
            TransactionId transactionId = transactionManager.beginTransaction(false);
            Assertions.assertThat((int)transactionManager.getAllTransactionInfos().size()).isEqualTo(1);
            TransactionInfo transactionInfo = transactionManager.getTransactionInfo(transactionId);
            Assertions.assertThat((boolean)transactionInfo.isAutoCommitContext()).isFalse();
            Assertions.assertThat((boolean)transactionInfo.getCatalogNames().isEmpty()).isTrue();
            Assertions.assertThat((boolean)transactionInfo.getWrittenCatalogName().isPresent()).isFalse();
            ConnectorMetadata metadata = ((CatalogMetadata)transactionManager.getOptionalCatalogMetadata(transactionId, "test_catalog").get()).getMetadata(SessionTestUtils.TEST_SESSION);
            metadata.listSchemaNames(SessionTestUtils.TEST_SESSION.toConnectorSession(TestingHandles.TEST_CATALOG_HANDLE));
            transactionInfo = transactionManager.getTransactionInfo(transactionId);
            Assertions.assertThat((List)transactionInfo.getCatalogNames()).isEqualTo((Object)ImmutableList.of((Object)"test_catalog"));
            Assertions.assertThat((boolean)transactionInfo.getWrittenCatalogName().isPresent()).isFalse();
            MoreFutures.getFutureValue((Future)transactionManager.asyncCommit(transactionId));
            Assertions.assertThat((boolean)transactionManager.getAllTransactionInfos().isEmpty()).isTrue();
        }
    }

    @Test
    public void testAbortedTransactionWorkflow() {
        try (LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);){
            TransactionManager transactionManager = queryRunner.getTransactionManager();
            queryRunner.createCatalog("test_catalog", (ConnectorFactory)new TpchConnectorFactory(), (Map)ImmutableMap.of());
            TransactionId transactionId = transactionManager.beginTransaction(false);
            Assertions.assertThat((int)transactionManager.getAllTransactionInfos().size()).isEqualTo(1);
            TransactionInfo transactionInfo = transactionManager.getTransactionInfo(transactionId);
            Assertions.assertThat((boolean)transactionInfo.isAutoCommitContext()).isFalse();
            Assertions.assertThat((boolean)transactionInfo.getCatalogNames().isEmpty()).isTrue();
            Assertions.assertThat((boolean)transactionInfo.getWrittenCatalogName().isPresent()).isFalse();
            ConnectorMetadata metadata = ((CatalogMetadata)transactionManager.getOptionalCatalogMetadata(transactionId, "test_catalog").get()).getMetadata(SessionTestUtils.TEST_SESSION);
            metadata.listSchemaNames(SessionTestUtils.TEST_SESSION.toConnectorSession(TestingHandles.TEST_CATALOG_HANDLE));
            transactionInfo = transactionManager.getTransactionInfo(transactionId);
            Assertions.assertThat((List)transactionInfo.getCatalogNames()).isEqualTo((Object)ImmutableList.of((Object)"test_catalog"));
            Assertions.assertThat((boolean)transactionInfo.getWrittenCatalogName().isPresent()).isFalse();
            MoreFutures.getFutureValue((Future)transactionManager.asyncAbort(transactionId));
            Assertions.assertThat((boolean)transactionManager.getAllTransactionInfos().isEmpty()).isTrue();
        }
    }

    @Test
    public void testFailedTransactionWorkflow() {
        try (LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);){
            TransactionManager transactionManager = queryRunner.getTransactionManager();
            queryRunner.createCatalog("test_catalog", (ConnectorFactory)new TpchConnectorFactory(), (Map)ImmutableMap.of());
            TransactionId transactionId = transactionManager.beginTransaction(false);
            Assertions.assertThat((int)transactionManager.getAllTransactionInfos().size()).isEqualTo(1);
            TransactionInfo transactionInfo = transactionManager.getTransactionInfo(transactionId);
            Assertions.assertThat((boolean)transactionInfo.isAutoCommitContext()).isFalse();
            Assertions.assertThat((boolean)transactionInfo.getCatalogNames().isEmpty()).isTrue();
            Assertions.assertThat((boolean)transactionInfo.getWrittenCatalogName().isPresent()).isFalse();
            ConnectorMetadata metadata = ((CatalogMetadata)transactionManager.getOptionalCatalogMetadata(transactionId, "test_catalog").get()).getMetadata(SessionTestUtils.TEST_SESSION);
            metadata.listSchemaNames(SessionTestUtils.TEST_SESSION.toConnectorSession(TestingHandles.TEST_CATALOG_HANDLE));
            transactionInfo = transactionManager.getTransactionInfo(transactionId);
            Assertions.assertThat((List)transactionInfo.getCatalogNames()).isEqualTo((Object)ImmutableList.of((Object)"test_catalog"));
            Assertions.assertThat((boolean)transactionInfo.getWrittenCatalogName().isPresent()).isFalse();
            transactionManager.fail(transactionId);
            Assertions.assertThat((int)transactionManager.getAllTransactionInfos().size()).isEqualTo(1);
            TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> transactionManager.getCatalogMetadata(transactionId, TestingHandles.TEST_CATALOG_HANDLE)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TRANSACTION_ALREADY_ABORTED});
            Assertions.assertThat((int)transactionManager.getAllTransactionInfos().size()).isEqualTo(1);
            MoreFutures.getFutureValue((Future)transactionManager.asyncAbort(transactionId));
            Assertions.assertThat((boolean)transactionManager.getAllTransactionInfos().isEmpty()).isTrue();
        }
    }

    @Test
    public void testExpiration() {
        try (IdleCheckExecutor executor = new IdleCheckExecutor();){
            TransactionManager transactionManager = InMemoryTransactionManager.create((TransactionManagerConfig)new TransactionManagerConfig().setIdleTimeout(new Duration(1.0, TimeUnit.MILLISECONDS)).setIdleCheckInterval(new Duration(5.0, TimeUnit.MILLISECONDS)), (ScheduledExecutorService)executor.getExecutor(), (CatalogManager)CatalogManager.NO_CATALOGS, (Executor)this.finishingExecutor);
            TransactionId transactionId = transactionManager.beginTransaction(false);
            Assertions.assertThat((int)transactionManager.getAllTransactionInfos().size()).isEqualTo(1);
            TransactionInfo transactionInfo = transactionManager.getTransactionInfo(transactionId);
            Assertions.assertThat((boolean)transactionInfo.isAutoCommitContext()).isFalse();
            Assertions.assertThat((boolean)transactionInfo.getCatalogNames().isEmpty()).isTrue();
            Assertions.assertThat((boolean)transactionInfo.getWrittenCatalogName().isPresent()).isFalse();
            transactionManager.trySetInactive(transactionId);
            Assert.assertEventually((Duration)new Duration(10.0, TimeUnit.SECONDS), () -> Assertions.assertThat((boolean)transactionManager.getAllTransactionInfos().isEmpty()).isTrue());
        }
    }

    private static class IdleCheckExecutor
    implements Closeable {
        private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"idle-check"));

        private IdleCheckExecutor() {
        }

        public ScheduledExecutorService getExecutor() {
            return this.executorService;
        }

        @Override
        public void close() {
            this.executorService.shutdownNow();
        }
    }
}

