/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.operator.scalar.ColorFunctions;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.Type;
import io.trino.type.AbstractTestType;
import io.trino.type.ColorType;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestColorType
extends AbstractTestType {
    public TestColorType() {
        super((Type)ColorType.COLOR, String.class, TestColorType.createTestBlock());
    }

    @Test
    public void testGetObjectValue() {
        int[] valuesOfInterest = new int[]{0, 1, 15, 16, 127, 128, 255};
        BlockBuilder builder = ColorType.COLOR.createFixedSizeBlockBuilder(valuesOfInterest.length * valuesOfInterest.length * valuesOfInterest.length);
        for (int r : valuesOfInterest) {
            for (int g : valuesOfInterest) {
                for (int b : valuesOfInterest) {
                    ColorType.COLOR.writeLong(builder, ColorFunctions.rgb((long)r, (long)g, (long)b));
                }
            }
        }
        Block block = builder.build();
        for (int position = 0; position < block.getPositionCount(); ++position) {
            int value = block.getInt(position, 0);
            Assertions.assertThat((Object)ColorType.COLOR.getObjectValue(null, block, position)).isEqualTo((Object)String.format("#%02x%02x%02x", value >> 16 & 0xFF, value >> 8 & 0xFF, value & 0xFF));
        }
    }

    public static ValueBlock createTestBlock() {
        BlockBuilder blockBuilder = ColorType.COLOR.createBlockBuilder(null, 15);
        ColorType.COLOR.writeLong(blockBuilder, ColorFunctions.rgb((long)1L, (long)1L, (long)1L));
        ColorType.COLOR.writeLong(blockBuilder, ColorFunctions.rgb((long)1L, (long)1L, (long)1L));
        ColorType.COLOR.writeLong(blockBuilder, ColorFunctions.rgb((long)1L, (long)1L, (long)1L));
        ColorType.COLOR.writeLong(blockBuilder, ColorFunctions.rgb((long)2L, (long)2L, (long)2L));
        ColorType.COLOR.writeLong(blockBuilder, ColorFunctions.rgb((long)2L, (long)2L, (long)2L));
        ColorType.COLOR.writeLong(blockBuilder, ColorFunctions.rgb((long)2L, (long)2L, (long)2L));
        ColorType.COLOR.writeLong(blockBuilder, ColorFunctions.rgb((long)2L, (long)2L, (long)2L));
        ColorType.COLOR.writeLong(blockBuilder, ColorFunctions.rgb((long)2L, (long)2L, (long)2L));
        ColorType.COLOR.writeLong(blockBuilder, ColorFunctions.rgb((long)3L, (long)3L, (long)3L));
        ColorType.COLOR.writeLong(blockBuilder, ColorFunctions.rgb((long)3L, (long)3L, (long)3L));
        ColorType.COLOR.writeLong(blockBuilder, ColorFunctions.rgb((long)4L, (long)4L, (long)4L));
        return blockBuilder.buildValueBlock();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Test
    public void testRange() {
        Assertions.assertThat((Optional)this.type.getRange()).isEmpty();
    }

    @Test
    public void testPreviousValue() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.type.getPreviousValue(this.getSampleValue())).isInstanceOf(IllegalStateException.class)).hasMessage("Type is not orderable: " + this.type);
    }

    @Test
    public void testNextValue() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.type.getNextValue(this.getSampleValue())).isInstanceOf(IllegalStateException.class)).hasMessage("Type is not orderable: " + this.type);
    }
}

