/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestSmallintOperators {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testLiteral() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SMALLINT '37'")))).isEqualTo((short)37);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SMALLINT '17'")))).isEqualTo((short)17);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("SMALLINT '32768'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
    }

    @Test
    public void testUnaryPlus() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("+SMALLINT '37'")))).isEqualTo((short)37);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("+SMALLINT '17'")))).isEqualTo((short)17);
    }

    @Test
    public void testUnaryMinus() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SMALLINT '-37'")))).isEqualTo((short)-37);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("SMALLINT '-17'")))).isEqualTo((short)-17);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("SMALLINT '--32768'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
    }

    @Test
    public void testAdd() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "SMALLINT '37'", "SMALLINT '37'")))).isEqualTo((short)74);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "SMALLINT '37'", "SMALLINT '17'")))).isEqualTo((short)54);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "SMALLINT '17'", "SMALLINT '37'")))).isEqualTo((short)54);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "SMALLINT '17'", "SMALLINT '17'")))).isEqualTo((short)34);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression(String.format("SMALLINT '%s' + SMALLINT '1'", (short)Short.MAX_VALUE))::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("smallint addition overflow: 32767 + 1");
    }

    @Test
    public void testSubtract() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "SMALLINT '37'", "SMALLINT '37'")))).isEqualTo((short)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "SMALLINT '37'", "SMALLINT '17'")))).isEqualTo((short)20);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "SMALLINT '17'", "SMALLINT '37'")))).isEqualTo((short)-20);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "SMALLINT '17'", "SMALLINT '17'")))).isEqualTo((short)0);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression(String.format("SMALLINT '%s' - SMALLINT '1'", (short)Short.MIN_VALUE))::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("smallint subtraction overflow: -32768 - 1");
    }

    @Test
    public void testMultiply() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "SMALLINT '37'", "SMALLINT '37'")))).isEqualTo((short)1369);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "SMALLINT '37'", "SMALLINT '17'")))).isEqualTo((short)629);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "SMALLINT '17'", "SMALLINT '37'")))).isEqualTo((short)629);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "SMALLINT '17'", "SMALLINT '17'")))).isEqualTo((short)289);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression(String.format("SMALLINT '%s' * SMALLINT '2'", (short)Short.MAX_VALUE))::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("smallint multiplication overflow: 32767 * 2");
    }

    @Test
    public void testDivide() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "SMALLINT '37'", "SMALLINT '37'")))).isEqualTo((short)1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "SMALLINT '37'", "SMALLINT '17'")))).isEqualTo((short)2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "SMALLINT '17'", "SMALLINT '37'")))).isEqualTo((short)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "SMALLINT '17'", "SMALLINT '17'")))).isEqualTo((short)1);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.DIVIDE, "SMALLINT '17'", "SMALLINT '0'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
    }

    @Test
    public void testModulus() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "SMALLINT '37'", "SMALLINT '37'")))).isEqualTo((short)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "SMALLINT '37'", "SMALLINT '17'")))).isEqualTo((short)3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "SMALLINT '17'", "SMALLINT '37'")))).isEqualTo((short)17);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "SMALLINT '17'", "SMALLINT '17'")))).isEqualTo((short)0);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.MODULUS, "SMALLINT '17'", "SMALLINT '0'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DIVISION_BY_ZERO});
    }

    @Test
    public void testNegation() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "(SMALLINT '37')")))).isEqualTo((short)-37);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "(SMALLINT '17')")))).isEqualTo((short)-17);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("-(SMALLINT '32767')")))).isEqualTo((short)-32767);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression(String.format("-(SMALLINT '%s')", (short)Short.MIN_VALUE))::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("smallint negation overflow: -32768");
    }

    @Test
    public void testEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "SMALLINT '37'", "SMALLINT '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "SMALLINT '37'", "SMALLINT '17'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "SMALLINT '17'", "SMALLINT '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "SMALLINT '17'", "SMALLINT '17'")))).isEqualTo(true);
    }

    @Test
    public void testNotEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "SMALLINT '37'").binding("b", "SMALLINT '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "SMALLINT '37'").binding("b", "SMALLINT '17'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "SMALLINT '17'").binding("b", "SMALLINT '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "SMALLINT '17'").binding("b", "SMALLINT '17'")))).isEqualTo(false);
    }

    @Test
    public void testLessThan() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "SMALLINT '37'", "SMALLINT '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "SMALLINT '37'", "SMALLINT '17'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "SMALLINT '17'", "SMALLINT '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "SMALLINT '17'", "SMALLINT '17'")))).isEqualTo(false);
    }

    @Test
    public void testLessThanOrEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "SMALLINT '37'", "SMALLINT '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "SMALLINT '37'", "SMALLINT '17'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "SMALLINT '17'", "SMALLINT '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "SMALLINT '17'", "SMALLINT '17'")))).isEqualTo(true);
    }

    @Test
    public void testGreaterThan() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "SMALLINT '37'").binding("b", "SMALLINT '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "SMALLINT '37'").binding("b", "SMALLINT '17'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "SMALLINT '17'").binding("b", "SMALLINT '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "SMALLINT '17'").binding("b", "SMALLINT '17'")))).isEqualTo(false);
    }

    @Test
    public void testGreaterThanOrEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "SMALLINT '37'").binding("b", "SMALLINT '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "SMALLINT '37'").binding("b", "SMALLINT '17'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "SMALLINT '17'").binding("b", "SMALLINT '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "SMALLINT '17'").binding("b", "SMALLINT '17'")))).isEqualTo(true);
    }

    @Test
    public void testBetween() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "SMALLINT '37'").binding("low", "SMALLINT '37'").binding("high", "SMALLINT '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "SMALLINT '37'").binding("low", "SMALLINT '37'").binding("high", "SMALLINT '17'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "SMALLINT '37'").binding("low", "SMALLINT '17'").binding("high", "SMALLINT '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "SMALLINT '37'").binding("low", "SMALLINT '17'").binding("high", "SMALLINT '17'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "SMALLINT '17'").binding("low", "SMALLINT '37'").binding("high", "SMALLINT '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "SMALLINT '17'").binding("low", "SMALLINT '37'").binding("high", "SMALLINT '17'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "SMALLINT '17'").binding("low", "SMALLINT '17'").binding("high", "SMALLINT '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "SMALLINT '17'").binding("low", "SMALLINT '17'").binding("high", "SMALLINT '17'")))).isEqualTo(true);
    }

    @Test
    public void testCastToBigint() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as bigint)").binding("a", "SMALLINT '37'")))).isEqualTo(37L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as bigint)").binding("a", "SMALLINT '17'")))).isEqualTo(17L);
    }

    @Test
    public void testCastToInteger() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as integer)").binding("a", "SMALLINT '37'")))).isEqualTo(37);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as integer)").binding("a", "SMALLINT '17'")))).isEqualTo(17);
    }

    @Test
    public void testCastToTinyint() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as tinyint)").binding("a", "SMALLINT '37'")))).isEqualTo((byte)37);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as tinyint)").binding("a", "SMALLINT '17'")))).isEqualTo((byte)17);
    }

    @Test
    public void testCastToVarchar() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar)").binding("a", "SMALLINT '37'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("37");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar)").binding("a", "SMALLINT '17'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("17");
        VarcharType type1 = VarcharType.createVarcharType((int)3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar(3))").binding("a", "SMALLINT '123'")))).hasType((Type)type1).isEqualTo("123");
        VarcharType type = VarcharType.createVarcharType((int)50);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar(50))").binding("a", "SMALLINT '123'")))).hasType((Type)type).isEqualTo("123");
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as varchar(2))").binding("a", "SMALLINT '123'").evaluate()).hasMessage("Value 123 cannot be represented as varchar(2)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testCastToDouble() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as double)").binding("a", "SMALLINT '37'")))).isEqualTo(37.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as double)").binding("a", "SMALLINT '17'")))).isEqualTo(17.0);
    }

    @Test
    public void testCastToFloat() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as real)").binding("a", "SMALLINT '37'")))).isEqualTo(Float.valueOf(37.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as real)").binding("a", "SMALLINT '-32768'")))).isEqualTo(Float.valueOf(-32768.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as real)").binding("a", "SMALLINT '0'")))).isEqualTo(Float.valueOf(0.0f));
    }

    @Test
    public void testCastToBoolean() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as boolean)").binding("a", "SMALLINT '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as boolean)").binding("a", "SMALLINT '17'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as boolean)").binding("a", "SMALLINT '0'")))).isEqualTo(false);
    }

    @Test
    public void testCastFromVarchar() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as smallint)").binding("a", "'37'")))).isEqualTo((short)37);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as smallint)").binding("a", "'17'")))).isEqualTo((short)17);
    }

    @Test
    public void testIsDistinctFrom() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "cast(NULL as SMALLINT)", "CAST(NULL AS SMALLINT)")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "SMALLINT '37'", "SMALLINT '37'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "SMALLINT '37'", "SMALLINT '38'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "NULL", "SMALLINT '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "SMALLINT '37'", "NULL")))).isEqualTo(true);
    }

    @Test
    public void testIndeterminate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "cast(null as smallint)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "cast(12 as smallint)")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "cast(0 as smallint)")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "cast(-23 as smallint)")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "cast(1.4 as smallint)")))).isEqualTo(false);
    }
}

