/*
 * Decompiled with CFR 0.152.
 */
package io.trino.version;

import io.trino.version.EmbedVersion;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestEmbedVersion {
    private final EmbedVersion embedVersion = new EmbedVersion("123-some-test-version");

    @Test
    public void testEmbedVersionInRunnable() {
        AtomicInteger counter = new AtomicInteger();
        this.embedVersion.embedVersion(counter::incrementAndGet).run();
        Assertions.assertThat((int)counter.get()).isEqualTo(1);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.embedVersion.embedVersion(() -> {
            throw new RuntimeException("Zonky zonk");
        }).run()).isInstanceOf(RuntimeException.class)).hasMessage("Zonky zonk").hasStackTraceContaining("at io.trino.$gen.Trino_123_some_test_version____");
    }

    @Test
    public void testEmbedVersionInCallable() throws Exception {
        AtomicInteger counter = new AtomicInteger();
        String value = (String)this.embedVersion.embedVersion(() -> "abc" + counter.incrementAndGet()).call();
        Assertions.assertThat((String)value).isEqualTo("abc1");
        Assertions.assertThat((int)counter.get()).isEqualTo(1);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.embedVersion.embedVersion(() -> {
            throw new RuntimeException("Zonky zonk");
        }).call()).isInstanceOf(RuntimeException.class)).hasMessage("Zonky zonk").hasStackTraceContaining("at io.trino.$gen.Trino_123_some_test_version____").hasNoCause();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.embedVersion.embedVersion(() -> {
            throw new IOException("a checked exception");
        }).call()).isInstanceOf(IOException.class)).hasMessage("a checked exception").hasStackTraceContaining("at io.trino.$gen.Trino_123_some_test_version____").hasNoCause();
    }
}

