/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.regex.Pattern;

public class ConnectorName {
    private static final Pattern VALID_NAME = Pattern.compile("[a-z][a-z0-9_]*");
    private final String name;

    @JsonCreator
    public ConnectorName(String name) {
        Objects.requireNonNull(name, "name is null");
        Preconditions.checkArgument((boolean)VALID_NAME.matcher(name).matches(), (String)"Invalid connector name: %s", (Object)name);
        this.name = Objects.requireNonNull(name, "name is null");
    }

    @JsonValue
    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectorName that = (ConnectorName)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

