/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import com.google.inject.Inject;
import io.trino.FullConnectorSession;
import io.trino.Session;
import io.trino.metadata.CatalogInfo;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataListing;
import io.trino.metadata.MetadataUtil;
import io.trino.security.AccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Objects;

public class CatalogSystemTable
implements SystemTable {
    public static final SchemaTableName CATALOG_TABLE_NAME = new SchemaTableName("metadata", "catalogs");
    public static final ConnectorTableMetadata CATALOG_TABLE = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(CATALOG_TABLE_NAME).column("catalog_name", (Type)VarcharType.createUnboundedVarcharType()).column("connector_id", (Type)VarcharType.createUnboundedVarcharType()).column("connector_name", (Type)VarcharType.createUnboundedVarcharType()).build();
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public CatalogSystemTable(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return CATALOG_TABLE;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession connectorSession, TupleDomain<Integer> constraint) {
        Session session = ((FullConnectorSession)connectorSession).getSession();
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)CATALOG_TABLE);
        for (CatalogInfo catalogInfo : MetadataListing.listCatalogs(session, this.metadata, this.accessControl)) {
            table.addRow(new Object[]{catalogInfo.getCatalogName(), catalogInfo.getCatalogName(), catalogInfo.getConnectorName().toString()});
        }
        return table.build().cursor();
    }
}

