/*
 * Decompiled with CFR 0.152.
 */
package io.trino.dispatcher;

import com.google.common.io.Closer;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import io.airlift.concurrent.ThreadPoolExecutorMBean;
import io.airlift.concurrent.Threads;
import io.trino.dispatcher.DecoratingListeningExecutorService;
import io.trino.execution.QueryManagerConfig;
import io.trino.spi.VersionEmbedder;
import jakarta.annotation.PreDestroy;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class DispatchExecutor {
    private final Closer closer = Closer.create();
    private final ListeningExecutorService executor;
    private final ListeningScheduledExecutorService scheduledExecutor;
    private final DispatchExecutorMBeans mbeans;

    @Inject
    public DispatchExecutor(QueryManagerConfig config, final VersionEmbedder versionEmbedder) {
        ExecutorService coreExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"dispatcher-query-%s"));
        this.closer.register(coreExecutor::shutdownNow);
        this.executor = new DecoratingListeningExecutorService(MoreExecutors.listeningDecorator((ExecutorService)coreExecutor), new DecoratingListeningExecutorService.TaskDecorator(){

            @Override
            public Runnable decorate(Runnable command) {
                return versionEmbedder.embedVersion(command);
            }

            @Override
            public <T> Callable<T> decorate(Callable<T> task) {
                return versionEmbedder.embedVersion(task);
            }
        });
        ScheduledExecutorService coreScheduledExecutor = Executors.newScheduledThreadPool(config.getQueryManagerExecutorPoolSize(), Threads.daemonThreadsNamed((String)"dispatch-executor-%s"));
        this.closer.register(coreScheduledExecutor::shutdownNow);
        this.scheduledExecutor = MoreExecutors.listeningDecorator((ScheduledExecutorService)coreScheduledExecutor);
        this.mbeans = new DispatchExecutorMBeans(coreExecutor, coreScheduledExecutor);
    }

    public ListeningExecutorService getExecutor() {
        return this.executor;
    }

    public ListeningScheduledExecutorService getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    @Managed
    @Flatten
    public DispatchExecutorMBeans getMbeans() {
        return this.mbeans;
    }

    @PreDestroy
    public void shutdown() throws Exception {
        this.closer.close();
    }

    public static class DispatchExecutorMBeans {
        private final ThreadPoolExecutorMBean executor;
        private final ThreadPoolExecutorMBean scheduledExecutor;

        public DispatchExecutorMBeans(ExecutorService coreExecutor, ScheduledExecutorService coreScheduledExecutor) {
            Objects.requireNonNull(coreExecutor, "coreExecutor is null");
            Objects.requireNonNull(coreScheduledExecutor, "coreScheduledExecutor is null");
            this.executor = new ThreadPoolExecutorMBean((ThreadPoolExecutor)coreExecutor);
            this.scheduledExecutor = new ThreadPoolExecutorMBean((ThreadPoolExecutor)((Object)coreScheduledExecutor));
        }

        @Managed
        @Nested
        public ThreadPoolExecutorMBean getExecutor() {
            return this.executor;
        }

        @Managed
        @Nested
        public ThreadPoolExecutorMBean getScheduledExecutor() {
            return this.scheduledExecutor;
        }
    }
}

