/*
 * Decompiled with CFR 0.152.
 */
package io.trino.dispatcher;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.client.NodeVersion;
import io.trino.dispatcher.DispatchInfo;
import io.trino.dispatcher.DispatchQuery;
import io.trino.execution.ExecutionFailureInfo;
import io.trino.execution.Input;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryState;
import io.trino.execution.QueryStats;
import io.trino.execution.StateMachine;
import io.trino.operator.BlockedReason;
import io.trino.operator.OperatorStats;
import io.trino.operator.RetryPolicy;
import io.trino.server.BasicQueryInfo;
import io.trino.server.DynamicFilterService;
import io.trino.spi.ErrorCode;
import io.trino.spi.QueryId;
import io.trino.spi.TrinoWarning;
import io.trino.spi.eventlistener.QueryPlanOptimizerStatistics;
import io.trino.spi.eventlistener.RoutineInfo;
import io.trino.spi.eventlistener.StageGcStatistics;
import io.trino.spi.eventlistener.TableInfo;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.security.SelectedRole;
import io.trino.util.Failures;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;

public class FailedDispatchQuery
implements DispatchQuery {
    private final QueryInfo fullQueryInfo;
    private final BasicQueryInfo basicQueryInfo;
    private final Session session;
    private final Executor executor;
    private final DispatchInfo dispatchInfo;

    public FailedDispatchQuery(Session session, String query, Optional<String> preparedQuery, URI self, Optional<ResourceGroupId> resourceGroup, Throwable cause, Executor executor, NodeVersion version) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(query, "query is null");
        Objects.requireNonNull(self, "self is null");
        Objects.requireNonNull(resourceGroup, "resourceGroup is null");
        Objects.requireNonNull(cause, "cause is null");
        Objects.requireNonNull(executor, "executor is null");
        this.fullQueryInfo = FailedDispatchQuery.immediateFailureQueryInfo(session, query, preparedQuery, self, resourceGroup, cause, version);
        this.basicQueryInfo = new BasicQueryInfo(this.fullQueryInfo);
        this.session = Objects.requireNonNull(session, "session is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.dispatchInfo = DispatchInfo.failed(this.fullQueryInfo.getFailureInfo(), this.basicQueryInfo.getQueryStats().getElapsedTime(), this.basicQueryInfo.getQueryStats().getQueuedTime());
    }

    @Override
    public BasicQueryInfo getBasicQueryInfo() {
        return this.basicQueryInfo;
    }

    @Override
    public QueryInfo getFullQueryInfo() {
        return this.fullQueryInfo;
    }

    @Override
    public QueryState getState() {
        return this.fullQueryInfo.getState();
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public ListenableFuture<Void> getDispatchedFuture() {
        return Futures.immediateVoidFuture();
    }

    @Override
    public DispatchInfo getDispatchInfo() {
        return this.dispatchInfo;
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.executor.execute(() -> stateChangeListener.stateChanged(QueryState.FAILED));
    }

    @Override
    public void startWaitingForResources() {
    }

    @Override
    public void fail(Throwable throwable) {
    }

    @Override
    public void cancel() {
    }

    @Override
    public void pruneInfo() {
    }

    @Override
    public QueryId getQueryId() {
        return this.basicQueryInfo.getQueryId();
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public Optional<ErrorCode> getErrorCode() {
        return Optional.ofNullable(this.basicQueryInfo.getErrorCode());
    }

    @Override
    public void recordHeartbeat() {
    }

    @Override
    public DateTime getLastHeartbeat() {
        return this.basicQueryInfo.getQueryStats().getEndTime();
    }

    @Override
    public DateTime getCreateTime() {
        return this.basicQueryInfo.getQueryStats().getCreateTime();
    }

    @Override
    public Optional<DateTime> getExecutionStartTime() {
        return this.getEndTime();
    }

    @Override
    public Optional<Duration> getPlanningTime() {
        return Optional.empty();
    }

    @Override
    public Optional<DateTime> getEndTime() {
        return Optional.ofNullable(this.basicQueryInfo.getQueryStats().getEndTime());
    }

    @Override
    public Duration getTotalCpuTime() {
        return new Duration(0.0, TimeUnit.MILLISECONDS);
    }

    @Override
    public DataSize getTotalMemoryReservation() {
        return DataSize.ofBytes((long)0L);
    }

    @Override
    public DataSize getUserMemoryReservation() {
        return DataSize.ofBytes((long)0L);
    }

    private static QueryInfo immediateFailureQueryInfo(Session session, String query, Optional<String> preparedQuery, URI self, Optional<ResourceGroupId> resourceGroupId, Throwable throwable, NodeVersion version) {
        ExecutionFailureInfo failureCause = Failures.toFailure(throwable);
        QueryInfo queryInfo = new QueryInfo(session.getQueryId(), session.toSessionRepresentation(), QueryState.FAILED, self, (List<String>)ImmutableList.of(), query, preparedQuery, FailedDispatchQuery.immediateFailureQueryStats(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), false, (Map<String, String>)ImmutableMap.of(), (Set<String>)ImmutableSet.of(), (Map<String, SelectedRole>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of(), (Set<String>)ImmutableSet.of(), Optional.empty(), false, null, Optional.empty(), failureCause, failureCause.getErrorCode(), (List<TrinoWarning>)ImmutableList.of(), (Set<Input>)ImmutableSet.of(), Optional.empty(), (List<TableInfo>)ImmutableList.of(), (List<RoutineInfo>)ImmutableList.of(), true, resourceGroupId, Optional.empty(), RetryPolicy.NONE, false, version);
        return queryInfo;
    }

    private static QueryStats immediateFailureQueryStats() {
        DateTime now = DateTime.now();
        return new QueryStats(now, now, now, now, new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0, 0.0, DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), false, OptionalDouble.empty(), OptionalDouble.empty(), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), false, (Set<BlockedReason>)ImmutableSet.of(), DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), 0L, 0L, new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), 0L, 0L, DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), 0L, 0L, DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), 0L, 0L, new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), 0L, 0L, new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), (List<StageGcStatistics>)ImmutableList.of(), DynamicFilterService.DynamicFiltersStats.EMPTY, (List<OperatorStats>)ImmutableList.of(), (List<QueryPlanOptimizerStatistics>)ImmutableList.of());
    }
}

