/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.executor.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.ThreadSafe;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.Semaphore;

@ThreadSafe
final class Reservation<T> {
    private final Semaphore semaphore;
    private final Set<T> reservations = new HashSet<T>();

    public Reservation(int slots) {
        this.semaphore = new Semaphore(slots);
    }

    public int availablePermits() {
        return this.semaphore.availablePermits();
    }

    public void reserve() throws InterruptedException {
        this.semaphore.acquire();
    }

    public synchronized void register(T entry) {
        Preconditions.checkArgument((!this.reservations.contains(entry) ? 1 : 0) != 0, (String)"Already acquired: %s", entry);
        this.reservations.add(entry);
    }

    public synchronized void release(T entry) {
        Preconditions.checkArgument((boolean)this.reservations.contains(entry), (String)"Already released: %s", entry);
        this.reservations.remove(entry);
        this.semaphore.release();
    }

    public synchronized Set<T> reservations() {
        return ImmutableSet.copyOf(this.reservations);
    }

    public synchronized String toString() {
        return new StringJoiner(", ", Reservation.class.getSimpleName() + "[", "]").add("semaphore=" + this.semaphore).add("reservations=" + this.reservations).toString();
    }
}

