/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.ThreadSafe;
import io.trino.execution.buffer.PipelinedOutputBuffers;
import io.trino.execution.scheduler.PipelinedOutputBufferManager;
import io.trino.sql.planner.PartitioningHandle;
import java.util.Map;
import java.util.Objects;

@ThreadSafe
public class PartitionedPipelinedOutputBufferManager
implements PipelinedOutputBufferManager {
    private final PipelinedOutputBuffers outputBuffers;

    public PartitionedPipelinedOutputBufferManager(PartitioningHandle partitioningHandle, int partitionCount) {
        Preconditions.checkArgument((partitionCount >= 1 ? 1 : 0) != 0, (Object)"partitionCount must be at least 1");
        ImmutableMap.Builder partitions = ImmutableMap.builder();
        for (int partition = 0; partition < partitionCount; ++partition) {
            partitions.put((Object)new PipelinedOutputBuffers.OutputBufferId(partition), (Object)partition);
        }
        this.outputBuffers = PipelinedOutputBuffers.createInitial(Objects.requireNonNull(partitioningHandle, "partitioningHandle is null")).withBuffers((Map<PipelinedOutputBuffers.OutputBufferId, Integer>)partitions.buildOrThrow()).withNoMoreBufferIds();
    }

    @Override
    public void addOutputBuffer(PipelinedOutputBuffers.OutputBufferId newBuffer) {
        Integer existingBufferId = this.outputBuffers.getBuffers().get(newBuffer);
        if (existingBufferId == null) {
            throw new IllegalStateException("Unexpected new output buffer " + newBuffer);
        }
        if (newBuffer.getId() != existingBufferId.intValue()) {
            throw new IllegalStateException("newOutputBuffers has changed the assignment for task " + newBuffer);
        }
    }

    @Override
    public void noMoreBuffers() {
    }

    @Override
    public PipelinedOutputBuffers getOutputBuffers() {
        return this.outputBuffers;
    }
}

